<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractFilterForm.class.php";

define('FAQ_SORT_KEY_DEFAULT', 0);
define('FAQ_SORT_KEY_FAQ_ID', 1);
define('FAQ_SORT_KEY_CATEGORY_ID', 2);
define('FAQ_SORT_KEY_SUBJECT', 3);
define('FAQ_SORT_KEY_BODY', 4);
define('FAQ_SORT_KEY_CREATE_UNIXTIME', 5);
define('FAQ_SORT_KEY_UPDATE_UNIXTIME', 6);
define('FAQ_SORT_KEY_MAXVALUE', 6);

class Cuestion_FaqFilterForm extends Cuestion_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		FAQ_SORT_KEY_DEFAULT => 'faq_id',
		FAQ_SORT_KEY_FAQ_ID => 'faq_id',
		FAQ_SORT_KEY_CATEGORY_ID => 'category_id',
		FAQ_SORT_KEY_SUBJECT => 'subject',
		FAQ_SORT_KEY_BODY => 'body',
		FAQ_SORT_KEY_CREATE_UNIXTIME => 'create_unixtime',
		FAQ_SORT_KEY_UPDATE_UNIXTIME => 'update_unixtime'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > FAQ_SORT_KEY_MAXVALUE) {
			$this->mSort = FAQ_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['faq_id'])) {
			$this->_mNavi->addExtra('faq_id', xoops_getrequest('faq_id'));
			$this->_mCriteria->add(new Criteria('faq_id', array(XOBJ_DTYPE_INT, xoops_getrequest('faq_id'))));
		}
	
		if (isset($_REQUEST['category_id'])) {
			$this->_mNavi->addExtra('category_id', xoops_getrequest('category_id'));
			$this->_mCriteria->add(new Criteria('category_id', array(XOBJ_DTYPE_INT, xoops_getrequest('category_id'))));
		}
	
		if (isset($_REQUEST['subject'])) {
			$this->_mNavi->addExtra('subject', xoops_getrequest('subject'));
			$this->_mCriteria->add(new Criteria('subject', array(XOBJ_DTYPE_STRING, xoops_getrequest('subject'))));
		}
	
		if (isset($_REQUEST['create_unixtime'])) {
			$this->_mNavi->addExtra('create_unixtime', xoops_getrequest('create_unixtime'));
			$this->_mCriteria->add(new Criteria('create_unixtime', array(XOBJ_DTYPE_INT, xoops_getrequest('create_unixtime'))));
		}
	
		if (isset($_REQUEST['update_unixtime'])) {
			$this->_mNavi->addExtra('update_unixtime', xoops_getrequest('update_unixtime'));
			$this->_mCriteria->add(new Criteria('update_unixtime', array(XOBJ_DTYPE_INT, xoops_getrequest('update_unixtime'))));
		}
	}
}

?>
