<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Cuestion_KeyqlinkAdminEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.cuestion.KeyqlinkAdminEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['keyqlink_id'] =& new XCube_IntProperty('keyqlink_id');
		$this->mFormProperties['question_id'] =& new XCube_IntProperty('question_id');
		$this->mFormProperties['keyword_id'] =& new XCube_IntProperty('keyword_id');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['keyqlink_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['keyqlink_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['keyqlink_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_KEYQLINK_ID);
	
		$this->mFieldProperties['question_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['question_id']->setDependsByArray(array('required','objectExsist'));
		$this->mFieldProperties['question_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_QUESTION_ID);
		$this->mFieldProperties['question_id']->addMessage('objectExist', _AD_CUESTION_ERROR_OBJECT_EXIST, _AD_CUESTION_LANG_QUESTION_ID);
		$this->mFieldProperties['question_id']->addVar('handler', 'question');
	
		$this->mFieldProperties['keyword_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['keyword_id']->setDependsByArray(array('required','objectExsist'));
		$this->mFieldProperties['keyword_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_KEYWORD_ID);
		$this->mFieldProperties['keyword_id']->addMessage('objectExist', _AD_CUESTION_ERROR_OBJECT_EXIST, _AD_CUESTION_LANG_KEYWORD_ID);
		$this->mFieldProperties['keyword_id']->addVar('handler', 'keyword');
	}

	function load(&$obj)
	{
		$this->set('keyqlink_id', $obj->get('keyqlink_id'));
		$this->set('question_id', $obj->get('question_id'));
		$this->set('keyword_id', $obj->get('keyword_id'));
	}

	function update(&$obj)
	{
		$obj->set('keyqlink_id', $this->get('keyqlink_id'));
		$obj->set('question_id', $this->get('question_id'));
		$obj->set('keyword_id', $this->get('keyword_id'));
	}
}

?>
