<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Cuestion_KeywordAdminEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.cuestion.KeywordAdminEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['keyword_id'] =& new XCube_IntProperty('keyword_id');
		$this->mFormProperties['name'] =& new XCube_StringProperty('name');
		$this->mFormProperties['priority'] =& new XCube_IntProperty('priority');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['keyword_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['keyword_id']->setDependsByArray(array('required','objectExsist'));
		$this->mFieldProperties['keyword_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_KEYWORD_ID);
		$this->mFieldProperties['keyword_id']->addMessage('objectExist', _AD_CUESTION_ERROR_OBJECT_EXIST, _AD_CUESTION_LANG_KEYWORD_ID);
		$this->mFieldProperties['keyword_id']->addVar('handler', 'keyqlink');
	
		$this->mFieldProperties['name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['name']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['name']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_NAME, '255');
		$this->mFieldProperties['name']->addMessage('maxlength', _AD_CUESTION_ERROR_MAXLENGTH, _AD_CUESTION_LANG_NAME, '255');
		$this->mFieldProperties['name']->addVar('maxlength', '255');
	
		$this->mFieldProperties['priority'] =& new XCube_FieldProperty($this);
	}

	function load(&$obj)
	{
		$this->set('keyword_id', $obj->get('keyword_id'));
		$this->set('name', $obj->get('name'));
		$this->set('priority', $obj->get('priority'));
	}

	function update(&$obj)
	{
		$obj->set('keyword_id', $this->get('keyword_id'));
		$obj->set('name', $this->get('name'));
		$obj->set('priority', $this->get('priority'));
	}
}

?>
