<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractFilterForm.class.php";

define('KEYWORD_SORT_KEY_DEFAULT', 0);
define('KEYWORD_SORT_KEY_KEYWORD_ID', 1);
define('KEYWORD_SORT_KEY_NAME', 2);
define('KEYWORD_SORT_KEY_PRIORITY', 3);
define('KEYWORD_SORT_KEY_MAXVALUE', 3);

class Cuestion_KeywordFilterForm extends Cuestion_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		KEYWORD_SORT_KEY_DEFAULT => 'keyword_id',
		KEYWORD_SORT_KEY_KEYWORD_ID => 'keyword_id',
		KEYWORD_SORT_KEY_NAME => 'name',
		KEYWORD_SORT_KEY_PRIORITY => 'priority'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > KEYWORD_SORT_KEY_MAXVALUE) {
			$this->mSort = KEYWORD_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['keyword_id'])) {
			$this->_mNavi->addExtra('keyword_id', xoops_getrequest('keyword_id'));
			$this->_mCriteria->add(new Criteria('keyword_id', array(XOBJ_DTYPE_INT, xoops_getrequest('keyword_id'))));
		}
	
		if (isset($_REQUEST['name'])) {
			$this->_mNavi->addExtra('name', xoops_getrequest('name'));
			$this->_mCriteria->add(new Criteria('name', array(XOBJ_DTYPE_STRING, xoops_getrequest('name'))));
		}
	
		if (isset($_REQUEST['priority'])) {
			$this->_mNavi->addExtra('priority', xoops_getrequest('priority'));
			$this->_mCriteria->add(new Criteria('priority', array(XOBJ_DTYPE_INT, xoops_getrequest('priority'))));
		}
	}
}

?>
