<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Cuestion_QuestionAdminEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.cuestion.QuestionAdminEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['question_id'] =& new XCube_IntProperty('question_id');
		$this->mFormProperties['category_id'] =& new XCube_IntProperty('category_id');
		$this->mFormProperties['subject'] =& new XCube_StringProperty('subject');
		$this->mFormProperties['body'] =& new XCube_TextProperty('body');
		$this->mFormProperties['count'] =& new XCube_IntProperty('count');
		$this->mFormProperties['rating'] =& new XCube_FloatProperty('rating');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['question_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['question_id']->setDependsByArray(array('required','objectExsist'));
		$this->mFieldProperties['question_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_QUESTION_ID);
		$this->mFieldProperties['question_id']->addMessage('objectExist', _AD_CUESTION_ERROR_OBJECT_EXIST, _AD_CUESTION_LANG_QUESTION_ID);
		$this->mFieldProperties['question_id']->addVar('handler', 'keyqlink');
	
		$this->mFieldProperties['category_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['category_id']->setDependsByArray(array('required','objectExsist'));
		$this->mFieldProperties['category_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_CATEGORY_ID);
		$this->mFieldProperties['category_id']->addMessage('objectExist', _AD_CUESTION_ERROR_OBJECT_EXIST, _AD_CUESTION_LANG_CATEGORY_ID);
		$this->mFieldProperties['category_id']->addVar('handler', 'category');
	
		$this->mFieldProperties['subject'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['subject']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['subject']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_SUBJECT, '255');
		$this->mFieldProperties['subject']->addMessage('maxlength', _AD_CUESTION_ERROR_MAXLENGTH, _AD_CUESTION_LANG_SUBJECT, '255');
		$this->mFieldProperties['subject']->addVar('maxlength', '255');
	
		$this->mFieldProperties['body'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['body']->setDependsByArray(array('required'));
		$this->mFieldProperties['body']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_BODY);
	
		$this->mFieldProperties['count'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['count']->setDependsByArray(array('required'));
		$this->mFieldProperties['count']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_COUNT);
	
		$this->mFieldProperties['rating'] =& new XCube_FieldProperty($this);
	}

	function load(&$obj)
	{
		$this->set('question_id', $obj->get('question_id'));
		$this->set('category_id', $obj->get('category_id'));
		$this->set('subject', $obj->get('subject'));
		$this->set('body', $obj->get('body'));
		$this->set('count', $obj->get('count'));
		$this->set('rating', $obj->get('rating'));
	}

	function update(&$obj)
	{
		$obj->set('question_id', $this->get('question_id'));
		$obj->set('category_id', $this->get('category_id'));
		$obj->set('subject', $this->get('subject'));
		$obj->set('body', $this->get('body'));
		$obj->set('count', $this->get('count'));
		$obj->set('rating', $this->get('rating'));
	}
}

?>
