<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Cuestion_Rating_messageAdminEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.cuestion.Rating_messageAdminEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['rating_message_id'] =& new XCube_IntProperty('rating_message_id');
		$this->mFormProperties['name'] =& new XCube_StringProperty('name');
		$this->mFormProperties['point'] =& new XCube_IntProperty('point');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['rating_message_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['rating_message_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['rating_message_id']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_RATING_MESSAGE_ID);
	
		$this->mFieldProperties['name'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['name']->setDependsByArray(array('required','maxlength'));
		$this->mFieldProperties['name']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_NAME, '255');
		$this->mFieldProperties['name']->addMessage('maxlength', _AD_CUESTION_ERROR_MAXLENGTH, _AD_CUESTION_LANG_NAME, '255');
		$this->mFieldProperties['name']->addVar('maxlength', '255');
	
		$this->mFieldProperties['point'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['point']->setDependsByArray(array('required'));
		$this->mFieldProperties['point']->addMessage('required', _AD_CUESTION_ERROR_REQUIRED, _AD_CUESTION_LANG_POINT);
	}

	function load(&$obj)
	{
		$this->set('rating_message_id', $obj->get('rating_message_id'));
		$this->set('name', $obj->get('name'));
		$this->set('point', $obj->get('point'));
	}

	function update(&$obj)
	{
		$obj->set('rating_message_id', $this->get('rating_message_id'));
		$obj->set('name', $this->get('name'));
		$obj->set('point', $this->get('point'));
	}
}

?>
