<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractFilterForm.class.php";

define('RATING_MESSAGE_SORT_KEY_DEFAULT', 0);
define('RATING_MESSAGE_SORT_KEY_RATING_MESSAGE_ID', 1);
define('RATING_MESSAGE_SORT_KEY_NAME', 2);
define('RATING_MESSAGE_SORT_KEY_POINT', 3);
define('RATING_MESSAGE_SORT_KEY_MAXVALUE', 3);

class Cuestion_Rating_messageFilterForm extends Cuestion_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		RATING_MESSAGE_SORT_KEY_DEFAULT => 'rating_message_id',
		RATING_MESSAGE_SORT_KEY_RATING_MESSAGE_ID => 'rating_message_id',
		RATING_MESSAGE_SORT_KEY_NAME => 'name',
		RATING_MESSAGE_SORT_KEY_POINT => 'point'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > RATING_MESSAGE_SORT_KEY_MAXVALUE) {
			$this->mSort = RATING_MESSAGE_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['rating_message_id'])) {
			$this->_mNavi->addExtra('rating_message_id', xoops_getrequest('rating_message_id'));
			$this->_mCriteria->add(new Criteria('rating_message_id', array(XOBJ_DTYPE_INT, xoops_getrequest('rating_message_id'))));
		}
	
		if (isset($_REQUEST['name'])) {
			$this->_mNavi->addExtra('name', xoops_getrequest('name'));
			$this->_mCriteria->add(new Criteria('name', array(XOBJ_DTYPE_STRING, xoops_getrequest('name'))));
		}
	
		if (isset($_REQUEST['point'])) {
			$this->_mNavi->addExtra('point', xoops_getrequest('point'));
			$this->_mCriteria->add(new Criteria('point', array(XOBJ_DTYPE_INT, xoops_getrequest('point'))));
		}
	}
}

?>
