<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionStrategy.class.php";

define ("CUESTION_FRAME_PERFORM_SUCCESS", 1);
define ("CUESTION_FRAME_PERFORM_FAIL", 2);
define ("CUESTION_FRAME_INIT_SUCCESS", 3);

define ("CUESTION_FRAME_VIEW_NONE", 1);
define ("CUESTION_FRAME_VIEW_SUCCESS", 2);
define ("CUESTION_FRAME_VIEW_ERROR", 3);
define ("CUESTION_FRAME_VIEW_INDEX", 4);
define ("CUESTION_FRAME_VIEW_INPUT", 5);

class Cuestion_ActionFrame extends XCube_ActionStrategy
{
	var $mActionName = null;
	var $mAction = null;
	var $mAdminFlag = null;

	function Cuestion_ActionFrame($admin)
	{
		$this->mAdminFlag = $admin;
	}

	function setActionName($name)
	{
		$this->mActionName = $name;
	}

	function &execute(&$controller)
	{
		if (!preg_match("/^\w+$/", $this->mActionName)) {
			die();
		}
	
		//
		// Create action object by mActionName
		//
		$className = "Cuestion_" . ucfirst($this->mActionName) . "Action";
		$fileName = ucfirst($this->mActionName) . "Action";
		if ($this->mAdminFlag) {
			$fileName = XOOPS_MODULE_PATH . "/cuestion/admin/actions/${fileName}.class.php";
		}
		else {
			$fileName = XOOPS_MODULE_PATH . "/cuestion/actions/${fileName}.class.php";
		}
	
		if (!file_exists($fileName)) {
			die();
		}
	
		require_once $fileName;
	
		if (class_exists($className)) {
			$this->mAction =& new $className();
		}
	
		if (!is_object($this->mAction)) {
			die();
		}
	
		$this->mAction->prepare($controller, $controller->getXoopsUser());
		
		if (!$this->mAction->isPerm($controller, $controller->getXoopsUser()))
		{
			//
			// TODO Kick
			//
			$controller->executeForward('./index.php');
		}
	
		if (xoops_getenv("REQUEST_METHOD") == "POST") {
			$viewStatus = $this->mAction->execute($controller, $controller->getXoopsUser());
		}
		else {
			$viewStatus = $this->mAction->getDefaultView($controller, $controller->getXoopsUser());
		}
	
		switch($viewStatus) {
			case CUESTION_FRAME_VIEW_SUCCESS:
				$this->mAction->executeViewSuccess($controller, $controller->getXoopsUser(), $controller->mRenderSystem);
				break;
		
			case CUESTION_FRAME_VIEW_ERROR:
				$this->mAction->executeViewError($controller, $controller->getXoopsUser(), $controller->mRenderSystem);
				break;
		
			case CUESTION_FRAME_VIEW_INDEX:
				$this->mAction->executeViewIndex($controller, $controller->getXoopsUser(), $controller->mRenderSystem);
				break;
		
			case CUESTION_FRAME_VIEW_INPUT:
				$this->mAction->executeViewInput($controller, $controller->getXoopsUser(), $controller->mRenderSystem);
				break;
		}
	}
}

class Cuestion_Action
{
	function Cuestion_Action()
	{
	}

	function prepare(&$controller, &$xoopsUser)
	{
	}

	function isPerm(&$controller, &$xoopsUser)
	{
		return true;
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		return CUESTION_FRAME_VIEW_NONE;
	}

	function execute(&$controller, &$xoopsUser)
	{
		return CUESTION_FRAME_VIEW_NONE;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
	}
}

?>
