<?php

class CuestionAnswerObject extends XoopsSimpleObject
{
	var $mQuestion = null;
	var $_mQuestionLoadedFlag = false;

	var $mUser = null;
	var $_mUserLoadedFlag = false;

	function CuestionAnswerObject()
	{
		$this->initVar('answer_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('question_id', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('body', XOBJ_DTYPE_TEXT, '', true);
		$this->initVar('create_unixtime', XOBJ_DTYPE_INT, time(), true);
		$this->initVar('update_unixtime', XOBJ_DTYPE_INT, time(), true);
		$this->initVar('uid', XOBJ_DTYPE_INT, '0', true);
	}

	function loadQuestion()
	{
		if ($this->_mQuestionLoadedFlag == false) {
			$handler =& xoops_getmodulehandler('question');
			$this->mQuestion =& $handler->get($this->get('question_id'));
			$this->_mQuestionLoadedFlag = true;
		}
	}

	function loadUser()
	{
		if ($this->_mUserLoadedFlag == false) {
			$handler =& xoops_gethandler('user');
			$this->mUser =& $handler->get($this->get('uid'));
			$this->_mUserLoadedFlag = true;
		}
	}
}

class CuestionAnswerHandler extends XoopsObjectGenericHandler
{
	var $mTable = "cuestion_answer";
	var $mPrimary = "answer_id";
	var $mClass = "CuestionAnswerObject";
}

?>
