<?php

class CuestionCategoryObject extends XoopsSimpleObject
{
	var $mQuestion = array();
	var $_mQuestionLoadedFlag = false;

	function CuestionCategoryObject()
	{
		$this->initVar('category_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('parent_id', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('name', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('description', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('priority', XOBJ_DTYPE_INT, '0', true);
	}

	function getQuectionCount()
	{
		$handler =& xoops_getmodulehandler('question', 'cuestion');
		return $handler->getCount(new Criteria('category_id', $this->get('category_id')));
	}

	function loadQuestion()
	{
		if ($this->_mQuestionLoadedFlag == false) {
			$handler =& xoops_getmodulehandler('question');
			$this->mQuestion =& $handler->getObjects(new Criteria('category_id', $this->get('category_id')));
			$this->_mQuestionLoadedFlag = true;
		}
	}

	function &createQuestion()
	{
		$handler =& xoops_getmodulehandler('question');
		$obj =& $handler->create();
		$obj->set('category_id', $this->get('category_id'));
		return $obj;
	}
}

class CuestionCategoryHandler extends XoopsObjectGenericHandler
{
	var $mTable = "cuestion_category";
	var $mPrimary = "category_id";
	var $mClass = "CuestionCategoryObject";

	function delete(&$obj)
	{
		$handler =& xoops_getmodulehandler('question');
		$handler->deleteAll(new Criteria('category_id', $obj->get('category_id')));
		unset($handler);
	
		return parent::delete($obj);
	}
}

?>
