<?php

class Cuestion_AbstractQuestionObject extends XoopsSimpleObject
{
	var $mAnswer = array();
	var $_mAnswerLoadedFlag = false;
	var $mKeyqlink = array();
	var $_mKeyqlinkLoadedFlag = false;
	var $mCategory = null;
	var $_mCategoryLoadedFlag = false;

	function CuestionQuestionObject()
	{
		$this->initVar('question_id', XOBJ_DTYPE_INT, '', false);
		$this->initVar('category_id', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('subject', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('body', XOBJ_DTYPE_TEXT, '', true);
		$this->initVar('count', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('rating', XOBJ_DTYPE_FLOAT, '3.0', false);
		$this->initVar('is_open', XOBJ_DTYPE_BOOL, '1', true);
		$this->initVar('create_unixtime', XOBJ_DTYPE_INT, time(), true);
		$this->initVar('update_unixtime', XOBJ_DTYPE_INT, time(), true);
		$this->initVar('uid', XOBJ_DTYPE_INT, '0', true);
		$this->initVar('report', XOBJ_DTYPE_TEXT, '', false);
	}

	function loadAnswer()
	{
		if ($this->_mAnswerLoadedFlag == false) {
			$handler =& xoops_getmodulehandler('answer');
			$this->mAnswer =& $handler->getObjects(new Criteria('question_id', $this->get('question_id')));
			$this->_mAnswerLoadedFlag = true;
		}
	}

	function &createAnswer()
	{
		$handler =& xoops_getmodulehandler('answer');
		$obj =& $handler->create();
		$obj->set('question_id', $this->get('question_id'));
		return $obj;
	}

	function loadKeyqlink()
	{
		if ($this->_mKeyqlinkLoadedFlag == false) {
			$handler =& xoops_getmodulehandler('keyqlink');
			$this->mKeyqlink =& $handler->getObjects(new Criteria('question_id', $this->get('question_id')));
			$this->_mKeyqlinkLoadedFlag = true;
		}
	}

	function &createKeyqlink()
	{
		$handler =& xoops_getmodulehandler('keyqlink');
		$obj =& $handler->create();
		$obj->set('question_id', $this->get('question_id'));
		return $obj;
	}

	function loadCategory()
	{
		if ($this->_mCategoryLoadedFlag == false) {
			$handler =& xoops_getmodulehandler('category');
			$this->mCategory =& $handler->get($this->get('category_id'));
			$this->_mCategoryLoadedFlag = true;
		}
	}
}

class Cuestion_AbstractQuestionHandler extends XoopsObjectGenericHandler
{
	var $mTable = "cuestion_question";
	var $mPrimary = "question_id";
	var $mClass = "CuestionQuestionObject";

	function delete(&$obj)
	{
		$handler =& xoops_getmodulehandler('answer');
		$handler->deleteAll(new Criteria('question_id', $obj->get('question_id')));
		unset($handler);
	
		$handler =& xoops_getmodulehandler('keyqlink');
		$handler->deleteAll(new Criteria('question_id', $obj->get('question_id')));
		unset($handler);
	
		return parent::delete($obj);
	}
}

?>
