<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/data/AbstractQuestionObject.class.php";

class CuestionQuestionObject extends Cuestion_AbstractQuestionObject
{
	var $mUser;
	
	function loadUser()
	{
		$handler =& xoops_gethandler('user');
		$this->mUser =& $handler->get($this->get('uid'));
	}
	
	function getAnswerCount()
	{
		$handler =& xoops_getmodulehandler('answer');
		return $handler->getCount(new Criteria('question_id', $this->get('question_id')));
	}
	
	function calculateRating()
	{
		//
		// prepare
		//
		$handler =& xoops_getmodulehandler('rating', 'cuestion');
		$criteria =& new Criteria('question_id', $this->get('question_id'));
		
		$ratingMessageHandler =& xoops_getmodulehandler('rating_message', 'cuestion');
		$ratingMessageArr =& $ratingMessageHandler->getObjects(null, null, null, true);
		
		//
		// Calculate rating
		//
		$total = 0;
		$count = 0;

		$ratingArr =& $handler->getObjects($criteria);

		foreach ($ratingArr as $rating) {
			if (is_object($ratingMessageArr[$rating->get('rating_message_id')])) {
				$total += $ratingMessageArr[$rating->get('rating_message_id')]->get('point');
				$count++;
			}
		}
		
		$this->set('rating', round($total / $count, 2));
	}
}

class CuestionQuestionHandler extends Cuestion_AbstractQuestionHandler
{
}

?>
