<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Cuestion_AnswerEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.cuestion.AnswerEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['answer_id'] =& new XCube_IntProperty('answer_id');
		$this->mFormProperties['question_id'] =& new XCube_IntProperty('question_id');
		$this->mFormProperties['body'] =& new XCube_TextProperty('body');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['answer_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['answer_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['answer_id']->addMessage('required', _MD_CUESTION_ERROR_REQUIRED, _MD_CUESTION_LANG_ANSWER_ID);
	
		$this->mFieldProperties['question_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['question_id']->setDependsByArray(array('required','objectExsist'));
		$this->mFieldProperties['question_id']->addMessage('required', _MD_CUESTION_ERROR_REQUIRED, _MD_CUESTION_LANG_QUESTION_ID);
		$this->mFieldProperties['question_id']->addMessage('objectExist', _MD_CUESTION_ERROR_OBJECT_EXIST, _MD_CUESTION_LANG_QUESTION_ID);
		$this->mFieldProperties['question_id']->addVar('handler', 'question');
	
		$this->mFieldProperties['body'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['body']->setDependsByArray(array('required'));
		$this->mFieldProperties['body']->addMessage('required', _MD_CUESTION_ERROR_REQUIRED, _MD_CUESTION_LANG_BODY);
	}

	function load(&$obj)
	{
		$this->set('answer_id', $obj->get('answer_id'));
		$this->set('question_id', $obj->get('question_id'));
		$this->set('body', $obj->get('body'));
	}

	function update(&$obj)
	{
		$obj->set('answer_id', $this->get('answer_id'));
		$obj->set('question_id', $this->get('question_id'));
		$obj->set('body', $this->get('body'));
	}
}

?>
