<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractFilterForm.class.php";

define('ANSWER_SORT_KEY_DEFAULT', 0);
define('ANSWER_SORT_KEY_ANSWER_ID', 1);
define('ANSWER_SORT_KEY_QUESTION_ID', 2);
define('ANSWER_SORT_KEY_BODY', 3);
define('ANSWER_SORT_KEY_MAXVALUE', 3);

class Cuestion_AnswerFilterForm extends Cuestion_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		ANSWER_SORT_KEY_DEFAULT => 'answer_id',
		ANSWER_SORT_KEY_ANSWER_ID => 'answer_id',
		ANSWER_SORT_KEY_QUESTION_ID => 'question_id',
		ANSWER_SORT_KEY_BODY => 'body'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > ANSWER_SORT_KEY_MAXVALUE) {
			$this->mSort = ANSWER_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['answer_id'])) {
			$this->_mNavi->addExtra('answer_id', xoops_getrequest('answer_id'));
			$this->_mCriteria->add(new Criteria('answer_id', array(XOBJ_DTYPE_INT, xoops_getrequest('answer_id'))));
		}
	
		if (isset($_REQUEST['question_id'])) {
			$this->_mNavi->addExtra('question_id', xoops_getrequest('question_id'));
			$this->_mCriteria->add(new Criteria('question_id', array(XOBJ_DTYPE_INT, xoops_getrequest('question_id'))));
		}
	}
}

?>
