<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractFilterForm.class.php";

define('CATEGORY_SORT_KEY_DEFAULT', 0);
define('CATEGORY_SORT_KEY_CATEGORY_ID', 1);
define('CATEGORY_SORT_KEY_PARENT_ID', 2);
define('CATEGORY_SORT_KEY_NAME', 3);
define('CATEGORY_SORT_KEY_DESCRIPTION', 4);
define('CATEGORY_SORT_KEY_PRIORITY', 5);
define('CATEGORY_SORT_KEY_MAXVALUE', 5);

class Cuestion_CategoryFilterForm extends Cuestion_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		CATEGORY_SORT_KEY_DEFAULT => 'category_id',
		CATEGORY_SORT_KEY_CATEGORY_ID => 'category_id',
		CATEGORY_SORT_KEY_PARENT_ID => 'parent_id',
		CATEGORY_SORT_KEY_NAME => 'name',
		CATEGORY_SORT_KEY_DESCRIPTION => 'description',
		CATEGORY_SORT_KEY_PRIORITY => 'priority'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > CATEGORY_SORT_KEY_MAXVALUE) {
			$this->mSort = CATEGORY_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['category_id'])) {
			$this->_mNavi->addExtra('category_id', xoops_getrequest('category_id'));
			$this->_mCriteria->add(new Criteria('category_id', array(XOBJ_DTYPE_INT, xoops_getrequest('category_id'))));
		}
	
		if (isset($_REQUEST['parent_id'])) {
			$this->_mNavi->addExtra('parent_id', xoops_getrequest('parent_id'));
			$this->_mCriteria->add(new Criteria('parent_id', array(XOBJ_DTYPE_INT, xoops_getrequest('parent_id'))));
		}
	
		if (isset($_REQUEST['name'])) {
			$this->_mNavi->addExtra('name', xoops_getrequest('name'));
			$this->_mCriteria->add(new Criteria('name', array(XOBJ_DTYPE_STRING, xoops_getrequest('name'))));
		}
	
		if (isset($_REQUEST['priority'])) {
			$this->_mNavi->addExtra('priority', xoops_getrequest('priority'));
			$this->_mCriteria->add(new Criteria('priority', array(XOBJ_DTYPE_INT, xoops_getrequest('priority'))));
		}
	}
}

?>
