<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractFilterForm.class.php";

define('QUESTION_SORT_KEY_DEFAULT', 0);
define('QUESTION_SORT_KEY_QUESTION_ID', 1);
define('QUESTION_SORT_KEY_CATEGORY_ID', 2);
define('QUESTION_SORT_KEY_SUBJECT', 3);
define('QUESTION_SORT_KEY_BODY', 4);
define('QUESTION_SORT_KEY_COUNT', 5);
define('QUESTION_SORT_KEY_RATING', 6);
define('QUESTION_SORT_KEY_IS_OPEN', 7);
define('QUESTION_SORT_KEY_CREATE_UNIXTIME', 8);
define('QUESTION_SORT_KEY_UPDATE_UNIXTIME', 9);
define('QUESTION_SORT_KEY_UID', 10);
define('QUESTION_SORT_KEY_MAXVALUE', 10);

class Cuestion_QuestionFilterForm extends Cuestion_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		QUESTION_SORT_KEY_DEFAULT => 'question_id',
		QUESTION_SORT_KEY_QUESTION_ID => 'question_id',
		QUESTION_SORT_KEY_CATEGORY_ID => 'category_id',
		QUESTION_SORT_KEY_SUBJECT => 'subject',
		QUESTION_SORT_KEY_BODY => 'body',
		QUESTION_SORT_KEY_COUNT => 'count',
		QUESTION_SORT_KEY_RATING => 'rating',
		QUESTION_SORT_KEY_IS_OPEN => 'is_open',
		QUESTION_SORT_KEY_CREATE_UNIXTIME => 'create_unixtime',
		QUESTION_SORT_KEY_UPDATE_UNIXTIME => 'update_unixtime',
		QUESTION_SORT_KEY_UID => 'uid'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : -QUESTION_SORT_KEY_CREATE_UNIXTIME;
	
		if ($this->mSort > QUESTION_SORT_KEY_MAXVALUE) {
			$this->mSort = QUESTION_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['question_id'])) {
			$this->_mNavi->addExtra('question_id', xoops_getrequest('question_id'));
			$this->_mCriteria->add(new Criteria('question_id', array(XOBJ_DTYPE_INT, xoops_getrequest('question_id'))));
		}
	
		if (isset($_REQUEST['category_id'])) {
			$this->_mNavi->addExtra('category_id', xoops_getrequest('category_id'));
			$this->_mCriteria->add(new Criteria('category_id', array(XOBJ_DTYPE_INT, xoops_getrequest('category_id'))));
		}
	
		if (isset($_REQUEST['subject'])) {
			$this->_mNavi->addExtra('subject', xoops_getrequest('subject'));
			$this->_mCriteria->add(new Criteria('subject', array(XOBJ_DTYPE_STRING, xoops_getrequest('subject'))));
		}
	
		if (isset($_REQUEST['count'])) {
			$this->_mNavi->addExtra('count', xoops_getrequest('count'));
			$this->_mCriteria->add(new Criteria('count', array(XOBJ_DTYPE_INT, xoops_getrequest('count'))));
		}
	
		if (isset($_REQUEST['rating'])) {
			$this->_mNavi->addExtra('rating', xoops_getrequest('rating'));
			$this->_mCriteria->add(new Criteria('rating', array(XOBJ_DTYPE_FLOAT, xoops_getrequest('rating'))));
		}
	
		if (isset($_REQUEST['is_open'])) {
			$this->_mNavi->addExtra('is_open', xoops_getrequest('is_open'));
			$this->_mCriteria->add(new Criteria('is_open', array(XOBJ_DTYPE_BOOL, xoops_getrequest('is_open'))));
		}
	
		if (isset($_REQUEST['create_unixtime'])) {
			$this->_mNavi->addExtra('create_unixtime', xoops_getrequest('create_unixtime'));
			$this->_mCriteria->add(new Criteria('create_unixtime', array(XOBJ_DTYPE_INT, xoops_getrequest('create_unixtime'))));
		}
	
		if (isset($_REQUEST['update_unixtime'])) {
			$this->_mNavi->addExtra('update_unixtime', xoops_getrequest('update_unixtime'));
			$this->_mCriteria->add(new Criteria('update_unixtime', array(XOBJ_DTYPE_INT, xoops_getrequest('update_unixtime'))));
		}
	
		if (isset($_REQUEST['uid'])) {
			$this->_mNavi->addExtra('uid', xoops_getrequest('uid'));
			$this->_mCriteria->add(new Criteria('uid', array(XOBJ_DTYPE_INT, xoops_getrequest('uid'))));
		}
	}
}

?>
