<?php

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/Legacy_Validator.class.php";

class Cuestion_RatingEditForm extends XCube_ActionForm
{
	function getTokenName()
	{
		return "module.cuestion.RatingEditForm.TOKEN";
	}

	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['rating_id'] =& new XCube_IntProperty('rating_id');
		$this->mFormProperties['question_id'] =& new XCube_IntProperty('question_id');
		$this->mFormProperties['rating_message_id'] =& new XCube_IntProperty('rating_message_id');
		$this->mFormProperties['uid'] =& new XCube_IntProperty('uid');
	
		//
		// Set field properties
		//
	
		$this->mFieldProperties['rating_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['rating_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['rating_id']->addMessage('required', _MD_CUESTION_ERROR_REQUIRED, _MD_CUESTION_LANG_RATING_ID);
	
		$this->mFieldProperties['question_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['question_id']->setDependsByArray(array('required','objectExsist'));
		$this->mFieldProperties['question_id']->addMessage('required', _MD_CUESTION_ERROR_REQUIRED, _MD_CUESTION_LANG_QUESTION_ID);
		$this->mFieldProperties['question_id']->addMessage('objectExist', _MD_CUESTION_ERROR_OBJECT_EXIST, _MD_CUESTION_LANG_QUESTION_ID);
		$this->mFieldProperties['question_id']->addVar('handler', 'question');
	
		$this->mFieldProperties['rating_message_id'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['rating_message_id']->setDependsByArray(array('required'));
		$this->mFieldProperties['rating_message_id']->addMessage('required', _MD_CUESTION_ERROR_REQUIRED, _MD_CUESTION_LANG_RATING_MESSAGE_ID);
	
		$this->mFieldProperties['uid'] =& new XCube_FieldProperty($this);
		$this->mFieldProperties['uid']->setDependsByArray(array('required'));
		$this->mFieldProperties['uid']->addMessage('required', _MD_CUESTION_ERROR_REQUIRED, _MD_CUESTION_LANG_UID);
	}

	function load(&$obj)
	{
		$this->set('rating_id', $obj->get('rating_id'));
		$this->set('question_id', $obj->get('question_id'));
		$this->set('rating_message_id', $obj->get('rating_message_id'));
		$this->set('uid', $obj->get('uid'));
	}

	function update(&$obj)
	{
		$obj->set('rating_id', $this->get('rating_id'));
		$obj->set('question_id', $this->get('question_id'));
		$obj->set('rating_message_id', $this->get('rating_message_id'));
		$obj->set('uid', $this->get('uid'));
	}
}

?>
