<?php

require_once XOOPS_MODULE_PATH . "/cuestion/class/AbstractFilterForm.class.php";

define('RATING_SORT_KEY_DEFAULT', 0);
define('RATING_SORT_KEY_RATING_ID', 1);
define('RATING_SORT_KEY_QUESTION_ID', 2);
define('RATING_SORT_KEY_RATING_MESSAGE_ID', 3);
define('RATING_SORT_KEY_UID', 4);
define('RATING_SORT_KEY_MAXVALUE', 4);

class Cuestion_RatingFilterForm extends Cuestion_AbstractFilterForm
{
	var $mSort = 0;
	var $mSortKeys = array(
		RATING_SORT_KEY_DEFAULT => 'rating_id',
		RATING_SORT_KEY_RATING_ID => 'rating_id',
		RATING_SORT_KEY_QUESTION_ID => 'question_id',
		RATING_SORT_KEY_RATING_MESSAGE_ID => 'rating_message_id',
		RATING_SORT_KEY_UID => 'uid'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > RATING_SORT_KEY_MAXVALUE) {
			$this->mSort = RATING_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['rating_id'])) {
			$this->_mNavi->addExtra('rating_id', xoops_getrequest('rating_id'));
			$this->_mCriteria->add(new Criteria('rating_id', array(XOBJ_DTYPE_INT, xoops_getrequest('rating_id'))));
		}
	
		if (isset($_REQUEST['question_id'])) {
			$this->_mNavi->addExtra('question_id', xoops_getrequest('question_id'));
			$this->_mCriteria->add(new Criteria('question_id', array(XOBJ_DTYPE_INT, xoops_getrequest('question_id'))));
		}
	
		if (isset($_REQUEST['rating_message_id'])) {
			$this->_mNavi->addExtra('rating_message_id', xoops_getrequest('rating_message_id'));
			$this->_mCriteria->add(new Criteria('rating_message_id', array(XOBJ_DTYPE_INT, xoops_getrequest('rating_message_id'))));
		}
	
		if (isset($_REQUEST['uid'])) {
			$this->_mNavi->addExtra('uid', xoops_getrequest('uid'));
			$this->_mCriteria->add(new Criteria('uid', array(XOBJ_DTYPE_INT, xoops_getrequest('uid'))));
		}
	}
}

?>
