// $id:$
function() {
	// xjp情報を取得する関数
	function getXjpInfo() {
		var xjpInfo = [];
		for (name in X._list) {
			var xjp = X._list[name];
			xjpInfo.push([name, xjp.url, xjp.status, xjp.size, xjp.date, xjp.modified, xjp.count]);
		}
		return xjpInfo;
	}
	function RorG(val) {
		var c = val>1?'red':'green';
		return '<span style="color:'+c+';">' + val + '</span>';
	}
	// データストア作成
	var store = new Ext.data.ArrayStore({
		autoDestroy: true,
		fields: [
		   {name: 'name'},
		   {name: 'url'},
		   {name: 'status'},
		   {name: 'size',	 type: 'int'},
		   {name: 'date', type: 'date'},
		   {name: 'modified', type: 'date'},
		   {name: 'count'}
		],
		data: getXjpInfo()
	});
	
	// xjp名、Date、Last-Modified、Content-Length、statusを表示する
	var grid = new Ext.grid.GridPanel({
		store: store,
		stripeRows: true,
		viewConfig: {forceFit:true},
		enableColumnMove: false,
		enableHdMenu: false,
		sm: new XG.RowSelectionModel({singleSelect:true}),
		columns: [
			{header:'Name'  ,dataIndex:'name'  ,width:90,sortable:true, align:'right'},
			{header:'Status',dataIndex:'status',width:70,sortable:true},
			{header:'Size'  ,dataIndex:'size'  ,width:55,sortable:true, align:'right'},
			{header:'Date'  ,dataIndex:'date'  ,width:84,sortable:true, align:'right', renderer:Xji.shortDate},
			{header:'Last-Modified',dataIndex:'modified',width:84,sortable:true,renderer: Xji.shortDate,align :'right'},
			{header:'count' ,dataIndex:'count' ,width:40,sortable:true, align:'right', renderer:RorG}
		],
		tbar: [{
			text: 'Reload',
			handler: function(b, e){
				var row = grid.getSelectionModel().getSelected();
				if (!row) {
					XM.alert('xjp Console','再読み込みするxjpを選択してください');
				} else {
					var name = row.get('name');
					delete X[name];
					delete X._queue[name];
					X._list[name].removed=true;
					Xji.require(name,function(){
						store.loadData(getXjpInfo()); // refresh
					},{});
				}
			}
		},'-','xjp:',{
			xtype:'textfield',
			id:'xjp',
			width:75,
			enableKeyEvents:true,
			listeners:{
				keyup:function(t,e){
					if (e.keyCode==e.ENTER) checkAndLoad();
				}
			}
		},{
			text: 'Load',
			handler: function(b, e){
				checkAndLoad();
			}
		},'-',{
			text:'View',
			handler: function(b, e){
				var row = grid.getSelectionModel().getSelected();
				if (!row) {
					XM.alert('xjp Console','表示するxjpを選択してください');
				} else {
					window.open(row.get('url'));
				}
			}
		},'-',{
			text:'Refresh',
			handler: function(b, e){
				store.loadData(getXjpInfo()); // refresh
			}
		},'->','lineEval:'+X._lineEval]
	});

	// windowの作成と表示
	var win = new Ext.Window({
		minHeight: 150,
		minWidth: 300,
		height: 200,
		width: 400,
		maxPct: 70,
		title: 'xjp Console',
		closable:true,
		layout: 'fit',
		items: grid
	});
	win.show()
	
	function checkAndLoad() {
		var name = Ext.getCmp('xjp').getValue();
		if (!name) {
			XM.alert('xjp Console','読込むxjp名を入力してください')
		} else {
			Xji.require(name,function(){
				store.loadData(getXjpInfo()); // refresh
			},{});
		}
	}
}