##!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#

require 'plugincdGlade'
require 'remastering/remastertool_utility'

require "gettext"

class Cd < PlugincdGlade
  include GetText

	PROG_PATH = "plugincd.glade"
	PROG_NAME = "remastertool_plugin_cd"

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	DISPLAY_NAME	= "CD"			# display name
	VERSION			= "V1.0"		# plugin version 

	CMD_MKISO = "(mkisofs -pad -l -r -J -v -V %s -no-emul-boot -boot-load-size 4 -boot-info-table -b %s -c %s -hide-rr-moved -o %s %s)"

	MSG_ERR_MKISO = _("Failed to create %s image file(%d).")
	MSG_INF_MKISO = _("Now creating media image.\nPlease wait for a while.")
	MSG_WARN_VOL_EMPTY = _("Please sepcify the volume label.")
	MSG_WARN_OUT_EMPTY = _("Please sepcify the output file.")
	TITLE_DIALOG_OUTPUT_ISO = _("Choose a ISO image file")

	# XMLプラグイン向けの XML要素
	XML_ROOT = ["PluginInfo", _("Plugin_information")]
	XML_ROOT_ATTR = ["name", _("name")]
	XML_LABEL = ["volume_label", _("volume_label")]
	XML_OUTPUT = ["output_file", _("output_file")]

  attr :glade

	#=== プラグインのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#dir:: プラグイン格納ディレクトリ
	#復帰値:: なし
	#
	def initialize(dir)
		super(File.join(dir, PROG_PATH), nil, PROG_NAME)
	
		@display_name = DISPLAY_NAME
		@version = VERSION
		@have_about = true			# about dialog is having
		@have_option = false		# Option dialog is not having
		@copyright = SSL_COPYRIGHT
		@license = SSL_LICENSE
		@tool_min_vl = "V1.0"
		@cmd_mkiso = CMD_MKISO
		@boot_loader = "isolinux"	# boot loaderは初版ではisolinux固定
		@can_accel = true

		init_environ				# initialize environment

	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		return tool_version >= @tool_min_vl
	end

	#=== メディアの作成
	#
	#パラメタで取得したメディアディレクトリの内容をISOイメージ化する。
	#
	#media_dir:: CDメディア内容格納ディレクトリ
	#復帰値:: BOOL : true=成功、false=失敗
	#
	def create_media_image(media_dir)
		# mkisoコマンドを実行
		cmd = sprintf(@cmd_mkiso, @glade["entry_vol"].text.strip,
				RTUtility.get_os_plugin.get_boot_image(@boot_loader),
				RTUtility.get_os_plugin.get_boot_catalog(@boot_loader),
				@glade["entry_output"].text.strip, media_dir)
		status = RTUtility.exec_workOS_command(cmd, nil, nil, nil, RTUtility.mainWindow, MSG_INF_MKISO)

		if status != 0
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
											Gtk::MessageDialog::ERROR,
											Gtk::MessageDialog::BUTTONS_OK,
											sprintf(MSG_ERR_MKISO, @glade["entry_output"].text, status))
			dlg.run
			dlg.destroy
			false
		else
			true
		end
	end


	#=== ディストリビューション作成画面に表示するプラグイン固有域のWidge取得
	#
	#ディストリビューション作成画面に表示するプラグイン固有域のWidgを返却する。
	#
	#復帰値:: ディストリビューション作成画面に表示するプラグイン固有域のWidge
	#
	def get_makeDist_widget
		@glade['vbox_dist']
	end

	#=== 出力先イメージファイル名の取得
	#
	#リマスタリングした結果を出力する先のファイル名を返却する。
	#
	#復帰値:: 出力先イメージファイル名
	#
	def get_output_image
		@glade["entry_output"].text.strip
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素を取り出し、対応するエントリに設定する。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
		# XMLドキュメントから リマスタリング対象OSのrootディレクトリとバージョン
		# を取得してインスタンス変数に設定する。
		rootElm = nil
		root.get_elements(XML_ROOT[0]).each { |elm|
			if elm.attributes[XML_ROOT_ATTR[0]] == @display_name
				rootElm = elm
				break
			end
		}
		return unless rootElm 

		elm = rootElm.get_elements(XML_LABEL[0])[0]
		@glade["entry_vol"].text = (elm && elm.text) ? elm.text : ""
		elm = rootElm.get_elements(XML_OUTPUT[0])[0]
		@glade["entry_output"].text = (elm && elm.text) ? elm.text : ""

		# 現在の状態を「手順変更なし」に設定する
		fix_procedure
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(CDプラグイン)
	#
	def make_xml(localize = 0)
		elmRoot = REXML::Element.new(XML_ROOT[localize])
		elmRoot.add_attribute(XML_ROOT_ATTR[localize], @display_name)

		elm_child = REXML::Element.new(XML_LABEL[localize], elmRoot)
		elm_child.text = @glade["entry_vol"].text
		elm_child = REXML::Element.new(XML_OUTPUT[localize], elmRoot)
		elm_child.text = @glade["entry_output"].text

		elmRoot
	end

	#=== リマスタリング手順の変更確認
	#
	#リマスタリング手順に変更があったかを返却する。
	#新規にリマスタリングを開始した場合、起動時からの変更の有無を返却する。
	#リマスタリング手順ファイルを読み込み、続きから作業用を開始した場合は手順
	#読み込み後かの変更の有無を返却する。
	#
	#復帰値:: BOOL true=変更あり、false=変更なし。
	#
	def isModified?
		return @volume != @glade["entry_vol"].text.strip || @output != @glade["entry_output"].text.strip
	end

	#=== リマスタリング手順の変更確定
	#
	#リマスタリング手順に変更を確定する。
	#本メソッドはリマスタリング手順保存成功時に呼び出される。
	#各プラグインは現在の設定状態はリマスタリング手順変更なしの状態に設定する。
	#次回 isModified? メソッドが呼び出された場合、本メソッドの呼出時からの変更
	#を返却する。
	#
	#復帰値:: なし。
	#
	def fix_procedure
		@volume = @glade["entry_vol"].text.strip
		@output = @glade["entry_output"].text.strip
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@volume = ""
		@output = ""
		@glade["entry_vol"].text = ""
		@glade["entry_output"].text = ""
	end

	#===ディストリビューション作成前のチェック
	#
	#ディストリビューション作成前に設定内容に誤りがないか確認を行う。
	#パッケージ追加/削除画面ではチェック項目がないので常にtrueで復帰する。
	#
	#復帰値:: BOOL true=問題なし、false=問題あり
	#
	def check_for_make_distribution
		begin
			raise MSG_WARN_VOL_EMPTY if @glade["entry_vol"].text.strip.empty?
			raise MSG_WARN_OUT_EMPTY if @glade["entry_output"].text.strip.empty?
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
										 Gtk::MessageDialog::WARNING,
										 Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return false
		end
		true
	end

private

	#=== [開く]ボタンクリック時のイベントハンドラ
	#
	#[開く]ボタンクリック時にリ呼び出され、Ruby/GTK2標準のファイル選択ダイアログを
	#SAVEモードで表示し、出力先となるISOイメージファイル名を指定する。
	#
	#widget:: [開く]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_output_clicked(widget)
		dialog = Gtk::FileChooserDialog.new(TITLE_DIALOG_OUTPUT_ISO,
							RTUtility.mainWindow,
							Gtk::FileChooser::ACTION_SAVE,
							nil,
							[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
							[Gtk::Stock::SAVE, Gtk::Dialog::RESPONSE_OK])
		begin
			path = Pathname.new(File.dirname(@glade["entry_output"].text.strip)).realpath
			dialog.current_folder = path
		rescue
		end
		dialog.do_overwrite_confirmation = true	# 既存ファイルを選択したときに警告を表示する
		@glade["entry_output"].text = dialog.filename if dialog.run == Gtk::Dialog::RESPONSE_OK
		dialog.destroy
	end

end
