#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#

require 'fileutils'
require 'pathname'
require 'gconf2'
require 'find'

require 'remastering/remastertool_utility'

require 'pluginrpmGlade'

class Rpm < PluginrpmGlade
  include GetText

  attr :glade
	PROG_NAME = "remastertool_plugin_rpm"
	PROG_PATH = "pluginrpm.glade"

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	CMD_INSTALLABLE = "yum info available | egrep -E '^Name |^Version|^Release|^Summary'"
	CMD_INSTALLABLE_LOCAL = "rpm -qp --qf '%{NAME}__DELIM__%{VERSION}-%{RELEASE}__DELIM__%{SUMMARY}\n' "
	CMD_INSTALLED = "rpm -qa --qf='%{NAME}__DELIM__%{VERSION}-%{RELEASE}__DELIM__%{SIZE}__DELIM__%{SUMMARY}\n'"
#	CMD_UPDATE = "yum list update"
	#依存パッケージ一覧の取得
	CMD_GET_DPENDS_INSTALL   = "yumdownloader --resolve --urls %s"
	CMD_GET_DPENDS_UNINSTALL = "echo n | yum remove %s | grep installed"

	CMD_GET_PKGS = "mkdir -p %s && yumdownloader --resolve --destdir=%s %s"

	# パッケージ情報の追加
	CMD_APTARCH = "mkdir -p %s; createrepo %s"

	# パッケージのインストール/アンインストール
	CMD_INSTALL_PKGS = "yum -y %s %s"

	# パッケージの作成
	CMD_MK_TEMPLETE = "cp %s/spec.templete %s/%s.spec.templete"
	CMD_MK_PKG = "(cd %s; tar cvzf %s %s && rpmbuild -bb --target %s %s.spec)"

	# パッケージの展開
	CMD_EXTRACT_PKG = "(cd %s; rpm2cpio %s | cpio -id)"
	CMD_EXTRACT_CTL = "rpm -qp --qf '%%{NAME}\n%%{VERSION}\n%%{RELEASE}\n%%{SUMMARY}\n%%{GROUP}\n%%{ARCH}\n%%{PACKAGER}\n%%{VENDOR}\n%%{COPYRIGHT}\n' %s"
	CMD_EXTRACT_CTL2 = "rpm -qp --qf '%%{DESCRIPTION}\n' %s"
	CMD_EXTRACT_CTL3 = "(export LC_ALL=C; rpm -qp --changelog %s)"
	CMD_EXTRACT_CTL4 = "rpm -qp --%s %s | sort | uniq | grep -v '(none)'"

	# パッケージファイルの削除
	CMD_PRECLEAN = "cp -a %s %s %s"
	CMD_CLEAN = "yum clean all; rm -f %s/*.rpm"

	PATH_YAM_REPOS = "/etc/yum.repos.d"

	# ローカルYUMレポジトリファイル
	YUM_LOCAL_REPO = <<_EOF_
[Remastering tool]
name=Remastering tool
baseurl=file://%s/
enabled=1
gpgcheck=0
_EOF_

	YUM_LOCAL_PATH = File.join(PATH_YAM_REPOS, "remastering.repo")

	VR_SPLIT = "-"

	DISPLAY_NAME	= "RPM"			# display name
	VERSION			= "V1.0"		# plugin version 

	# RPMパッケージの全グループ
	GROUPS = ["Amusements/Games", "Amusements/Graphics", "Applications/Archiving",
			  "Applications/Communications", "Applications/Databases", "Applications/Editors",
			  "Applications/Emulators", "Applications/Engineering", "Applications/File",
			  "Applications/Internet", "Applications/Multimedia", "Applications/Productivity",
			  "Applications/Publishing", "Applications/System", "Applications/Text",
			  "Development/Debuggers", "Development/Languages", "Development/Libraries",
			  "Development/System", "Development/Tools", "Documentation",
			  "System Environment/Base", "System Environment/Daemons", "System Environment/Kernel",
			  "System Environment/Libraries", "System Environment/Shells", "User Interface/Desktops",
			  "User Interface/X", "User Interface/X Hardware Support"]

	# RPMパッケージの全アーキテクチャ
	ARCHS = ["noarch", "i386", "i486", "i586", "i686", "athlon", "ia64", "x86_64", "amd64",
			 "alpha", "alphaev5", "alphaev56", "alphapca56", "alphaev6", "alphaev67",
			 "sparc", "sparcv9", "sparc64", "m68k", "ppc", "ppciseries", "ppcpseries",
			 "ppc64", "parisc", "hppa1.0", "hppa1.1", "hppa1.2", "hppa2.0", "mips", "mipsel",
			 "armv3l", "armv4b", "armv4l", "atarist", "atariste", "ataritt", "falcon",
			 "atariclone", "milan", "hades", "s390", "s390x"]

	# バージョン比較子
	COMPS = ["<", "<=", "=", ">=", ">"]

	# 関係
	RELS = ["Requires", "Provides", "Conflicts", "Obsoletes", "Prereq", "BuildPrereq"]

	PKG_DEPLIST_HEADER = [_("Package"), _("Necessary version"), _("Relation")]
	PKG_SELDEPLIST_HEADER = [_("Package"), _("Description")]

	# Gconf アクセスキー
	CONF_KEY_SEARCHDIR = "/apps/remasteringtool/plugin/rpm/seach_directory"
	DEFAULT_SEARCHDIR  = "/var/cache/remastering/archives/rpm"

	MSG_INF_PKG_INSTALLABLE = _("Now collecting installable packages.\nPlease wait for a while.")
	MSG_INF_PKG_INSTALLED = _("Now collecting installed packages.\nPlease wait for a while.")
	MSG_INF_PKG_UPDATE = _("Now updating package index.\nPlease wait for a while.")
	MSG_INF_PKG_DOWNLOAD = _("Now downloading the %s package files.\nPlease wait for a while.")
	MSG_INF_PKG_RESOLVE = _("Now resolving the package dependency.\nPlease wait for a while.")
	MSG_INF_PKG_EXTRACT = _("Now extracting specified package.\nPlease wait for a while.")
	MSG_INF_PKG_DELETE = _("Now deleting package files.\nPlease wait for a while.")
	MSG_WARN_OPT_NOINIT = _("Please execute the option setting after completing initial setting.")
	MSG_WARN_OPT_NOREPOS = _("Because the repository file doesn't exist, the acquisition place of the package cannot be edited.")
	MSG_ERR_EXTRACT_PACKAGE = _("Cannot extract package file(%d).")
	MSG_ERR_DOWNLOAD_PACKAGE = _("Cannot download package file(%d).")
	MSG_ERR_NO_PACKAGE = _("Cannot find package file.")
	MSG_ERR_CREATE_TEMPLETE = _("Cannot create package templete(%d).")
	MSG_WAIT_EXPORT = _("The resource used by the RPM plugin is exported.")
	MSG_WAIT_IMPORT = _("The resource used by the Deb plugin is imported.")
	MSG_ERR_EXPORT = _("Failed to export.\n%s")
	MSG_ERR_IMPORT = _("Failed to import.\n%s")

	MSG_WARN_NO_NAME	= _("Please specify the package name.")
	MSG_WARN_NO_VERSION	= _("Please specify the package version.")
	MSG_WARN_NO_RELEASE	= _("Please specify the package release.")
	MSG_WARN_NO_SUMMARY	= _("Please specify the package summary.")
	MSG_WARN_NO_DESC	= _("Please specify the package description.")
	MSG_WARN_NO_GROUP	= _("Please specify the package group.")
	MSG_WARN_NO_ARCH	= _("Please specify the package architechture.")
	MSG_WARN_NO_MAINT	= _("Please specify the packager name.")
	MSG_WARN_NO_EMAIL	= _("Please specify the packager E-Mail address.")
	MSG_WARN_NO_VENDOR	= _("Please specify the package vendor.")
	MSG_WARN_NO_COPYRIGHT	= _("Please specify the package copyright.")
	MSG_WARN_NO_SELDEPPKG	= _("Please select the depend package.")
	MSG_WARN_NO_INPUTDEPPKG	= _("Please specify the depend package.")
	MSG_WARN_NO_LOCALPKGDIR	= _("Please specify the package search directory.")

	TITLE_SEL_PKGDIR = _("Choose package search directory")

	#=== プラグインのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#dir:: プラグイン格納ディレクトリ
	#復帰値:: なし
	#
	def initialize(dir)
		super(File.join(dir, PROG_PATH), nil, PROG_NAME)
	
		@my_dir = dir

		@display_name = DISPLAY_NAME
		@version = VERSION
		@have_about = true			# about dialog is having
		@have_option = true			# Option dialog is not having
		@copyright = SSL_COPYRIGHT
		@license = SSL_LICENSE

# 		@readables = Array.new		# readable packages
		@initialize_deplistdlg = false
		@modified = false
		@notebook = nil
		@tab_page = Array.new
		@tmp_dirs = Array.new

		@tool_min_vl = "V1.0"

		make_option_dialog			# create option dialog
		read_option					# read option information
		make_detail_dialog			# create detail dialog parts
		make_depend_dialog			# create depend dialog parts

		init_environ				# initialize environment
	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		return tool_version >= @tool_min_vl
	end

	#=== プラグインの終了処理
	#
	#プラグイン固有の終了処理を実装する。基底クラスの終了処理では何もしない。
	#
	#復帰値:: なし
	#
	def end_plugin
		@tmp_dirs.each{|dir|
			begin
				FileUtils.rm_rf(dir)
			rescue
			end
		}
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		#パッケージ作成画面部品
		@glade["entry_name"].text = ""
		@glade["entry_version"].text = ""
		@glade["entry_release"].text = ""
		@glade["entry_summary"].text = ""
		@glade["textview_desc"].buffer.text = ""

		#パッケージ詳細情報ダイアログ部品
		@glade["combobox_group"].active = 0
		@glade["combobox_arch"].active = 0
		@glade["entry_packager"].text = ""
		@glade["entry_email"].text = ""
		@glade["entry_vendor"].text = ""
		@glade["entry_copyright"].text = ""
		@glade["textview_changelog"].buffer.text = ""
		@glade["treeview_depend"].model.clear

# 		@readables.clear
		@modified = false
		@pkg_make_name = ""
		@pkg_make_vl = ""
		@pkg_make_rel = ""
		@pkg_make_dir = ""
	end

	#=== インストール済みパッケージの一覧取得
	#
	#リマスタリング対象OS上にインストールされているパッケージの一覧を取得する。
	#
	#復帰値:: インストール済みパッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージサイズ, パッケージ説明文]
	#
	def get_installed_packages
		ret_ary = Array.new
		regexp = /^ /
		out_ary = Array.new
		RTUtility.exec_remasterOS_command(CMD_INSTALLED, out_ary, nil, nil,
			RTUtility.mainWindow, MSG_INF_PKG_INSTALLED, false, false)
		# 取得したデータを返却用の形式に成形する。
		out_ary.each {|line| ret_ary.push line.split("__DELIM__") }
		ret_ary
	end

	#=== インストール可能パッケージの一覧取得
	#
	#リマスタリング対象OS上にインストール可能なパッケージの一覧を取得する。
	#
	#復帰値:: インストール可能パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージ説明文]
	#
	def get_installable_packages
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_INSTALLABLE)
		ret_ary = get_packages(true)
		RTUtility.end_wait_window
		ret_ary
	end

	#=== パッケージインデックスの更新
	#
	#パッケージインデックスを最新化する。
	#yumコマンドでは不要なので次にインストール可能パッケージ一覧取得が実行されたときに
	#内部のキャッシュを使用しないようにキャッシュをクリアする処理だけ実行する。
	#
	#復帰値:: なし
	#
	def update_package_index
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_UPDATE)
		# 作業用OS上のローカルパッケージ検索ディレクトリからリマスタリング対象OSのローカルパッケージ
		# 検索ディレクトリにパッケージファイルをコピーする
		FileUtils.mkdir_p(File.join(RTUtility.get_os_plugin.get_root_dir, @glade["entry_pkgdir"].text))
		RTUtility.exec_workOS_command(sprintf("cp -r %s %s",
			@glade["entry_pkgdir"].text + "/*.rpm",
			File.join(RTUtility.get_os_plugin.get_root_dir, @glade["entry_pkgdir"].text)))

		# sources.listにローカルパッケージ検索ディレクトリを追加する(yumでローカルディレクトリ上
		# のパッケージファイルを扱うことができるようにする)
		add_source_list
		RTUtility.end_wait_window
	end

	#=== パッケージ作成画面の右上ペインに表示するWidgetの返却
	#
	#パッケージ作成画面でパッケージ形式「RPM」が選択されたときに表示する
	#Widgetを返却する。
	#
	#復帰値:: パッケージ作成画面に表示するWidget
	#
	def get_makePackage_widget
		@glade["vbox_mkpackage"]
	end

	#=== オプションダイアログの表示
	#
	#RPMプラグインのオプションダイアログを表示する。
	#
	#復帰値:: なし
	#
	def show_option
		@glade["dialog_option"].set_transient_for(RTUtility.mainWindow)
		@glade["dialog_option"].show
	end

	#=== 読み込み可能パッケージの一覧取得
	#
	#作業用OS上で読み込み可能なパッケージの一覧を取得する。
	#
	#復帰値:: 読み込み可能パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージ説明文]
	#
	def get_readable_packages
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_INSTALLABLE)
		ret_ary = get_packages(false)

		# ローカルパッケージの情報取得
		outAry = Array.new
		Dir[File.join(@glade["entry_pkgdir"].text.strip, "*.rpm")].each{|rpm|
			outAry.clear
			if RTUtility.exec_workOS_command(CMD_INSTALLABLE_LOCAL + rpm, outAry, nil, nil, nil, "", false)
				ary = outAry[0].split("__DELIM__")
				ret_ary.push ary unless ret_ary.include?(ary)
			end
		}
		RTUtility.end_wait_window
		ret_ary
	end

	#=== 依存パッケージ一覧の取得
	#
	#パラメタの操作を行うことによりインストールまたはアンインストールされるパッケージの一覧
	#を返却する。
	#また、パラメタ download が true の場合、パッケージをキャッシュディレクトリにダウン
	#ロードする。
	#
	#pkgs:: インストール／アンインストールパッケージ情報配列
	#       [ [インストールパッケージ１, バージョン1], [インストールパッケージ2, バージョン2], ... ]
	#operation::操作(true=インストール、false=アンインストール)
	#download::パッケージのダウンロードの要/不要。true=要、false=不要(省略時はfalse)
	#復帰値:: 依存パッケージ情報の2次元配列
	#          ary1[ary2, ary2, ary2...]
	#          ary2= [パッケージ名、バージョン、操作(true=インストール、false=アンインストール),
	#					 インストール/アンインストール操作コマンド]
	#
	def get_depend_packages(pkgs, opration, download = false)
		all_pkg = Array.new
		pkgs.each{|ary| all_pkg.push(ary[0]) }
		pkg_str = all_pkg.join(" ")
		cmd_exec = sprintf(CMD_INSTALL_PKGS, operation ? "install" : "remove", pkg_str)
		cmd = sprintf(operation ? CMD_GET_DPENDS_INSTALL : CMD_GET_DPENDS_UNINSTALL, pkg_str)
		cmd_out_ary = Array.new
		ret_ary = Array.new
		RTUtility.exec_remasterOS_command(cmd, cmd_out_ary, nil, nil, RTUtility.mainWindow, MSG_INF_PKG_RESOLVE, true, true)

		cmd_out_ary.each{|url|
			if operation
				pkg_file = File.basename(url)
				next unless pkg_file =~ /\.rpm$/
				pkg_file.sub(/(^.+?)-(.+)\.[A-Za-z0-9]+\.rpm/, "")
				ret_ary.push([$~[1], $~[2], true, ret_ary.empty? ? cmd_exec : ""])
			else
				pkg_info = url.split
				ret_ary.push([pkg_info[0], pkg_info[2], false, ret_ary.empty? ? cmd_exec : ""])
			end
	
			# ダウンロード指定がtrue、かつ、インストール対象パッケージが1つ以上ある場合はapt-getコマンドを発行
			begin
				download_package(ret_ary.last[0], ret_ary.last[1]) if download && operation
			rescue
				RTUtility.get_logger.error("rpm:get_depend_packages: " + $!.to_s)
			end
		}
		ret_ary
	end

	#=== インストール後の環境掃除
	#
	#インストール成功後にパッケージファイルなどの掃除を行う。
	#
	#復帰値:: なし
	#
	def clear
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_DELETE)
		# リマスタリング作業用リソースの退避
		backup_resource
		# パッケージファイルを削除する
		RTUtility.exec_remasterOS_command(sprintf(CMD_CLEAN, @glade["entry_pkgdir"].text))
		RTUtility.end_wait_window
	end

	#=== リマスタリング環境のインポート
	#
	#引数のdirで示すディレクトリ内の資産を現在のリマスタリング環境に適用する。
	#
	#dir:: インポート資源ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def import(dir)
		source_list = File.join(RTUtility.get_os_plugin.get_root_dir, "etc")
		pkg_dir = File.join(RTUtility.get_os_plugin.get_root_dir,
						@glade["entry_pkgdir"].text)

		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_WAIT_IMPORT)
		begin
			# パッケージファイルを（リマスタOS上の)ローカルパッケージ検索ディレクトリに格納する
			file_ary = Dir.glob(File.join(dir, "*.rpm"))
			FileUtils.mkdir_p(pkg_dir)
			RTUtility.exec_workOS_command("cp -a " + dir + "/*.rpm " + pkg_dir) unless file_ary.empty?

			# repos.dをリマスタOS上の)/etc/yum.repos.dに格納する
			src = File.join(dir, "yum.repos.d")
			if File.exist?(src)
				RTUtility.exec_workOS_command("cp -a " + src + " " + source_list)
			end

			# リマスタリング対象OS上のローカルパッケージ検索ディレクトリにyum repositoryを作成する
			add_source_list

			RTUtility.end_wait_window

		rescue
			RTUtility.end_wait_window
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
						Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_IMPORT, $!.to_s))
			dlg.run
			dlg.destroy
			return false
		end
		true
	end

	#=== リマスタリング環境のエクスポート
	#
	#引数のdirで示すディレクトリにの現在のリマスタリング環境資産を格納する。
	#
	#dir:: エクスポート先ディレクトリ
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def export(dir)
		RTUtility.show_wait_window(RTUtility.mainWindow, MSG_WAIT_EXPORT)
		begin
			backup_resource
			src = File.join(@glade["entry_pkgdir"].text, "*")
			
			unless Dir[src].empty?
				FileUtils.mkdir_p(dir)
				RTUtility.exec_workOS_command("cp -a " + src + " " + dir)
			end
				RTUtility.end_wait_window
		rescue
			RTUtility.end_wait_window
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
						Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, sprintf(MSG_ERR_EXPORT, $!.to_s))
			dlg.run
			dlg.destroy
			return false
		end
		true
	end


private

	########################################
	# パッケージ作成画面
	########################################
	#=== [詳細]ボタンクリック持のイベントハンドラ
	#
	#パッケージ詳細情報ダイアログを表示する。
	#
	#widget:: [詳細]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_main_detail_clicked(widget)
		@glade["dialog_detail"].set_transient_for(RTUtility.mainWindow)
		@glade["dialog_detail"].show
	end


	########################################
	# Option dialog
	########################################

	#=== オプションダイアログの作成
	#
	#オプションダイアログ内の部品を作成する。
	#
	#復帰値:: なし
	#
	def make_option_dialog
		@notebook = Gtk::Notebook.new
		@glade["dialog-option-vbox"].pack_start(@notebook, true, true, 10)
		@glade["dialog-option-vbox"].reorder_child(@notebook, 0)
	end

	#=== オプション情報の読み込み
	#
	#オプション情報を読み込み、対応する部品に設定する。
	#
	#復帰値:: なし
	#
	def read_option
		# パッケージ検索ディレクトリの読み込み
		gconf = GConf::Client.default
		@glade["entry_pkgdir"].text = gconf[CONF_KEY_SEARCHDIR] ? gconf[CONF_KEY_SEARCHDIR] : DEFAULT_SEARCHDIR
		@tab_page.clear
	end


	#=== オプションダイアログ表示時のイベントハンドラ
	#
	#/etc/apt/sources.listを読み込みダイアログのテキストビューに設定する。
	#
	#widget:: オプションダイアログのWidget
	#復帰値:: なし
	#
	def on_dialog_option_map(widget)
		begin
			# 初期設定が完了していいない場合、表示域を無効状態にして警告メッセージを表示する
			raise MSG_WARN_OPT_NOINIT unless RTUtility.isInitialized?

			style = Gtk::Style.new
			style.font_desc = Pango::FontDescription.new("Sans 12")
			Dir[File.join(RTUtility.get_os_plugin.get_root_dir, PATH_YAM_REPOS, "/*")].each {|file|
				scroll = Gtk::ScrolledWindow.new
				scroll.shadow_type = Gtk::SHADOW_IN
				scroll.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
				buffer = Gtk::TextBuffer.new
				textview = Gtk::TextView.new(buffer)
				buffer.set_text(RTUtility.read_file(file))
				textview.style = style
				scroll.add(textview)
				label = Gtk::Label.new(File.basename(file))
				label.style = style
				@notebook.append_page(scroll, label)
				@tab_page.push scroll
			}
			@notebook.show_all
			@notebook.page = 0
			@notebook.sensitive = true

			raise MSG_WARN_OPT_NOREPOS if @tab_page.empty?

		rescue
			# 表示域を無効状態にして警告メッセージを表示する
			scroll = Gtk::ScrolledWindow.new
			scroll.shadow_type = Gtk::SHADOW_IN
			scroll.set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC)
			while @notebook.n_pages > 0
				@notebook.remove_page(0)
			end
			@notebook.sensitive = false
			@notebook.append_page(scroll, nil)
			@notebook.show_all
			@tab_page.clear
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING,
					Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return
		end
	end

	#=== [参照]ボタンクリック持のイベントハンドラ
	#
	#[参照]ボタンクリック時にディレクトリ選択ダイアログを開き、ローカルパッケージ検索ディレクトリを
	#選択する。
	#
	#widget:: [参照]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_pkgdir_clicked(widget)
		chooser = Gtk::FileChooserDialog.new(TITLE_SEL_PKGDIR,
												@glade["dialog_option"],
												Gtk::FileChooser::ACTION_SELECT_FOLDER,
												nil,
												[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
												[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		@glade["entry_pkgdir"].set_text(chooser.filename) if chooser.run == Gtk::Dialog::RESPONSE_OK
		chooser.destroy
	end


	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時にキャンセルボタンのハンドラを呼び出し、キャンセルボタンと同じ動作を実現する。
	#
	#widget:: オプションダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_option_delete_event(widget, arg0)
		on_button_option_cancel_clicked(@glade["button_option_cancel"])
	end

	#=== [キャンセル]ボタンクリック持のイベントハンドラ
	#
	#[キャンセル]ボタンクリック時にオプションダイアログを閉じる。
	#
	#widget:: キャンセルボタンのWidget
	#復帰値:: なし
	#
	def on_button_option_cancel_clicked(widget)
		# すべてのタブページを削除してからダイアログを非表示にする
		while @notebook.n_pages > 0
			@notebook.remove_page(0)
		end
		@tab_page.clear
		@glade["dialog_option"].hide
		read_option
	end

	#=== [OK]ボタンクリック持のイベントハンドラ
	#
	#[OK]ボタンクリック時にオプション情報を保存してからダイアログを閉じる。
	#
	#widget:: OKボタンのWidget
	#復帰値:: なし
	#
	def on_button_option_ok_clicked(widget)
		# 入力チェック
		if @glade["entry_pkgdir"].text.strip.empty?
			dlg = Gtk::MessageDialog.new(@glade["dialog_option"], Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING, Gtk::MessageDialog::BUTTONS_OK,
					MSG_WARN_NO_LOCALPKGDIR)
			dlg.run
			dlg.destroy
			return
		end

		@tab_page.each{|scrolled|
			sourceList = File::SEPARATOR +
						File.join(PATH_YAM_REPOS, @notebook.get_tab_label_text(scrolled))
			RTUtility.write_file(sourceList, scrolled.child.buffer.text, true)
		}

		@glade["entry_pkgdir"].text = @glade["entry_pkgdir"].text.strip

		# リマスタリング対象OS上のローカルパッケージ検索ディレクトリにyum repositoryを作成する
		add_source_list unless @tab_page.empty?

		gconf = GConf::Client.default
		gconf[CONF_KEY_SEARCHDIR] = @glade["entry_pkgdir"].text.strip

		# キャンセルボタンハンドラでダイアログを閉じる
		on_button_option_cancel_clicked(@glade["button_option_cancel"])
	end

	########################################################
	# パッケージ作成機能
	########################################################

public

	#=== パッケージの読み込み
	#
	#パッケージファイルを展開して内容を読み込む。
	#
	#name:: パッケージ名
	#version:: パッケージバージョン
	#復帰値:: なし
	#
	def read_package(name, version)
		temp = ""
		begin
			# パッケージファイルの場所を取得
			pkg_path = search_package(name, version)

			# お待ちくださいウインドウを表示する。
			RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_PKG_EXTRACT)

			# 展開先ディレクトリを作成
			temp = make_directory
	
			# 返却用のパッケージ内ファイル一覧リストを作成する
			ret_ary = get_file_list(pkg_path, temp)
	
			# controlファイルの読み込み
			apply_control(pkg_path, temp)
			RTUtility.end_wait_window

		rescue
			RTUtility.end_wait_window
			RTUtility.get_logger.error("rpm:read_package: " + $!.to_s)
			# パッケージ読み込み中にエラーが発生した場合はエラーメッセージを表示する
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return
		end

		ret_ary
	end

	#=== パッケージの作成
	#
	#パッケージ作成画面で設定した情報にしたがってパッケージを作成する。
	#
	#fileAry:: パッケージ内容ファイルリスト
	#          Array1 = [Array2, Array2, ...]
    #          Array2 = [fileパス, file prefix]
	#作成パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、常にtrue, インストール操作コマンド]
	#備考::作成したパッケージは ローカルパッケージ検索ディレクトリにコピーする．
	#
	def make_package(fileAry)
		pkg_array = nil

		#設定項目のチェック
		return unless check_input

		begin
			if @pkg_make_dir.empty? or @pkg_make_name.empty? or @pkg_make_vl.empty? or @pkg_make_rel.empty? or
				@pkg_make_name != @glade["entry_name"].text or
				@pkg_make_vl != @glade["entry_version"].text or
				@pkg_make_rel != @glade["entry_release"].text

				# パッケージディレクトリの作成
				@pkg_make_dir = make_directory
				# パッケージ雛型の作成
				@pkg_make_dir = make_templete @pkg_make_dir

				@pkg_make_name = @glade["entry_name"].text
				@pkg_make_vl = @glade["entry_version"].text
				@pkg_make_rel = @glade["entry_release"].text
			end

			# パッケージ格納ファイルのコピー
			copy_file(@pkg_make_dir, fileAry)
	
			# パッケージの作成
			pkg_array = make @pkg_make_dir
			if pkg_array
				@pkg_make_dir = ""
			end

		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::ERROR, Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return nil
		end
		pkg_array
	end

private

	#=== パッケージ格納ディレクトリの取得
	#
	#指定されたパッケージをローカルパッケージ検索ディレクトリから検索する。見付からない場合、ネットワーク
	#上からダウンロードする。ダウンロードできない場合、例外を発生する。
	#
	#name:: パッケージ名
	#version:: パッケージバージョン
	#復帰値:: パッケージファイルのパス（絶対パス）
	#
	def search_package(name, version)
		path = ""

		# 展開するパッケージをローカルパッケージ検索ディレクトリ内から検索する
		files = Dir[File.join(@glade["entry_pkgdir"].text, name + "-" + version + ".*.rpm") ]
		if files.size > 0
			path = files[0]
		else
			# ローカルパッケージ検索ディレクトリに存在しない場合、ダウンロードする
			download_package(name, version, false)
			files = Dir[File.join(@glade["entry_pkgdir"].text, name + "-" + version + ".*.rpm") ]
			raise MSG_ERR_NO_PACKAGE if files.empty?
			path = files[0]
		end
		path
	end

	#=== パッケージ内ファイル一覧の取得
	#
	#指定されたパッケージファイルを指定のテンプディレクトリに展開し、含まれるファイルの一覧を
	#作成する。
	#
	#pkg_file:: パッケージファイル名（絶対パス形式）
	#temp:: パッケージ展開用テンプディレクトリ
	#復帰値:: ファイルリスト
	#        Array1 = [Array2, Array2, ...]
	#        Array2 = [ファイル名、ディレクトリ名、プレフィックス（作業ディレクトリ）
	#備考:: ディレクトリ名は絶対パスから展開用のテンプディレクトリを削除したパス（インス
	#       トールパス）にして返却する。プレフィックスるには取り除いたパス（展開用テンプディレクトリ）
	#       のパスを設定する。
	#
	def get_file_list(pkg_file, temp)
		# パッケージの展開
		status = RTUtility.exec_workOS_command(sprintf(CMD_EXTRACT_PKG, temp, pkg_file))
		raise sprintf(MSG_ERR_EXTRACT_PACKAGE, status) unless status == 0

		# ファイル一覧リストの作成
		ret_ary = Array.new
		Find.find(temp) {|file|
			# 配列は[ファイル名, ディレクトリ名, プレフィックス]
			unless File.directory?(file)			# ディレクトリは除外
				ret_ary.push( [ File.basename(file.sub(temp, "")), File.dirname(file.sub(temp, "")), temp ])
			end
		 }
		ret_ary
	end

	#=== パッケージのダウンロード
	#
	#指定されたパッケージをダウンロードする。
	#
	#name:: パッケージ名
	#version:: パッケージバージョン
	#remasteros:: ダウンロード先 true=理マスタリング対象OS, false=作業用OS
	#復帰値:: なし
	#
	def download_package(name, version, remasteros = true)
		# yumdownloadコマンドでパッケージとバージョンを指定してダウンロードする
		# yumではバージョン指定はできないのでパッケージ名を指定してダウンロードする
		cmd = sprintf(CMD_GET_PKGS, @glade["entry_pkgdir"].text, @glade["entry_pkgdir"].text, name)
		status = 0
		if remasteros
			RTUtility.get_logger.debug("download package #{name} to remastering os")
			status = RTUtility.exec_remasterOS_command(cmd, nil, nil, nil, RTUtility.mainWindow, sprintf(MSG_INF_PKG_DOWNLOAD, name), true, true)
		else
			RTUtility.get_logger.debug("download package #{name} to work os")
			RTUtility.show_wait_window(RTUtility.mainWindow, sprintf(MSG_INF_PKG_DOWNLOAD, name))
			status = RTUtility.exec_workOS_command(cmd)
			RTUtility.end_wait_window
		end
		raise sprintf(MSG_ERR_DOWNLOAD_PACKAGE, status) unless status == 0
	end

	#=== controlファイルの読み込み
	#
	#パッケージを展開してコントロールを抽出する。
	#
	#pkg_file:: パッケージファイル名（絶対パス形式）
	#temp:: パッケージ展開用テンプディレクトリ
	#復帰値:: なし
	#
	def apply_control(pkg_file, temp)
		# パッケージファイルを展開して制御ファイルを抽出する
		out_ary = Array.new
		status = RTUtility.exec_workOS_command(sprintf(CMD_EXTRACT_CTL, pkg_file), out_ary)
		raise sprintf(MSG_ERR_EXTRACT_PACKAGE, status) unless status == 0

		@glade["entry_name"].text = out_ary[0]
		@glade["entry_version"].text = out_ary[1]
		@glade["entry_release"].text = out_ary[2]
		@glade["entry_summary"].text = out_ary[3]
		set_combo(@glade["combobox_group"], out_ary[4])
		set_combo(@glade["combobox_arch"], out_ary[5])
		if out_ary[6] =~ /^(.+) <(.*)>/
			@glade["entry_packager"].text = $~[1]
			@glade["entry_email"].text = $~[2]
		else
			@glade["entry_packager"].text = out_ary[6]
			@glade["entry_email"].text = ""
		end
		@glade["entry_vendor"].text = out_ary[7]
		@glade["entry_copyright"].text = out_ary[8]

		# 説明文の取得
		out_ary.clear
		status = RTUtility.exec_workOS_command(sprintf(CMD_EXTRACT_CTL2, pkg_file), out_ary)
		raise sprintf(MSG_ERR_EXTRACT_PACKAGE, status) unless status == 0
		@glade["textview_desc"].buffer.text = out_ary.join("\n")

		# 更新履歴
		out_ary.clear
		status = RTUtility.exec_workOS_command(sprintf(CMD_EXTRACT_CTL3, pkg_file), out_ary)
		raise sprintf(MSG_ERR_EXTRACT_PACKAGE, status) unless status == 0
		@glade["textview_changelog"].buffer.text = out_ary.join("\n")

		# 依存関係の取得
		@glade["treeview_depend"].model.clear
		["Requires", "Conflicts", "Obsoletes"].each{ |rel| analyze_relation(rel, pkg_file) }
	end

	#=== 依存関係の解析
	#
	#パッケージ依存関係を取得して詳細情報ダイアログの依存関係リストに設定する。
	#
	#relation:: 依存関係
	#pkg_file:: パッケージファイル名
	#復帰値:: なし
	#
	def analyze_relation(relation, pkg_file)
		cmd = sprintf(CMD_EXTRACT_CTL4, relation.downcase, pkg_file)
		out_ary = Array.new
		status = RTUtility.exec_workOS_command(cmd, out_ary)
		out_ary.each{|line|
			line_elm = line.split
			if line_elm.size >= 3
				RTUtility.add_list(@glade["treeview_depend"], [line_elm[0], line_elm[1] + " " + line_elm[2],  relation])
			else
				RTUtility.add_list(@glade["treeview_depend"], [line_elm[0], "", relation])
			end
		}

	end

	#=== パッケージ作成画面の入力チェック
	#
	#パッケージを作成するときに必須入力項目がすべて入力されているかチェックする。
	#
	#復帰値:: なし
	#
	def check_input
		# 必須入力項目がすべて入力されているかチェックする
		begin
			raise MSG_WARN_NO_NAME if @glade["entry_name"].text.strip.empty?
			raise MSG_WARN_NO_VERSION if @glade["entry_version"].text.strip.empty?
			raise MSG_WARN_NO_RELEASE if @glade["entry_release"].text.strip.empty?
			raise MSG_WARN_NO_SUMMARY if @glade["entry_summary"].text.strip.empty?
			raise MSG_WARN_NO_DESC if @glade["textview_desc"].buffer.text.strip.empty?
			raise MSG_WARN_NO_GROUP if @glade["combobox_group"].active_text.strip.empty?
			raise MSG_WARN_NO_ARCH if @glade["combobox_arch"].active_text.strip.empty?
			raise MSG_WARN_NO_MAINT if @glade["entry_packager"].text.strip.empty?
			raise MSG_WARN_NO_EMAIL if @glade["entry_email"].text.strip.empty?
			raise MSG_WARN_NO_VENDOR if @glade["entry_vendor"].text.strip.empty?
			raise MSG_WARN_NO_COPYRIGHT if @glade["entry_copyright"].text.strip.empty?

			[ @glade["entry_name"], @glade["entry_version"], @glade["entry_release"],
			  @glade["entry_summary"], @glade["entry_packager"], @glade["entry_email"],
			  @glade["entry_vendor"], @glade["entry_copyright"], @glade["textview_desc"].buffer ].each{|widget|
				widget.text = widget.text.strip
			}

#★★GtkComboBoxEntryの前後の空白をstripして再設定する方法がわからない...
#			[@glade["combobox_group"], @glade["combobox_arch"] ].each{|widget|
#				widget.text_column = widget.active_text.strip
#			}
			true

		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING, Gtk::MessageDialog::BUTTONS_OK,
					$!.to_s)
			dlg.run
			dlg.destroy
			false
		end
	end

	#=== パッケージ作成用ディレクトリの作成
	#
	#パッケージ作成用のディレクトリを作成する。
	#
	#復帰値:: BOOL true=正常終了、false=異常終了
	#
	def make_directory
		index = 0
		temp = File.join(Dir.tmpdir, DISPLAY_NAME + $$.to_s + index.to_s)
		begin
			while true
				File.ftype(temp)
				index = index + 1
				temp = File.join(Dir.tmpdir, DISPLAY_NAME + $$.to_s + index.to_s)
			end
		rescue
		end

		FileUtils.mkdir_p(temp)
		@tmp_dirs.push(temp)
		temp
	end

	#=== パッケージテンプレートの作成
	#
	#パッケージ作成用のテンプレートを作成する。
	#
	#dir:: パッケージテンプレート作成用ディレクトリ
	#復帰値:: パッケージテンプレート格納ディレクトリ
	#
	def make_templete(dir)
		# テンプレート作成用ディレクトリの作成
		FileUtils.mkdir_p(dir)

		# パッケージテンプレートの作成
		cmd = sprintf(CMD_MK_TEMPLETE, @my_dir, dir, @glade["entry_name"].text)
		status = RTUtility.exec_workOS_command(cmd)
		raise sprintf(MSG_ERR_CREATE_TEMPLETE, status) unless status == 0
		dir
	end

	#=== 内容のコピー
	#
	#パッケージ作成用のディレクトリを作成する。
	#
	#dir:: パッケージ作成用ディレクトリ
	#file_ary:: パッケージに含めるファイル名一覧
	#復帰値:: なし
	#
	def copy_file(dir, file_ary)
		# パッケージでインストールされるファイルのコピー
		dest_top = File.join(dir, @glade["entry_name"].text + "-" + @glade["entry_version"].text)
		FileUtils.rm_rf(File.join(dest_top, "*"))
		FileUtils.mkdir_p(File.join(dest_top, "pkg_files"))
		install_files = Array.new
		file_ary.each{|ary|
			src  = File.join(ary[1], ary[0])
			dest = File.join(dest_top, "pkg_files", ary[0])
			if FileTest.directory?(src) && FileTest.directory?(dest)
				dest = File.dirname(dest)
			else
				FileUtils.mkdir_p(File.dirname(dest))
			end
			RTUtility.exec_workOS_command("cp -a #{src} #{dest}")
			install_files.push ary[0]
		}
		# control ファイルの内容置換
		control = RTUtility.read_file(File.join(dir, @glade["entry_name"].text + ".spec.templete"))
		control.sub!("$$__NAME__$$", @glade["entry_name"].text)
		control.sub!("$$__VERSION__$$", @glade["entry_version"].text)
		control.sub!("$$__RELEASE__$$", @glade["entry_release"].text)
		control.sub!("$$__SUMMARY__$$", @glade["entry_summary"].text)
		control.sub!("$$__COPYRIGHT__$$", @glade["entry_copyright"].text)
		control.sub!("$$__GROUP__$$", @glade["combobox_group"].active_text)
		control.sub!("$$__VENDOR__$$", @glade["entry_vendor"].text)
		control.sub!("$$__DESCRIPTION__$$", @glade["textview_desc"].buffer.text)
		control.sub!("$$__CHANGELOG__$$", @glade["textview_changelog"].buffer.text)
		control.sub!("$$__PACKAGER__$$", @glade["entry_packager"].text + " < " + @glade["entry_email"].text + " >")
		relation = ""
		RELS.each{|rel| relation << get_relation(rel) }
		relation.chomp!
		control.sub!("$$__DEPENDS__$$", relation)
		control.sub!("$$__INSTALLFILES__$$", install_files.join("\n"))


		# 編集したcontrol ファイルを書き戻す
		RTUtility.write_file(File.join(dir, @glade["entry_name"].text + ".spec"), control)

		# Makefileのコピー
		FileUtils.cp(File.join(@my_dir, "Makefile.buildpackage"), File.join(dest_top, "Makefile"))
	end

	#=== 依存関係の抽出
	#
	#パラメタで指定された依存関係をcontrolファイルの形式で抽出する。
	#
	#rel:: 抽出する依存関係
	#復帰値:: 依存関係文字列
	#
	def get_relation(rel)
		
		rel_str = rel + ": "
		iter = @glade["treeview_depend"].model.iter_first
		if iter
			begin
				if iter[2] == rel
					rel_str << iter[0]
					rel_str << " " + iter[1] unless iter[1].empty?
					rel_str << ","
				end
			end while iter.next!
		end
		if rel_str == rel + ": "
			rel_str = ""
		else
			rel_str = rel_str.sub(/,$/, "")
			rel_str = rel_str.sub(/$/, "\n")
		end
		rel_str
	end

	#=== パッケージの作成
	#
	#パッケージをビルドする。
	#
	#dir:: パッケージの雛型のディレクトリ
	#復帰値:: 作成したパッケージのじ情報 [パッケージ名,バージョン,true,インストールコマンド]
	#
	def make(dir)
		srcdir = get_rc("_sourcedir")
		# パッケージ作成コマンドの実行
		pkg_dir_name = File.join(@glade["entry_name"].text + "-" + @glade["entry_version"].text)
		cmd = sprintf(CMD_MK_PKG, dir,
				File.join(srcdir, pkg_dir_name + ".tar.gz"), pkg_dir_name,
				@glade["combobox_arch"].active_text, @glade["entry_name"].text)
		RTUtility.exec_workOS_command(cmd)
		ret_array = Array.new

		rpmpath = File.join(get_rc("_rpmdir"), @glade["combobox_arch"].active_text,
					@glade["entry_name"].text + "-" + @glade["entry_version"].text + "-" + @glade["entry_release"].text + "." + @glade["combobox_arch"].active_text + ".rpm")
		begin
			File.stat(rpmpath)
		rescue
			return nil
		end

		FileUtils.mkdir_p(@glade["entry_pkgdir"].text)
		FileUtils.cp(rpmpath, @glade["entry_pkgdir"].text)
		ret_array.push [@glade["entry_name"].text, @glade["entry_version"].text,
					 true,
					 sprintf(CMD_INSTALL_PKGS, "install", @glade["entry_name"].text)]

		# 作業用OS上のローカルパッケージ検索ディレクトリからリマスタリング対象OSのローカルパッケージ
		# 検索ディレクトリにパッケージファイルをコピーする
		if RTUtility.isInitialized?
			remaster_dir = File.join(RTUtility.get_os_plugin.get_root_dir, @glade["entry_pkgdir"].text)
			FileUtils.mkdir_p(remaster_dir)
			RTUtility.exec_workOS_command("mkdir -p " + remaster_dir + " && cp " + rpmpath + " " + remaster_dir)

			# sources.listにローカルパッケージ検索ディレクトリを追加する(apt-getでローカルディレクトリ上
			# のパッケージファイルを扱うことができるようにする)
			add_source_list
		end

		return ret_array
	end

	#=== rpmコマンド設定取得
	#
	#rpmコマンドで設定されるマクロ設定値を取得する。
	#
	#name:: 取得するマクロ名
	#復帰値:: マクロの設定値
	#
	def get_rc(name)
		value = ""
		out_ary = Array.new
		RTUtility.exec_workOS_command("rpm --showrc|grep #{name}", out_ary)
		out_ary.each{|line|
			line_ary = line.split
			if line_ary[1] == name
				if line_ary[2] =~ /%\{(.+)\}/
						line_ary[2] = line_ary[2].sub(/%\{.+\}/, get_rc($~[1]))
				end
				value = line_ary[2]
				break
			end
		}
		value
	end

	#=== /etc/apt/source.listへのエントリ追加
	#
	# /etc/apt/source.listにオプションダイアログで設定したローカルパッケージ検索ディレクトリを追加する。
	#
	#復帰値:: なし
	#
	def add_source_list
		local_yumrepo = sprintf(YUM_LOCAL_REPO, @glade["entry_pkgdir"].text)
		RTUtility.write_file(YUM_LOCAL_PATH, local_yumrepo, true)

		cmd = sprintf(CMD_APTARCH, @glade["entry_pkgdir"].text, @glade["entry_pkgdir"].text)
		status = RTUtility.exec_remasterOS_command(cmd)
	end

	#=== コンボボックスの選択項目の設定
	#
	#パラメタで指定されたコンボボックスをパラメタで指定した文字列が選択状態になるように設定する
	#
	#combo:: 選択状態を設定するコンボボックス
	#elm:: 選択状態を設定するテキストが設定されているXMLエレメント
	#復帰値:: なし
	#
	def set_combo(combo, text)
		combo.model.each do |model,path,iter|
			if iter[0].casecmp(text) == 0
				combo.active_iter = iter
				break
			end
		end
	end

	########################################
	# パッケージ詳細情報 dialog
	########################################

	#=== パッケージ詳細情報ダイアログの初期化
	#
	#パッケージ詳細情報ダイアログ内の部品を初期化する。
	#
	#復帰値:: なし
	#
	def make_detail_dialog
		# グループコンボボックスの内容設定
		GROUPS.each { |str| @glade["combobox_group"].append_text(str) }
		# アーキテクチャコンボボックスの内容設定
		ARCHS.each { |str| @glade["combobox_arch"].append_text(str) }

		# 依存関係リストのヘッダを作成する
		PKG_DEPLIST_HEADER.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			@glade["treeview_depend"].append_column(column)
		}
		@glade["treeview_depend"].set_model( Gtk::ListStore.new(String, String, String))
		@glade["treeview_depend"].selection.mode = Gtk::SELECTION_MULTIPLE
	end

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時にダイアログを閉じる。
	#
	#widget:: パッケージ情報詳細ダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_detail_delete_event(widget, arg0)
		@glade["dialog_detail"].hide
	end

	#=== [閉じる]ボタンクリック持のイベントハンドラ
	#
	#[閉じる]ボタンクリック時にダイアログを閉じる。
	#
	#widget:: [閉じる]ボタンのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_button_detail_close_clicked(widget)
		@glade["dialog_detail"].hide
	end

	#=== [追加]ボタンクリック持のイベントハンドラ
	#
	#依存パッケージ選択ダイアログを開く。
	#
	#widget:: [追加]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_detail_add_clicked(widget)
		@glade["dialog_pkgselect"].set_transient_for(@glade["dialog_detail"])
		@glade["dialog_pkgselect"].show
	end

	#=== 依存パッケージの追加
	#
	#依存パッケージパッケージ選択ダイアログで選択したパッケージを依存パッケージリストに追加する。
	#
	#addArry:: 追加するパッケージ情報(2次元配列)
	#         [[name1, dep version1, relation1],[name2, dep version2, relation2],...]
	#復帰値:: なし
	#
	def add_deplist(addArry)
		addArry.each{ |pkginf|
			iter = @glade["treeview_depend"].model.append
			iter[0] = pkginf[0]
			iter[1] = pkginf[1]
			iter[2] = pkginf[2]
		}
	end

	#=== [削除]ボタンクリック持のイベントハンドラ
	#
	#依存パッケージリストから選択されたパッケージを削除する。
	#
	# 	#widget:: [削除]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_detail_del_clicked(widget)
		RTUtility.del_list(@glade["treeview_depend"])
	end

	########################################
	# 依存パッケージ選択 dialog
	########################################

	#=== 依存パッケージ選択ダイアログの初期化
	#
	#依存パッケージ選択内の部品を初期化する。
	#
	#復帰値:: なし
	#
	def make_depend_dialog
		# パッケージリストのヘッダを作成する
		PKG_SELDEPLIST_HEADER.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i)
			column.resizable = true
			@glade["treeview_dep_pkglist"].append_column(column)
		}
		@glade["treeview_dep_pkglist"].set_model(Gtk::ListStore.new(String, String))
		@glade["treeview_dep_pkglist"].selection.mode = Gtk::SELECTION_MULTIPLE

		# バージョン比較のコンボボックスを作成
		COMPS.each { |cmp| @glade["combobox_compare"].append_text(cmp) }

		# 関係のコンボボックスを作成
		RELS.each { |rel| @glade["combobox_relation"].append_text(rel) }
	end

	#=== ラジオボタンクリック持のイベントハンドラ
	#
	#ラジオボタンクリック時に非選択側の入力域を無効状態にする。
	#
	#widget:: クリックしたラジオボタンのWidget
	#復帰値:: なし
	#
	def on_radio_list_clicked(widget)
		if widget == @glade["radio_list"]
			@glade["treeview_dep_pkglist"].set_sensitive true
			@glade["entry_dep_package"].set_sensitive false
		else
			@glade["treeview_dep_pkglist"].set_sensitive false
			@glade["entry_dep_package"].set_sensitive true
		end
	end

	#=== [x]ボタンクリック持のイベントハンドラ
	#
	#[x]ボタンクリック時にキャンセルボタンのハンドラを呼び出し、キャンセルボタンと同じ動作を実現する。
	#
	#widget:: 依存パッケージ選択ダイアログのWidget
	#arg0:: 未使用
	#復帰値:: なし
	#
	def on_dialog_pkgselect_delete_event(widget, arg0)
		on_button_selpkg_cancel_clicked(@glade["button_selpkg_cancel"])
	end

	#=== [キャンセル]ボタンクリック持のイベントハンドラ
	#
	#[キャンセル]ボタンクリック時にダイアログを閉じる。
	#
	#widget:: [キャンセル]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_selpkg_cancel_clicked(widget)
		@glade["dialog_pkgselect"].hide
	end

	#=== [OK]ボタンクリック持のイベントハンドラ
	#
	#[OK]ボタンクリック時に依存パッケージ情報を詳細設定ダイアログに通知し、ダイアログを閉じる。
	#
	#widget:: [OK]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_selpkg_ok_clicked(widget)
		addPkgs = Array.new
		begin
			if @glade["radio_list"].active?
				# リストから選択
					selection = false
				@glade["treeview_dep_pkglist"].selection.selected_each{|model, path, iter|
					addPkgs.push(
						make_dep_array(iter[0], @glade["entry_dep_version"].text.strip, 
									@glade["combobox_compare"].active_text,
									@glade["combobox_relation"].active_text))
					selection = true
				}
				raise MSG_WARN_NO_SELDEPPKG unless selection
			else
				# 直接指定
				raise MSG_WARN_NO_INPUTDEPPKG if @glade["entry_dep_package"].text.strip.empty?

				addPkgs.push(
					make_dep_array(@glade["entry_dep_package"].text,
								@glade["entry_dep_version"].text.strip,
								@glade["combobox_compare"].active_text,
								@glade["combobox_relation"].active_text))
			end
			add_deplist addPkgs
			@glade["dialog_pkgselect"].hide

		rescue
			# パッケージ読み込み中にエラーが発生した場合はエラーメッセージを表示する
			dlg = Gtk::MessageDialog.new(@glade["dialog_pkgselect"], Gtk::Dialog::MODAL,
					Gtk::MessageDialog::WARNING, Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return
		end
	end

	#=== 依存パッケージ情報配列の作成
	#
	#依存パッケージ情報を配列(name, depend version, relation)にして返却する。
	#
	#name:: パッケージ名
	#dep_version:: 依存するバージョン
	#compare:: バージョン比較方法
	#relation:: 関係
	#復帰値:: 依存パッケージ情報
	#         [name1, compare dep version, relation]
	#
	def make_dep_array(name, dep_version, compare, relation)
		if dep_version.strip.empty?
			version = ""
		else
			version = compare.strip  + " " + dep_version.strip
		end
		[name.strip, version, relation]
	end

	#=== 依存パッケージ選択ダイアログ表示イベントのハンドラ
	#
	#依存パッケージ選択ダイアログ表示時にダイアログ内を初期化する。
	#
	#widget:: 依存パッケージ選択ダイアログのWidget
	#復帰値:: なし
	#
	def on_dialog_pkgselect_map(widget)
		unless @initialize_deplistdlg
			installable = get_readable_packages
			installable.each { |ary|
				iter = @glade["treeview_dep_pkglist"].model.append
				iter[0] = ary[0]
				iter[1] = ary[2]
			}
			@initialize_deplistdlg = true
			@glade["treeview_dep_pkglist"].model.set_sort_column_id(0)	# =リストの先頭カラムでソート
		end

		@glade["combobox_compare"].active = 0
		@glade["combobox_relation"].active = 0
		@glade["radio_list"].clicked
		@glade["entry_dep_package"].text = ""
		@glade["entry_dep_version"].text = ""
		@glade["scrolledwindow_seldep_list"].vadjustment.value = @glade["scrolledwindow_seldep_list"].vadjustment.lower
		@glade["treeview_dep_pkglist"].selection.unselect_all

		@glade["radio_list"].clicked
	end

	#=== インストール可能パッケージの一覧取得
	#
	#リマスタリング対象OS上にインストール可能なパッケージの一覧を取得する。
	#
	#remaster:: 情報の取得先(true=リマスタリング対象OS, flase=作業用OS)
	#復帰値:: インストール可能パッケージ情報の2次元配列
	#        ary1[ary2, ary2, ary2...]
	#        ary2= [パッケージ名、バージョン、パッケージ説明文]
	#
	def get_packages(remater = true)
		outAry = Array.new
		regexp1 = /^Name *: (.+)/
		regexp2 = /^Version *: (.+)/
		regexp3 = /^Release *: (.+)/
		regexp4 = /^Summary *: (.+)/
		pkg = ""
		ver = ""
		rel = ""
		desc = ""

		if remater
			RTUtility.exec_remasterOS_command(CMD_INSTALLABLE, outAry, nil, nil,
				nil, "", false, false)
		else
			RTUtility.exec_workOS_command(CMD_INSTALLABLE, outAry, nil, nil,
				nil, "", false)
		end

		installableAry = Array.new
		outAry.each { |line|
			if regexp1 =~ line
				pkg = $~[1]
			elsif regexp2 =~ line
				ver = $~[1]
			elsif regexp3 =~ line
				rel = $~[1]
			elsif regexp4 =~ line
				desc = $~[1]
				unless pkg.empty? || ver.empty? || rel.empty? || desc.empty?
					installableAry.push [pkg, ver + VR_SPLIT + rel, desc]
				end
				pkg = ""
				ver = ""
				rel = ""
				desc = ""
			end
		}
		installableAry
	end

	#=== リマスタリング環境の保存
	#
	#リマスタリング作業中に保存したファイルを作業用OSのローカルパッケージ検索ディレクトリに退避する。
	#
	#復帰値:: なし
	#
	def backup_resource
		source_list = File.join(RTUtility.get_os_plugin.get_root_dir, PATH_YAM_REPOS)
		pkg_dir = File.join(RTUtility.get_os_plugin.get_root_dir,
						@glade["entry_pkgdir"].text)

		# リマスタOS上のローカルパッケージ検索ディレクトリの内容を作業用OSのローカルパッケージ検索dirに格納する
		FileUtils.mkdir_p(@glade["entry_pkgdir"].text)
		unless Dir[File.join(pkg_dir, "*")].empty?
			RTUtility.exec_workOS_command("cp -a " + pkg_dir + "/* " + @glade["entry_pkgdir"].text)
		end

		# リマスタOS上の/etc/yum.repos.dを作業用OSのローカルパッケージ検索dirに格納する
		RTUtility.exec_workOS_command("cp -a " + source_list + " " + @glade["entry_pkgdir"].text) if File.exist?(source_list)
	end

end
