#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#

require 'remastering/remastertool_utility'

require "gettext"
require 'pluginusbGlade'

class Usb < PluginusbGlade
  include GetText

	PROG_PATH = "pluginusb.glade"
	PROG_NAME = "remastertool_plugin_usb"

	DISPLAY_NAME	= "USB"			# display name
	VERSION			= "V1.0"		# plugin version 

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	CMD_ACTIVE = "sfdisk %s -A%s && sync"
	CMD_CHANGE_ID = "sfdisk -c %s %s 6 && sync"
	CMD_MKDOSFS = "mkdosfs -F 16 %s && sync"
	CMD_MKMBR = "ms-sys -f -s %s && sync"
	CMD_SYSLINUX = "syslinux %s && sync"
	CMD_MOUNT = "mkdir -p %s && mount -t vfat %s %s && mount | grep %s | cut -f3 -d' '"

	CMD_COPY = "cp -r %s %s"
 	CMD_EDIT_SYSLINUXCFG = "(cd %s; sed -e s/isolinux/syslinux/ isolinux.cfg > syslinux.cfg )"
	CMD_UMOUNT = "umount %s"

	MSG_INF_MKISO = _("Now creating media image.\nPlease wait for a while.")
	MSG_WARN_DEV_EMPTY = _("Please sepcify the USB device.")
	MSG_ERR_ACTIVE = _("Failed to activete partition(%d).")
	MSG_ERR_CHANGEID = _("Failed to change partition id to FAT16(%d).")
	MSG_ERR_MKDOSFS = _("Failed to create file system(%d).")
	MSG_ERR_MKMBR = _("Failed to install MBR(%d).")
	MSG_ERR_SYSLINUX = _("Failed to install syslinux(%d).")
	MSG_ERR_COPY = _("Failed to copy file(%d).")
	MSG_ERR_MOUNT = _("Failed to mount device(%d).")
	MSG_ERR_EDIT_SYSLINUXCFG = _("Failed to change syslinux.cfg(%d).")
	MSG_QUE_MKISO = _("All content of the specified USB device is deleted.\nIs making the distribution executed?")
	TITLE_DIALOG_OUTPUT_ISO = _("Choose a USB device file")

	# XMLプラグイン向けの XML要素
	XML_ROOT = ["PluginInfo", _("Plugin_information")]
	XML_ROOT_ATTR = ["name", _("name")]
	XML_DEVICE = ["device", _("device")]

	#=== プラグインのコンストラクタ
	#
	#プラグインの初期化処理を実施する。
	#
	#dir:: プラグイン格納ディレクトリ
	#復帰値:: なし
	#
	def initialize(dir)
		super(File.join(dir, PROG_PATH), nil, PROG_NAME)	
		@display_name = DISPLAY_NAME
		@version = VERSION
		@have_about = true			# about dialog is having
		@have_option = false		# Option dialog is not having
		@copyright = SSL_COPYRIGHT
		@license = SSL_LICENSE

		@tool_min_vl = "V1.0"
		@boot_loader = "isolinux"	# boot loaderは初版ではisolinux固定
		@device = ""
		@can_accel = false

		init_environ				# initialize environment
	end

	#=== リマスタリングツールとプラグインの整合性チェック
	#
	#本プラグインがリマスタリングツールのバージョン下で動作可能かチェックする。
	#
	#tool_version:: リマスタリングツールのバージョン
	#復帰値:: BOOL true=動作可能、false=動作不可能
	#
	def start_plugin(tool_version)
		return tool_version >= @tool_min_vl
	end

	#=== メディアの作成
	#
	#パラメタで取得したメディアディレクトリの内容をISOイメージ化する。
	#
	#media_dir:: OSメディア内容格納ディレクトリ
	#復帰値:: BOOL : true=成功、false=失敗
	#
	def create_media_image(media_dir)
		mnt_point = ""
		begin
			# 作成に時間がかかるのでwaitウインドウを表示する。
			RTUtility.show_wait_window(RTUtility.mainWindow, MSG_INF_MKISO)
		
			# USBデバイスのアクティブパーティションを変更
			root = @glade["entry_device"].text.strip
			id = root.sub(/(.+[A-Za-z])/, "")
			mbr = $~[1]
			status = RTUtility.exec_workOS_command(sprintf(CMD_ACTIVE, mbr, id))
			raise sprintf(MSG_ERR_ACTIVE, status) unless status == 0
	
			# パーティションIDをFAT16に変更
			status = RTUtility.exec_workOS_command(sprintf(CMD_CHANGE_ID, mbr, id))
			raise sprintf(MSG_ERR_CHANGEID, status) unless status == 0
		
			# USBデバイス上にFAT16パーティションを作成
			status = RTUtility.exec_workOS_command(sprintf(CMD_MKDOSFS, root))
			raise sprintf(MSG_ERR_MKDOSFS, status) unless status == 0

			# USBデバイスにMBRをインストール
			status = RTUtility.exec_workOS_command(sprintf(CMD_MKMBR, mbr))
			raise sprintf(MSG_ERR_MKMBR, status) unless status == 0

			# syslinuxをインストール
			status = RTUtility.exec_workOS_command(sprintf(CMD_SYSLINUX, root))
			raise sprintf(MSG_ERR_SYSLINUX, status) unless status == 0

			# USBデバイスをマウント
			mnt_point = root.sub(/^\/[A-Za-z]+\//, "/mnt/")
			outAry = Array.new
			status = RTUtility.exec_workOS_command(sprintf(CMD_MOUNT, mnt_point, root, mnt_point, root), outAry)
			raise sprintf(MSG_ERR_MOUNT, status) unless status == 0
			mnt_point = outAry[0]

			# ファイルのコピー
			status = RTUtility.exec_workOS_command(sprintf(CMD_COPY,
				File.join(media_dir, "/*"), mnt_point))
			raise sprintf(MSG_ERR_COPY, status) unless status == 0

			copy_path = RTUtility.get_os_plugin.get_boot_image("syslinux")
			if copy_path.class == "String"
				copy_path_work = [copy_path]
				copy_path = copy_path_work
			end
			copy_path.each{|value|
				status = RTUtility.exec_workOS_command(sprintf(CMD_COPY,
					File.join(media_dir, value), mnt_point))
				raise sprintf(MSG_ERR_COPY, status) unless status == 0
			}

			# syslinux.cfgの修正
			status = RTUtility.exec_workOS_command(sprintf(CMD_EDIT_SYSLINUXCFG, mnt_point))
			raise sprintf(MSG_ERR_EDIT_SYSLINUXCFG, status) unless status == 0

			true
	
		rescue
			RTUtility.end_wait_window
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
											Gtk::MessageDialog::ERROR,
											Gtk::MessageDialog::BUTTONS_OK,
											$!.to_s)
			dlg.run
			dlg.destroy
			false
		ensure
			RTUtility.exec_workOS_command(sprintf(CMD_UMOUNT, mnt_point)) unless mnt_point.empty?
			RTUtility.end_wait_window
		end
	end

	#=== ディストリビューション作成画面に表示するプラグイン固有域のWidge取得
	#
	#ディストリビューション作成画面に表示するプラグイン固有域のWidgを返却する。
	#
	#復帰値:: ディストリビューション作成画面に表示するプラグイン固有域のWidge
	#
	def get_makeDist_widget
		@glade["vbox_dist"]
	end

	#=== リマスタリング手順の変更確認
	#
	#リマスタリング手順に変更があったかを返却する。
	#新規にリマスタリングを開始した場合、起動時からの変更の有無を返却する。
	#リマスタリング手順ファイルを読み込み、続きから作業用を開始した場合は手順
	#読み込み後かの変更の有無を返却する。
	#
	#復帰値:: BOOL true=変更あり、false=変更なし。
	#
	def isModified?
		return @device != @glade["entry_device"].text.strip
	end

	#=== リマスタリング手順の変更確定
	#
	#リマスタリング手順に変更を確定する。
	#本メソッドはリマスタリング手順保存成功時に呼び出される。
	#各プラグインは現在の設定状態はリマスタリング手順変更なしの状態に設定する。
	#次回 isModified? メソッドが呼び出された場合、本メソッドの呼出時からの変更
	#を返却する。
	#
	#復帰値:: なし。
	#
	def fix_procedure
		@device = @glade["entry_device"].text.strip
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@device = ""
		@glade["entry_device"].text = ""
	end

	#===ディストリビューション作成前のチェック
	#
	#ディストリビューション作成前に設定内容に誤りがないか確認を行う。
	#パッケージ追加/削除画面ではチェック項目がないので常にtrueで復帰する。
	#
	#復帰値:: BOOL true=問題なし、false=問題あり
	#
	def check_for_make_distribution
		begin
			raise MSG_WARN_DEV_EMPTY if @glade["entry_device"].text.strip.empty?
		rescue
			dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
										 Gtk::MessageDialog::WARNING,
										 Gtk::MessageDialog::BUTTONS_OK, $!.to_s)
			dlg.run
			dlg.destroy
			return false
		end

		dlg = Gtk::MessageDialog.new(RTUtility.mainWindow, Gtk::Dialog::MODAL,
										 Gtk::MessageDialog::QUESTION,
										 Gtk::MessageDialog::BUTTONS_YES_NO, MSG_QUE_MKISO)
		response = dlg.run
		dlg.destroy
		return false unless response == Gtk::Dialog::RESPONSE_YES

		true
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素を取り出し、対応するエントリに設定する。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
		# XMLドキュメントから USBデバイスのディレクトリを取得してインスタンス変数に設定する。
		rootElm = nil
		root.get_elements(XML_ROOT[0]).each { |elm|
			if elm.attributes[XML_ROOT_ATTR[0]] == @display_name
				rootElm = elm
				break
			end
		}
		return unless rootElm 

		elm = rootElm.get_elements(XML_DEVICE[0])[0]
		@glade["entry_device"].text = (elm && elm.text) ? elm.text : ""

		# 現在の状態を「手順変更なし」に設定する
		fix_procedure
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(CDプラグイン)
	#
	def make_xml(localize = 0)
		elmRoot = REXML::Element.new(XML_ROOT[localize])
		elmRoot.add_attribute(XML_ROOT_ATTR[localize], @display_name)

		elm_child = REXML::Element.new(XML_DEVICE[localize], elmRoot)
		elm_child.text = @glade["entry_device"].text

		elmRoot
	end

	#=== 出力先イメージファイル名の取得
	#
	#リマスタリングした結果を出力する先のファイル名を返却する。
	#
	#復帰値:: 出力先イメージファイル名
	#
	def get_output_image
		@glade["entry_device"].text
	end

private

	#=== [開く]ボタンクリック時のイベントハンドラ
	#
	#[開く]ボタンクリック時にリ呼び出され、Ruby/GTK2標準のファイル選択ダイアログを
	#SAVEモードで表示し、出力先となるISOイメージファイル名を指定する。
	#
	#widget:: [開く]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_output_clicked(widget)
		dialog = Gtk::FileChooserDialog.new(TITLE_DIALOG_OUTPUT_ISO,
							RTUtility.mainWindow,
							Gtk::FileChooser::ACTION_OPEN,
							nil,
							[Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
							[Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_OK])
		dialog.current_folder = "/dev"
		@glade["entry_device"].text = dialog.filename if dialog.run == Gtk::Dialog::RESPONSE_OK
		dialog.destroy
	end
end
