#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#
require 'remastering/glade/remastertool_procedureGlade'
require 'remastering/remastertool_module'

class RemastertoolProcedure < RemastertoolProcedureGlade
  include GetText
  include Remastertool_FuncModule

  attr :glade

	PROG_PATH = "remastertool_procedure.glade"

	bindtextdomain(PROG_NAME, nil, nil, "UTF-8")

	# 手順リストのヘッダ
	HEADER_PROCEDURE_LIST1 = _("Executed")
	HEADER_PROCEDURE_LIST2 = [_("Function"), _("Operation contents"), _("Object")]
	LIST_COL_EXECUTED = 0
	LIST_COL_FUNCTION = 1
	LIST_COL_OPERATION = 2
	LIST_COL_OBJECT = 3


	#=== コンストラクタ
	#
	#画面オブジェクトの作成&初期状態への設定を行う。
	#
	#gladeDir:: gladeファイル格納ディレクトリ
	#domain:: メッセージファイルのドメイン名
	#復帰値:: なし
	#
	def initialize(gladeDir, domain)
		super(File.join(gladeDir, PROG_PATH), nil, domain, nil, GladeXML::FILE)
	
		# display accel Information
		make_procudure_list

		@pane_objs = nil
		@list_list = Hash.new
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@modified = false
	end

	#=== ペインオブジェクトの設定
	#
	#全機能のペインのオブジェクトをメンバ変数に設定する。
	#
	#objs:: ペインオブジェクト(配列)
	#復帰値:: なし
	#
	def set_pane_objs(objs)
		@pane_objs = objs
		@plugins = RTUtility.get_plugins
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#手順編集ペインでは実行済/未実行を編集する手順はないので、常に nil(リストなし)
	#を返却する。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#
	def get_procedure_list
		nil
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から画面に表示する要素に設定する。
	#手順編集ペインでは保存してある手順はないので、処理はなし。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#手順編集ペインでは保存しておく手順はないので、常に nil(XML手順なし)を返却する。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(初期設定部)
	#
	def make_xml(localize = 0)
		nil
	end


private

	#=== 手順リストの作成
	#
	#操作手順リストを作成する。
	#
	#復帰値:: なし
	#
	def make_procudure_list
		@chkbox = Gtk::CellRendererToggle.new

		# checkbox クリック時のハンドラを登録
		@chkbox.signal_connect("toggled"){ |widget, path_str|
			path = Gtk::TreePath.new(path_str)
			iter = @glade["treeview_procedure_list"].model.get_iter(path)
			iter[LIST_COL_EXECUTED] = ! iter[LIST_COL_EXECUTED]
		}
 		column = Gtk::TreeViewColumn.new(HEADER_PROCEDURE_LIST1, @chkbox, :active => 0)
		column.resizable = true
		@glade["treeview_procedure_list"].append_column(column)

		HEADER_PROCEDURE_LIST2.each_with_index { |name, i|
			column = Gtk::TreeViewColumn.new(name, Gtk::CellRendererText.new, :text => i + 1)
			column.resizable = true
			@glade["treeview_procedure_list"].append_column(column)
		}

		model = Gtk::ListStore.new(TrueClass, String, String, String)
		@glade["treeview_procedure_list"].set_model(model)
	end

	#=== 操作手順変更画面表示時のイベントハンドラ
	#
	#操作手順変更画面表示時に各機能のペインから操作手順の一覧を取得する
	#
	#widget:: 操作手順変更画面(Box)のWidget
	#復帰値:: なし
	#
	def on_mainBox_map(widget)
		make_precedure_rows
	end

	#=== 操作手順変更画面非表示時のイベントハンドラ
	#
	#操作手順変更画面非表示時に各機能のペインから取得した操作手順の一覧を削除する
	#
	#widget:: 操作手順変更画面(Box)のWidget
	#復帰値:: なし
	#
	def on_mainBox_unmap(widget)
		@list_list.clear
	end

	#=== 手順リストの作成
	#
	#各機能のペインから操作手順の一覧を取得し、手順の一覧リストを作成する。
	#
	#復帰値:: なし
	#
	def make_precedure_rows
		@list_list.clear
		@glade["treeview_procedure_list"].model.clear
		@pane_objs.each{ | pane |
			list = pane.get_procedure_list
			if list && list.size > 0
				add_procedure_list(list)
				@list_list[list[0][LIST_COL_FUNCTION]] = pane
			end
		}
		@plugins.each_value {|hash|
			hash.each { |key, val|
				list = val.get_procedure_list
				if list && list.size > 0
					add_procedure_list(list)
					@list_list[list[0][LIST_COL_FUNCTION]] = val
				end
			}
		}
	end

	#===手順リスト一覧をリストに設定する
	#
	#引数のリストを手順一覧リストに設定する。
	#
	#list:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#復帰値:: なし
	#
	def add_procedure_list(list)
		list.each { |ary|
			iter = @glade["treeview_procedure_list"].model.append
			iter[LIST_COL_EXECUTED] = ary[LIST_COL_EXECUTED]
			iter[LIST_COL_FUNCTION] = ary[LIST_COL_FUNCTION]
			iter[LIST_COL_OPERATION] = ary[LIST_COL_OPERATION]
			iter[LIST_COL_OBJECT] = ary[LIST_COL_OBJECT]
		}
	end

	#=== [適用]ボタンクリック時のイベントハンドラ
	#
	#手順一覧リストから機能毎の手順一覧リストを作成し、各機能に渡して手順実行の有無を反映する。
	#
	#widget:: [適用]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_apply_clicked(widget)
		hash = Hash.new
		iter = @glade["treeview_procedure_list"].model.iter_first
		if iter
			begin
				hash[iter[LIST_COL_FUNCTION]] = Array.new unless hash[iter[LIST_COL_FUNCTION]]
				hash[iter[LIST_COL_FUNCTION]].push([iter[0], iter[1], iter[2], iter[3]])
			end while iter.next!
		end
		hash.each {|key, value| @list_list[key].set_procedure_list(value) }
		@modified = true
	end

	#=== [キャンセル]ボタンクリック時のイベントハンドラ
	#
	#手順一覧リスト作成メソッドを呼び出し、変更を破棄する。
	#
	#widget:: [キャンセル]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_cancel_clicked(widget)
		make_precedure_rows
	end

	#=== [すべて実行済]/[すべて未実行]ボタンクリック時のイベントハンドラ
	#
	#一覧リスト中のすべてのチェックボックスを次の状態に設定する。
	#[すべて実行済]クリック時 = チェック状態
	#[すべて未実行]クリック時 = 未チェック状
	#
	#widget:: [すべて実行済]/[すべて未実行]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_check_clicked(widget)
		check = (widget == @glade["button_check"])
		iter = @glade["treeview_procedure_list"].model.iter_first
		if iter
			begin
				iter[0] = check
			end while iter.next!
		end
	end

end
