#!/usr/bin/env ruby
#
# This file is gererated by ruby-glade-create-template 1.1.3.
#
require 'remastering/glade/remastertool_testGlade'
require 'remastering/remastertool_utility'
require 'remastering/remastertool_module'

class RemastertoolTest < RemastertoolTestGlade
  include GetText
  include Remastertool_FuncModule

  attr :glade

	PROG_PATH = "remastertool_test.glade"

	#=== コンストラクタ
	#
	#画面オブジェクトの作成&初期状態への設定を行う。
	#
	#gladeDir:: gladeファイル格納ディレクトリ
	#domain:: メッセージファイルのドメイン名
	#復帰値:: なし
	#
	def initialize(gladeDir, domain)
		super(File.join(gladeDir, PROG_PATH), nil, domain, nil, GladeXML::FILE)

		# テストプラグイン毎のタブページ(notebook)を作成する
		create_notebook

		# 環境の初期化
		init_environ
	end

	#===リマスタリング環境の初期化
	#
	#リマスタリング環境を初期状態に設定する。
	#
	#復帰値:: なし
	#
	def init_environ
		@modified = false
	end

	#===リマスタリング手順のロード
	#
	#XML形式のリマスタリング手順から自ペインに対する情報を抽出する。
	#テスト設定/実行ペインではテストプラグインがデータを保持しているため本メソッド
	#では処理は行わない。
	#
	#root:: リマスタリング手順 XMLドキュメント
	#復帰値:: なし
	#
	def load_xml(root)
	end

	#===リマスタリング手順のXML化
	#
	#リマスタリング手順をXML形式の要素にして返却する。
	#テスト設定/実行ペインではテストプラグインがデータを保持しているため本メソッド
	#では処理は行わない。
	#
	#localize:: ローカライゼーション(0:非ローカライゼーション化XMLを作成, 1:ローカライゼーション化XMLを作成)
	#復帰値:: XML要素(初期設定部)
	#
	def make_xml(localize = 0)
		nil
	end

	#===手順リスト一覧の取得
	#
	#リマスタリング手順の一覧を返却する。
	#返却した手順一覧は操作手順編集画面の表示に使用される。
	#テスト設定/実行ペインではテストプラグインがデータを保持しているため本メソッド
	#では処理は行わない(常にnilを返却する)。
	#
	#復帰値:: 手順一覧リスト
	#         [ [手順1], [手順2],...]
	#          手順n = [実行済み(true) or 未実行(false) , 機能名 , 操作内容 , 対象 ]
	#        手順なし=nil
	#
	def get_procedure_list
		nil
	end

	#=== 自動テスト設定画面/自動テスト実行画面の切り替え
	#
	#パラメタの値により、自動テスト設定画面の表示(パラメタ=true)、自動テスト実行画面の
	#表示(パラメタ=false)を切り替える。
	#
	#view:: view 表示する画面
	#        true=自動テスト設定画面
	#        false=自動テスト実行画面
	#復帰値:: なし
	#
	def show_setting_pane(view)
		if view
			@glade["hbuttonbox1"].hide
			@glade["hseparator1"].hide
		else
			@glade["hbuttonbox1"].show
			@glade["hseparator1"].show
		end

		# 全テストプラグインに画面の切り替えを通知する
		RTUtility.get_test_plugins.each_value { |value| value.show_setting_view view }
	end

	#=== 最新情報への更新
	#
	#画面の表示情報を最新状態に更新する。
	#
	#復帰値:: なし
	#
	def refresh
		RTUtility.get_test_plugins.each_value { |value| value.refresh }
	end

private

	#=== 自動テスト設定画面/自動テスト実行画面の作成
	#
	#全テストプラグインのテストペインのwidgetを取得し、notebook widgetに追加する。
	#
	#復帰値:: なし
	#
	def create_notebook
		@notebook = Gtk::Notebook.new
		@glade["mainBox"].pack_start(@notebook, true, true, 10)
		RTUtility.get_test_plugins.each_value { |value|
			@notebook.append_page(value.get_test_set_widget, Gtk::Label.new(value.get_plugin_name))
		}

		# 先頭ページを表示状態にセットする
		@notebook.page = 0
		@notebook.show_all
	end


	#=== [テスト開始]ボタンクリック時のイベントハンドラ
	#
	#[テスト開始]ボタンクリック時にリ呼び出され、各テストプラグインのテスト実行メソッド
	#を呼び出す。
	#
	#widget:: [テスト開始]ボタンのWidget
	#復帰値:: なし
	#
	def on_button_test_clicked(widget)
		RTUtility.get_test_plugins.each_value{ |val| val.exec_test }
	end

end
