require 'gtk2'
require 'pathname'

require 'remastering/remastertool_utility'

class RTFileTreeView < Gtk::TreeView

	#=== ファイルシステムツリー部品のコンストラクタ
	#
	#ファイルシステムツリー部品を初期化する。
	#
	#isRemaster::ツリーを開くOS。true=理マスタリング対象OS, false=作業葉OS
	#復帰値:: なし
	#
	def initialize(isRemaster = false)
		@remaster_fs = isRemaster

		# パスのプレフィックスの設定
		unless isRemaster
			@insert_path = ""
		else
			@insert_path = RTUtility.get_os_plugin.get_root_dir
		end

		treestore = Gtk::TreeStore.new(String)
		super(treestore)
		renderer = Gtk::CellRendererText.new
		column = Gtk::TreeViewColumn.new("name", renderer, :text => 0)
		append_column(column)
		set_headers_visible(false)

		# 先頭ノード( / ディレクトリ)と直下のチャイルドの作成
		topIter = treestore.append(nil)
		topIter[0] = File::SEPARATOR
		expand_all

		create_child_node(topIter)

		# refister signal action for exoanding tree node
		signal_connect("row-expanded"){ |view, iter, path|
			on_tree_expand(view, iter, path)
		}
		# refister signal action for exoanding tree node
		signal_connect("key-press-event"){ |widget, key_event|
			if widget.selection.selected
				case key_event.keyval
				when Gdk::Keyval::GDK_KP_Enter, Gdk::Keyval::GDK_Return
					if widget.selection.selected.has_child?
						unless widget.row_expanded?(widget.selection.selected.path)
							expand_row(widget.selection.selected.path, false)
						end
					end
				when Gdk::Keyval::GDK_Right
					if widget.selection.selected.has_child?
						unless widget.row_expanded?(widget.selection.selected.path)
							expand_row(widget.selection.selected.path, false)
						else
							widget.set_cursor(selection.selected.first_child.path, nil, false)
						end
					end
				when Gdk::Keyval::GDK_Left
					if widget.selection.selected.has_child? && widget.row_expanded?(widget.selection.selected.path)
						collapse_row(widget.selection.selected.path)
					else
						widget.set_cursor(selection.selected.parent.path, nil, false) if selection.selected.parent
					end
				end
			end
		}
		font_style = Gtk::Style.new
		font_style.font_desc = Pango::FontDescription.new("Sans 12")
		style = font_style
		expand_row(topIter.path, false)
		show
	end

	#=== 最新情報への更新
	#
	#画面の表示情報を最新ん状態に更新する。
	#
	#復帰値:: なし
	#
	def refresh
		selected_path = get_selected_file

		# オープン(展開)しているディレクトリの一覧を取得する
		path_ary = Array.new
		model.each {|model, path, iter|
			path_ary.push(get_file_path(iter)) if row_expanded?(path)
		}
		model.clear

		# / は手で作成する
		iter_hash = Hash.new
		topIter = model.append(nil)
		topIter[0] = File::SEPARATOR
		iter_hash[File::SEPARATOR] = topIter
		model.append(topIter)					# dummy node
		expand_row(topIter.path, false) if path_ary.shift

		path_ary.each{|dir|
			parent_iter = iter_hash[File.dirname(dir)]
			if parent_iter
				iter = parent_iter.first_child
				# expandするディレクトリを検索する
				while iter
					if iter[0] == File.basename(dir)
						# ディレクトリが見つかったらexpand
						expand_row(iter.path, false)
						iter_hash[dir] = iter
						break
					end
					iter = nil unless iter.next!
				end
			end
		}
		# 選択時状態を復元する
		if selected_path
			if iter_hash[selected_path]
				# 展開したディレクトリを選択中
				selection.select_iter(iter_hash[selected_path])
			elsif iter_hash[File.dirname(selected_path)]
				# 展開したディレクトリ内のアイテムを選択中
				iter = iter_hash[File.dirname(selected_path)].first_child
				# expandするディレクトリを検索する
				while iter
					if iter[0] == File.basename(selected_path)
						# 選択アイテムが見つかったらselect
						selection.select_iter(iter)
						break
					end
					iter = nil unless iter.next!
				end
			end
		end
	end

	#=== ツリーの子ノードの作成
	#
	#展開したツリーのディレクトリ配下のファイル／ディレクトリを展開したツリーパスの
	#子ノードとしてツリー上に追加する。
	#
	#parent::子ノードを追加するノードが示すディレクトリ
	#復帰値:: なし
	#
	def create_child_node(parent)
		path = File.join(@insert_path, get_file_path(parent))
		Dir.foreach(path){ |name|
			next if name == "." || name == ".."
			child = model.append(parent)
			child[0] = name

			absPath = File.join(path, name)
			case File.ftype(absPath)
			when "directory"
				model.append(child)					# dummy node
			when "link"
				begin
					model.append(child) if File.stat(absPath).directory?
				rescue
				end
			end
		}
		model.set_sort_column_id(0)	# =リストの先頭カラムでソート
	end

	#=== ツリーの展開
	#
	#ツリーのノード展開時のイベントハンドラ
	#子ノードが作成されていなければ子ノードを作成する。
	#
	#view::モデル
	#iter::展開したノードのイテレータ
	#path::展開したノードのパス
	#復帰値:: なし
	#
	def on_tree_expand(view, iter, path)
		if iter.first_child.get_value(0) == nil
			create_child_node(iter)
			view.model.remove(iter.first_child)
		end
	end

	#=== 選択中のツリーのパス取得
	#
	#ツリーで選択状態になっているノードのファイルパスを絶対パス形式で返却する．
	#
	#ite::絶対パスを取得するノードのイテレータ
	#復帰値:: 選択ファイルの絶対パス
	#
	def get_file_path(ite)
		path = ite.get_value(0)
		while ite = ite.parent
			path.insert(0, (ite.get_value(0) + File::SEPARATOR)) 
		end
		Pathname.new(path).cleanpath.to_s
	end

	#=== 選択中のファイルのパス取得
	#
	#ツリーで選択状態になっているノードのファイルパスを絶対パス形式で返却する．
	#なお、コンストラクタでリマスタリング対象OSのツリー表示を指定している場合は
	#リマスタリング対象OSのルートパスをパスの先頭に挿入して返却する。
	#
	#復帰値:: 選択ファイルの絶対パス
	#
	def get_selected_file()
		return nil unless selection.selected
		path = File.join(@insert_path, get_file_path(selection.selected))
		if @remaster_fs
			path = path.sub(/^#{RTUtility.get_os_plugin.get_root_dir}/, "")
		end
		path
	end
end
