

#include "CanFrame.h"


/******************************************************************************/
/* Can Frame Format                                                           */
/******************************************************************************/
/*******************************************************************************
 *
 */
void CanFrameFormat::CanFrameFormatSub( int _no, QString _name, int _bitOffset, int _bitLen, QString _denomination )
{
	no           = _no;
	name         = _name;
	bitOffset    = _bitOffset;
	bitLen       = _bitLen;
	denomination = _denomination;

}

/*******************************************************************************
 *
 */
CanFrameFormat::CanFrameFormat( int _no, QString _name, int _bitOffset, int _bitLen, QString _denomination,
                                float _amplification, float _offset )
{

	CanFrameFormatSub( _no, _name, _bitOffset, _bitLen, _denomination );

	type = CAN_FORMAT_TYPE_FLOAT;

	format.f.offset = _offset;
	format.f.amplification = _amplification;
}

/*******************************************************************************
 *
 */
//CanFrameFormat::CanFrameFormat( int _no, QString _name, int _bitOffset, int _bitLen, QString _denomination,
//                                long long _amplification, long long _offset )
CanFrameFormat::CanFrameFormat( int _no, QString _name, int _bitOffset, int _bitLen, QString _denomination,
                                float _amplification, long long _offset )
{

	CanFrameFormatSub( _no, _name, _bitOffset, _bitLen, _denomination );

	type = CAN_FORMAT_TYPE_INT;

	format.i.offset = _offset;
	format.i.amplification = _amplification;
}

/*******************************************************************************
 *
 */
//CanFrameFormat::CanFrameFormat( int _no, QString _name, int _bitOffset, int _bitLen, QString _denomination,
//                               unsigned long long _amplification, unsigned long long _offset )
CanFrameFormat::CanFrameFormat( int _no, QString _name, int _bitOffset, int _bitLen, QString _denomination,
                               float _amplification, unsigned long long _offset )
{
	CanFrameFormatSub( _no, _name, _bitOffset, _bitLen, _denomination );

	type = CAN_FORMAT_TYPE_UINT;

	format.u.offset = _offset;
	format.u.amplification = _amplification;
}

/*******************************************************************************
 *
 */
CanFrameFormat::~CanFrameFormat()
{
}

/*******************************************************************************
 *
 */

/******************************************************************************/
/* Can Frame Function                                                         */
/******************************************************************************/
/*******************************************************************************
 *
 */
CanFrameFunction::CanFrameFunction( int functionCode, QString functionName )
{
	m_code = functionCode;
	m_name = functionName;
}

/*******************************************************************************
 *
 */
CanFrameFunction::~CanFrameFunction()
{
	int no;

	for( no=0; no<formatVec.count(); ++no ) {
		delete formatVec[no];
	}
}

/*******************************************************************************
 *
 */
int CanFrameFunction::formatAdd( CanFrameFormat * pFormat )
{
	formatVec.append( pFormat );

	return 0;
}

/*******************************************************************************
 *
 */
int CanFrameFunction::formatNum( void )
{
	return formatVec.count();
}

/*******************************************************************************
 *
 */
void CanFrameFunction::formatName( int no, QString & name )
{
//	formatVec[no]->name( name );
	name = formatVec[no]->name;
}


/*******************************************************************************
 *
 */
void CanFrameFunction::formatDeleteIndex( int index )
{
//	delete formatVec[index];
	formatVec.remove(index);
}


/*******************************************************************************
 *
 */
void CanFrameFunction::formatDeleteItem( int no )
{
	int i;

	for( i=0; i<formatVec.count(); i=i+1 ) {
		if( formatVec[i]->no == no ) {
			formatVec.remove(i);
		}
	}
}


/*******************************************************************************
 *
 */
CanFrameFormat * CanFrameFunction::formatGet( int no )
{
	CanFrameFormat * pFormat = NULL;
	int i;

//	if( no < formatVec.count() ) {
//		pFormat = formatVec[no];
//	}
	for( i=0; (i<formatVec.count()) && (pFormat==NULL); ++i ) {
		if( formatVec[i]->no == no ) {
			pFormat = formatVec[i];
		}
	}

	return pFormat;
}
/*******************************************************************************
 *
 */
int CanFrameFunction::formatNo( int index )
{
	return formatVec[index]->no;
}

/*******************************************************************************
 *
 */
int CanFrameFunction::code( void )
{
	return m_code;
}

/******************************************************************************/
/* Can Frame Node                                                             */
/******************************************************************************/
/*******************************************************************************
 *
 */
CanFrameNode::CanFrameNode( int nodeID, QString nodeName )
{
	id = nodeID;
	name = nodeName;
}

/*******************************************************************************
 *
 */
CanFrameNode::~CanFrameNode()
{
	int no;

	for( no=0; no<functionVec.count(); ++no ) {
		delete functionVec[no];
	}
}

/*******************************************************************************
 *
 */
CanFrameFunction * CanFrameNode::functionAdd( int functionCode, QString name )
{
	CanFrameFunction * pFunction;

	try {
		pFunction = new CanFrameFunction( functionCode, name );
	} catch( std::bad_alloc ) {
		pFunction = NULL;
	}

	if( pFunction ) {
		functionVec.append( pFunction );
	}

	return pFunction;
}

/*******************************************************************************
 *
 */
CanFrameFunction * CanFrameNode::functionSearch( int functionCode )
{
	CanFrameFunction * pFunction = NULL;
	int no;

	for( no=0; (no<functionVec.count()) && (pFunction==NULL); ++no ) {
		if( functionVec[no]->code() == functionCode ) {
			pFunction = functionVec[no];
		}
	}

	return pFunction;
}

/*******************************************************************************
 *
 */
int CanFrameNode::functionNum( void )
{
	return functionVec.count();
}

/*******************************************************************************
 *
 */
int CanFrameNode::functionCode( int index )
{
	return functionVec[index]->code();
}

/*******************************************************************************
 *
 */
void CanFrameNode::functionName( int index, QString & name )
{
//	functionVec[index]->name( name );
	name = functionVec[index]->m_name;
}

/*******************************************************************************
 *
 */
void CanFrameNode::functionDelete( int index )
{
//	delete functionVec[index];
	functionVec.remove(index);
}

/*******************************************************************************
 *
 */
void CanFrameNode::functionDeleteFunc( int code )
{
	int i;

	for( i=0; i<functionVec.count(); i=i+1 ) {
		if( functionVec[i]->code() == code ) {
			functionVec.remove(i);
		}
	}
}

/*******************************************************************************
 *
 */

/******************************************************************************/
/* Can Frame                                                                  */
/******************************************************************************/

/*******************************************************************************
 *
 */
CanFrame::CanFrame()
{
	test_data_set();
}

/*******************************************************************************
 *
 */
CanFrame::~CanFrame()
{
	int no;

	for( no=0; no<nodeVec.count(); ++no ) {
		delete nodeVec[no];
	}
}

/*******************************************************************************
 *
 */
CanFrameNode * CanFrame::nodeAdd( int nodeID, QString name )
{
	CanFrameNode * pNode = NULL;

	pNode = nodeSearch( nodeID );

	if( pNode == NULL ) {
		try {
			pNode = new CanFrameNode( nodeID, name );
		} catch (std::bad_alloc) {
			pNode = NULL;
		}

		if( pNode ) {
			nodeVec.append( pNode );
		}
	}

	return pNode;
}

/*******************************************************************************
 *
 */
CanFrameNode * CanFrame::nodeSearch( int nodeID )
{
	CanFrameNode * pNode;
	int no;

	pNode = NULL;

	for( no=0; (no<nodeVec.count()) && (pNode==NULL); ++no ) {
		if( nodeVec[no]->id == nodeID ) {
			pNode = nodeVec[no];
		}
	}

	return pNode;
}

/*******************************************************************************
 *
 */
CanFrameFunction * CanFrame::functionSearch( int nodeID, int functionCode )
{
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;

	pFunction = NULL;

	pNode = nodeSearch( nodeID );
	if( pNode ) {
		pFunction = pNode->functionSearch( functionCode );
	}

	return pFunction;
}

/*******************************************************************************
 *
 */
int CanFrame::nodeNum( void )
{
	return nodeVec.count();
}

/*******************************************************************************
 *
 */
int CanFrame::nodeID( int index )
{
	return nodeVec[index]->id;
}

/*******************************************************************************
 *
 */
void CanFrame::nodeName( int index, QString & name )
{
//	nodeVec[index]->name( name );
	name = nodeVec[index]->name;
}
/*******************************************************************************
 *
 */
void CanFrame::nodeDelete( int index )
{
//	delete nodeVec[index];
	nodeVec.remove(index);
}
/*******************************************************************************
 *
 */
void CanFrame::nodeDeleteId( int id )
{
	int i;

	for( i=0; i<nodeVec.count(); i=i+1 ) {
		if( nodeVec[i]->id == id ) {
			nodeVec.remove(i);
		}
	}
}


/*******************************************************************************
 *
 */
void CanFrame::test_data_set( void )
{
/*
	//
	// debug code
	//  {́ACanFramẽRXgN^Ńt@Cǂݍ܂BBB
	//
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat   * pFormat;

	nodeAdd( 1, "node 1" );
	nodeAdd( 2, "node 2" );

	pNode = nodeSearch( 1 );
		pNode->functionAdd( 1, "func 1" );
		pNode->functionAdd( 2, "func 2" );

		pFunction = pNode->functionSearch( 1 );

			pFormat = new CanFrameFormat( "fA", 0, 16, "A", (float)1.0 );
			pFunction->formatAdd( pFormat );

			pFormat = new CanFrameFormat( "fV", 16, 16, "V", (float)1.0 );
			pFunction->formatAdd( pFormat );

		pFunction = pNode->functionSearch( 2 );

			pFunction->formatAdd( new CanFrameFormat( "x",  0,32, "xx", (long long)1 ) );

	pNode = nodeSearch( 2 );
		pNode->functionAdd( 1, "Func 1" );
		pNode->functionAdd( 2, "Func 2" );

		pFunction = pNode->functionSearch( 1 );
			pFunction->formatAdd( new CanFrameFormat( "FV",  0, 16, "v", (float)1.0 ) );
			pFunction->formatAdd( new CanFrameFormat( "FA", 16, 16, "a", (float)1.0 ) );

		pFunction = pNode->functionSearch( 2 );
			pFunction->formatAdd( new CanFrameFormat( "X",  0, 32, "XX", (long long)1 ) );


	pFunction = functionSearch( 1, 1 );
	pFunction->code();

	pFunction = functionSearch( 1, 2 );
	pFunction->code();

	pFunction = functionSearch( 2, 1 );
	pFunction->code();

	pFunction = functionSearch( 2, 2 );
	pFunction->code();
*/

}

