#pragma once

#include <string>
#include <QVector>
#include <QString>

typedef enum {
	CAN_FORMAT_TYPE_ERROR,

	CAN_FORMAT_TYPE_FLOAT,		/* float											*/
	CAN_FORMAT_TYPE_INT,		/* int (64bit max)									*/
	CAN_FORMAT_TYPE_UINT,		/* unsigned int (64bit max)							*/
} CanFrameFormatType;

/*** ***/
class CanFrameFormat
{
public:
//	CanFormat( );
	/* !! ATTATION !! _bitLen is 64 max */
//	CanFrameFormat( int no, QString name, int bitOffset, int bitLen, QString denomination,              float amplification,              float offset=0.0 );
//	CanFrameFormat( int no, QString name, int bitOffset, int bitLen, QString denomination,          long long amplification,          long long offset=0 );
//	CanFrameFormat( int no, QString name, int bitOffset, int bitLen, QString denomination, unsigned long long amplification, unsigned long long offset=0 );
	CanFrameFormat( int no, QString name, int bitOffset, int bitLen, QString denomination, float amplification,              float offset=0.0 );
	CanFrameFormat( int no, QString name, int bitOffset, int bitLen, QString denomination, float amplification,          long long offset=0 );
	CanFrameFormat( int no, QString name, int bitOffset, int bitLen, QString denomination, float amplification, unsigned long long offset=0 );

	~CanFrameFormat( );
private:
	void CanFrameFormatSub( int no, QString _name, int _bitOffset, int _bitLen, QString denomination );

public:

	CanFrameFormatType typeGet( void );

	int nameGet( QString & value );
#if 0
	int floatGet( const CanData & canData, int & value );
	int intGet(   const CanData & canData, long long & value );
	int uintGet(  const CanData & canData, unsigned long long & value );
#endif
	int denominationGet( QString & value );

	CanFrameFormatType	type;		/* CAN_FORMAT_TYPE_*** */
	int			no;
	QString		name;
	int			bitOffset;
	int			bitLen;
	QString		denomination;

//	union {
//		struct {
//			float		offset;
//			float		amplification;
//		} f;
//
//		struct {
//			long long	offset;
//			long long	amplification;
//		} i;
//
//		struct {
//			long long	offset;
//			long long	amplification;
//		} u;
//
//	} format;
	union {
		struct {
			float		offset;
			float		amplification;
		} f;

		struct {
			long long	offset;
			float		amplification;
		} i;

		struct {
			long long	offset;
			float		amplification;
		} u;

	} format;

private:
//	CanFrameFormatType	type;		/* CAN_FORMAT_TYPE_*** */
//	std::string		name;
//	int			bitOffset;
//	int			bitLen;
//	std::string		denomination;

//	union {
//		struct {
//			float		offset;
//			float		amplification;
//		} f;
//
//		struct {
//			long long	offset;
//			long long	amplification;
//		} i;
//
//		struct {
//			long long	offset;
//			long long	amplification;
//		} u;
//
//	} format;


};

/*** ***/
class CanFrameFunction
{
public:
	CanFrameFunction(int functionCode, QString functionName );
	~CanFrameFunction();

	int formatAdd( CanFrameFormat * pFormat );
	int formatNum( void );
	CanFrameFormat * formatGet( int no );
	void formatName( int no, QString & );
	int formatNo( int index );
	void formatDeleteIndex( int index );
	void formatDeleteItem( int no );

	int code( void );

	QString		m_name;

private:
	int				m_code;
//	QString		m_name;

	QVector<CanFrameFormat *>	formatVec;

};

/*** ***/
class CanFrameNode
{
public:
	CanFrameNode( int nodeID, QString nodeName );
	~CanFrameNode();

	int		id;
	QString	name;

	CanFrameFunction * functionAdd( int functionCode, QString functionName );
	CanFrameFunction * functionSearch( int functionCode );
	int functionNum( void );
	int functionCode( int index );
	void functionName( int index, QString & );
	void functionDelete( int index );
	void functionDeleteFunc( int code );

private:

	QVector<CanFrameFunction *>	functionVec;
};

/*** ***/
class CanFrame
{
public:
	CanFrame();
	~CanFrame();

	CanFrameNode * nodeAdd( int nodeID, QString name );
	CanFrameNode * nodeSearch( int nodeID );
	CanFrameFunction * functionSearch( int nodeID, int functionCode );
	int nodeNum( void );
	int nodeID( int index );
	void nodeName( int index, QString & );
	void nodeDelete( int index );
	void nodeDeleteId( int id );

//	int add( int nodeID, int functionCode, CanFrameFormat * pFormat );

private:
	QVector<CanFrameNode *>	nodeVec;

	void test_data_set( void );
};

