#ifndef FCAN_VIEW_H
#define FCAN_VIEW_H

#include <QtGui/QMainWindow>
#include "ui_fcan_view.h"

class QAction;
class QMenu;
class QWorkspace;

#include "initfile.h"
#include "hardware.h"
#include "rxdata.h"
#include "txdata.h"
#include "rxdataformat.h"
#include "rxdatafilter.h"
#include "graph.h"
#include "plotter.h"
#include "information.h"

class FCAN_View : public QMainWindow
{
	Q_OBJECT

public:
	FCAN_View(QWidget *parent = 0, Qt::WFlags flags = 0);
	~FCAN_View();

	void FcanViewSet( FCAN_View * fcanview );
	void SysConfigSet( SysConfig * sysconfig );
	void InitFileSet( InitFile * initfile );
	void HardwareSet( Hardware * hardware );
	void RxDataSet( RxData * rxdata );
	void TxDataSet( TxData * txdata );
	void RxDataFormatSet( RxDataFormat * rxdataformat );
	void RxDataFilterSet( RxDataFilter * rxdatafilter );
	void GraphSet( Graph * graph );
	void PlotterSet( Plotter * plotter );
	void PlotSettingsSet( PlotSettings * plotsettings );
	void InformationSet( Information * information );
	void CanDataSet( CanData * candata );
	void CanDataMngSet( CanDataMng * candatamng );
	void CanFrameSet( CanFrame * canframe );
	void Start( );
	void HardwareSetting(QString qstr);
	void statusBar_message(QString qstr);
	void statusBar_clear( );

//	void childWindowClose( IfView * pView );

//protected:
//	void closeEvent(QCloseEvent *event);

	bool ViewWindow[10];
	bool ViewGraph[10];
	int ViewGraphCount;
	int GraphNumber;
	int StdCobIDBitOffset;
	int StdCobIDBitLength;
	int StdCobIDMask;
	int StdNodeIDBitOffset;
	int StdNodeIDBitLength;
	int StdNodeIDMask;
	int ExtCobIDBitOffset;
	int ExtCobIDBitLength;
	int ExtCobIDMask;
	int ExtNodeIDBitOffset;
	int ExtNodeIDBitLength;
	int ExtNodeIDMask;
	void HardwareView(int mode);
	void RxDataFilterView(int mode);
	void RxDataFormatView(int mode);
	void RxDataView(int mode);
	void TxDataView(int mode);
	void GraphView(int mode);
	void GraphViewShow(int no);
	void GraphViewClose(int no);
	QString GraphInit(int no, int mode, QString line);
	void PlotterView(int mode);


private slots:
	void menu_triggered();
	void menu_initfile();
	void menu_hardware();
	void menu_rxdata();
	void menu_txdata();
	void menu_rxdataformat();
	void menu_rxdatafilter();
	void menu_newgraph();
	void menu_graph0();
	void menu_graph1();
	void menu_graph2();
	void menu_graph3();
	void menu_graph4();
	void menu_graph5();
	void menu_graph6();
	void menu_graph7();
	void menu_graph8();
	void menu_graph9();
	void menu_information();
	void menu_close();
	// Close
	void closeEvent( QCloseEvent * event );

private:
	Ui::FCAN_ViewClass ui;

	FCAN_View * pFcanView;
	SysConfig * pSysConfig;
	InitFile * pInitFile;
	Hardware * pHardware;
	RxData * pRxData;
	TxData * pTxData;
	RxDataFormat * pRxDataFormat;
	RxDataFilter * pRxDataFilter;
	Graph * pGraph[10];
	Plotter * pPlotter[10];
	PlotSettings * pPlotSettings[10];
	Information * pInformation;
	CanData * pCanData;
	CanDataMng * pCanDataMng;
	CanFrame * pCanFrame;

	void createMenus();
	void createMenuActions();
	void ViewAdd();

	QLabel *statusBarLabel;
	QWorkspace *workspace;
	QWidgetList windows;
	QString HardwareInfo;

	struct {
		QMenu * pMenu;
		QAction * pFileAction;
		QAction * pHardwareAction;
		QAction * pRxDataAction;
		QAction * pTxDataAction;
		QAction * pRxDataFormatAction;
		QAction * pRxDataFilterAction;
		QAction * pNewGraphAction;
		QAction * pGraphAction;
		QAction * pInformation;
		QAction * pExitAction;
	} SettingMenu;

};

#endif // FCAN_VIEW_H

