#include <QtGui>
#include <qtimer.h>
#include "graph.h"
#include "rxdata.h"
#include "rxdataformat.h"
#include "information.h"
#include "SysConfig.h"
#include "CanData.h"
#include "plotter.h"
#include "CanFrame.h"
#include "fcan_view.h"

Graph::Graph(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
	hide();

	setWindowTitle("Setting(Graph)");

	pSysConfig = NULL;
	pRxDataFormat = NULL;
	pPlotter = NULL;
	pPlotSettings = NULL;
	pCanData = NULL;
	pCanDataMng = NULL;
	pCanFrame = NULL;
	pInformation = NULL;
	pFcanView = NULL;
	for(int j = 0; j < 5; j=j+1 ){ 
		pGraphItem[j] = NULL;
	}

	//	QTimer Create
	GraphTimer = new QTimer(this);
    connect( GraphTimer,SIGNAL(timeout()),this,SLOT(timGraph()));
	// btnGraphDraw
	connect( ui.btnGraphDraw,SIGNAL(clicked()),this,SLOT(btnGraphDraw_Click()));
	// btnGraphClose
	connect( ui.btnGraphClose,SIGNAL(clicked()),this,SLOT(btnGraphClose_Click()));
	// btnGraphStartStop
	connect( ui.btnGraphStartStop,SIGNAL(clicked()),this,SLOT(btnGraphStartStop_Click()));
	// btnGraphFileFind
	connect( ui.btnGraphFileFind,SIGNAL(clicked()),this,SLOT(btnGraphFileFind_Click()));
	// btnGraphFileLoad
	connect( ui.btnGraphFileLoad,SIGNAL(clicked()),this,SLOT(btnGraphFileLoad_Click()));
	// rdbGraphRecive
	connect( ui.rdbGraphRecive,SIGNAL(toggled(bool)),this,SLOT(rdbGraphRecive_Toggled()));
	// chbGraph1
	connect( ui.chbGraph1,SIGNAL(toggled(bool)),this,SLOT(chbGraph1_Toggled()));
	// chbGraph2
	connect( ui.chbGraph2,SIGNAL(toggled(bool)),this,SLOT(chbGraph2_Toggled()));
	// chbGraph3
	connect( ui.chbGraph3,SIGNAL(toggled(bool)),this,SLOT(chbGraph3_Toggled()));
	// chbGraph4
	connect( ui.chbGraph4,SIGNAL(toggled(bool)),this,SLOT(chbGraph4_Toggled()));
	// chbGraph5
	connect( ui.chbGraph5,SIGNAL(toggled(bool)),this,SLOT(chbGraph5_Toggled()));
	// chbYaxis2
	connect( ui.chbYaxis2,SIGNAL(toggled(bool)),this,SLOT(chbYaxis2_Toggled()));
	// chbYaxis3
	connect( ui.chbYaxis3,SIGNAL(toggled(bool)),this,SLOT(chbYaxis3_Toggled()));
	// chbYaxis4
	connect( ui.chbYaxis4,SIGNAL(toggled(bool)),this,SLOT(chbYaxis4_Toggled()));
	// chbYaxis5
	connect( ui.chbYaxis5,SIGNAL(toggled(bool)),this,SLOT(chbYaxis5_Toggled()));
	// cbbGraphId1
	connect( ui.cbbGraphId1,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphId1_Changed( const QString & )));
	// cbbGraphId2
	connect( ui.cbbGraphId2,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphId2_Changed( const QString & )));
	// cbbGraphId3
	connect( ui.cbbGraphId3,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphId3_Changed( const QString & )));
	// cbbGraphId4
	connect( ui.cbbGraphId4,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphId4_Changed( const QString & )));
	// cbbGraphId5
	connect( ui.cbbGraphId5,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphId5_Changed( const QString & )));
	// cbbGraphFunc1
	connect( ui.cbbGraphFunc1,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphFunc1_Changed( const QString & )));
	// cbbGraphFunc2
	connect( ui.cbbGraphFunc2,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphFunc2_Changed( const QString & )));
	// cbbGraphFunc3
	connect( ui.cbbGraphFunc3,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphFunc3_Changed( const QString & )));
	// cbbGraphFunc4
	connect( ui.cbbGraphFunc4,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphFunc4_Changed( const QString & )));
	// cbbGraphFunc5
	connect( ui.cbbGraphFunc5,SIGNAL(activated( const QString & )),this,SLOT(cbbGraphFunc5_Changed( const QString & )));

	ui.btnGraphDraw->setEnabled(false);
	ui.btnGraphClose->setEnabled(true);
	ui.btnGraphStartStop->setText("Start");
	ui.btnGraphStartStop->setEnabled(true);

	ui.rdbGraphRecive->setEnabled(true);
	ui.rdbGraphFile->setEnabled(true);
	ui.txtGraphFileName->setEnabled(false);
	ui.btnGraphFileFind->setEnabled(false);
	ui.btnGraphFileLoad->setEnabled(false);

	ui.chbGraph1->setEnabled(true);
	ui.cbbGraphId1->setEnabled(false);
	ui.cbbGraphFunc1->setEnabled(false);
	ui.cbbGraphItem1->setEnabled(false);
	ui.txtXaxisMax->setEnabled(true);
	ui.txtYaxisMin1->setEnabled(true);
	ui.txtYaxisMax1->setEnabled(true);

	ui.chbGraph2->setEnabled(true);
	ui.cbbGraphId2->setEnabled(false);
	ui.cbbGraphFunc2->setEnabled(false);
	ui.cbbGraphItem2->setEnabled(false);
	ui.txtYaxisMin2->setEnabled(false);
	ui.txtYaxisMax2->setEnabled(false);

	ui.chbGraph3->setEnabled(true);
	ui.cbbGraphId3->setEnabled(false);
	ui.cbbGraphFunc3->setEnabled(false);
	ui.cbbGraphItem3->setEnabled(false);
	ui.txtYaxisMin3->setEnabled(false);
	ui.txtYaxisMax3->setEnabled(false);

	ui.chbGraph4->setEnabled(true);
	ui.cbbGraphId4->setEnabled(false);
	ui.cbbGraphFunc4->setEnabled(false);
	ui.cbbGraphItem4->setEnabled(false);
	ui.txtYaxisMin4->setEnabled(false);
	ui.txtYaxisMax4->setEnabled(false);

	ui.chbGraph5->setEnabled(true);
	ui.cbbGraphId5->setEnabled(false);
	ui.cbbGraphFunc5->setEnabled(false);
	ui.cbbGraphItem5->setEnabled(false);
	ui.txtYaxisMin5->setEnabled(false);
	ui.txtYaxisMax5->setEnabled(false);

	// Graph Flag Init
	int i;
	for(i=0; i<5; ++i){
		GraphWindow[i] = false;
		GraphYaxisSelect[i] = 1;
	}

	MessageCount = 0;
	MessageTimeGen = 0;
	TimeGetFlag = 0;
	GraphRighViewCount = 0;
	GraphNumber = 0;
	GraphWindowOpen = 0;
	GraphReciveMode = 1;
	LoardFileError = 0;
	GraphName = ui.txtGraphName->text();

	// Menu Init
	createMenus();

}

Graph::~Graph()
{

}

////////////////////////////////////////
// Pointer Setting
////////////////////////////////////////
void Graph::SysConfigSet( SysConfig * sysconfig )
{
	pSysConfig = sysconfig;
}
void Graph::RxDataFormatSet( RxDataFormat * rxdataformat )
{
	pRxDataFormat = rxdataformat;
}
void Graph::CanFrameSet( CanFrame * canframe )
{
	pCanFrame = canframe;
}
void Graph::CanDataSet( CanData * candata )
{
	pCanData = candata;
}
void Graph::CanDataMngSet( CanDataMng * candatamng )
{
	pCanDataMng = candatamng;
}
void Graph::PlotterSet( Plotter * plotter )
{
	pPlotter = plotter;
}
void Graph::PlotSettingsSet( PlotSettings * plotsettings )
{
	pPlotSettings = plotsettings;
}
void Graph::InformationSet( Information * information )
{
	pInformation = information;
}
void Graph::FcanViewSet( FCAN_View * fcanview )
{
	pFcanView = fcanview;
}
////////////////////////////////////////
// Graph Function
////////////////////////////////////////
// Close
void Graph::closeEvent(QCloseEvent * pEvent)
{

	if( GraphWindowOpen == 1 ){
		int qt_ret = QMessageBox::warning(this, tr("Graph Setting"),
										tr("Release Graph when Close a Window.\n"
										   "Are you all right ?"),
										QMessageBox::Yes | QMessageBox::Default,
										QMessageBox::No );

		if( qt_ret == QMessageBox::Yes ){
			pFcanView->GraphViewClose(GraphNumber);
			GraphWindowOpen = 0;
			pPlotter->close();
			pEvent->accept();
		} else {
			pEvent->ignore();
		}
	} else {
		pFcanView->GraphViewClose(GraphNumber);
		GraphWindowOpen = 0;
		pEvent->accept();
	}

}
// GraphNumberSet
void Graph::GraphNumberSet(int no)
{
	GraphNumber = no;
}
// btnGraphDraw
void Graph::btnGraphDraw_Click()
{
	int index;
	int GraphId;
	int GraphFunc;
	int GraphItem;
	int GraphViewCount;
	int bitOffset;
	int bitLen;
	int DataLoop;
	int MessageCountMax;
	int DataCount;
	int qt_ret;
	unsigned long long XMaxTime;
	unsigned long long GetData;
	unsigned long long GetDataRead;
	unsigned long long GetTime;
	unsigned long long DataMask;
	unsigned long long DataFlag;
    double XData;
    double YData;
    QVector<QPointF> CurveData[6];
	CanData CanDataVec;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;
	CanFrameFormatType	data_type;
	union IntAndFloat target;
	union LongIntAndFloat long_target;
	QMessageBox msgBox;
	QString qt_str;

	ui.btnGraphDraw->setEnabled(false);

	MessageCount = 0;
	MessageTimeGen = 0;
	TimeGetFlag = 0;
	GraphRighViewCount = 0;

	// Clear Pointer
	for ( int lp = 0; lp < 5; lp=lp+1 ){
		pGraphItem[lp] = NULL;
	}

	// PlotterSetting
	PlotterSetting( );

	// Clear Curve
	for ( int lp = 0; lp < 5; lp=lp+1 ){
		pPlotter->clearCurve(lp);
	}

	// Data Graph View
	if( ui.rdbGraphFile->isChecked() ){
		ui.chbGraph1->setEnabled(false);
		ui.cbbGraphId1->setEnabled(false);
		ui.cbbGraphFunc1->setEnabled(false);
		ui.cbbGraphItem1->setEnabled(false);
		ui.txtXaxisMax->setEnabled(false);
		ui.txtYaxisMin1->setEnabled(false);
		ui.txtYaxisMax1->setEnabled(false);

		ui.chbGraph2->setEnabled(false);
		ui.cbbGraphId2->setEnabled(false);
		ui.cbbGraphFunc2->setEnabled(false);
		ui.cbbGraphItem2->setEnabled(false);
		ui.txtYaxisMin2->setEnabled(false);
		ui.txtYaxisMax2->setEnabled(false);

		ui.chbGraph3->setEnabled(false);
		ui.cbbGraphId3->setEnabled(false);
		ui.cbbGraphFunc3->setEnabled(false);
		ui.cbbGraphItem3->setEnabled(false);
		ui.txtYaxisMin3->setEnabled(false);
		ui.txtYaxisMax3->setEnabled(false);

		ui.chbGraph4->setEnabled(false);
		ui.cbbGraphId4->setEnabled(false);
		ui.cbbGraphFunc4->setEnabled(false);
		ui.cbbGraphItem4->setEnabled(false);
		ui.txtYaxisMin4->setEnabled(false);
		ui.txtYaxisMax4->setEnabled(false);

		ui.chbGraph5->setEnabled(false);
		ui.cbbGraphId5->setEnabled(false);
		ui.cbbGraphFunc5->setEnabled(false);
		ui.cbbGraphItem5->setEnabled(false);
		ui.txtYaxisMin5->setEnabled(false);
		ui.txtYaxisMax5->setEnabled(false);

		MessageCount = 0;
		MessageCountMax = pCanDataMng->num( );

		if( MessageCountMax == 0 ){
			msgBox.setText("Error : Buffer is No Data");
			qt_ret = msgBox.exec();
		} else {
			if(pCanDataMng->get(MessageCountMax-1,CanDataVec)){
				pInformation->Information_set("");
				pInformation->Information_append("Unable to Get Buffer!!");
			}
			XMaxTime = (unsigned long long)CanDataVec.mtime;
			if( XMaxTime < (10 * 1000)){
				XMaxTime = 10;
			} else {
				XMaxTime = (XMaxTime + 5000) / (10 * 1000);
				XMaxTime = XMaxTime * 10;
			}
			pPlotSettings->maxX = (double)XMaxTime;
			pPlotter->PlotterStart();

			if( MessageCount < MessageCountMax ){
				for( GraphViewCount = 0; GraphViewCount < 5; GraphViewCount=GraphViewCount+1 ){
					if( GraphWindow[GraphViewCount] ){

						// Get Setting
						index = GetId(GraphViewCount);
						GraphId = pCanFrame->nodeID(index);
						pNode = pCanFrame->nodeSearch(GraphId);
						index = GetFunc(GraphViewCount);
						GraphFunc = pNode->functionCode(index);
						pFunction = pNode->functionSearch(GraphFunc);
						index = GetItem(GraphViewCount);
						GraphItem = pFunction->formatNo(index);
						// Get Format Pattern
						pFunction = pCanFrame->functionSearch(GraphId,GraphFunc);
						if( pFunction == NULL ){
							pInformation->Information_set("");
							pInformation->Information_append("ID or Function Search Not Find Error");
							bitOffset = 0;
							bitLen = 8;
							data_type = CAN_FORMAT_TYPE_ERROR;
						} else {
							pFormat = pFunction->formatGet(GraphItem);
							if( pFormat == NULL ){
								pInformation->Information_set("");
								pInformation->Information_append("Format Search Not Find Error");
								bitOffset = 0;
								bitLen = 8;
								data_type = CAN_FORMAT_TYPE_ERROR;
							} else {
								bitOffset = pFormat->bitOffset;
								bitLen = pFormat->bitLen;
								data_type = pFormat->type;
								pGraphItem[GraphViewCount] = pFormat;
							}
						}
						for( DataLoop = MessageCount; DataLoop <= MessageCountMax; DataLoop=DataLoop+1 ){
							// Get Data
							if(pCanDataMng->get(MessageCount,CanDataVec)){
								break;
							}
							if( CanDataVec.id == GraphId && CanDataVec.func == GraphFunc ){
								// Get Item
								GetDataRead = 0;
								GetData = 0;
								for(DataCount=0;DataCount<8;DataCount=DataCount+1){
									GetData = GetData << 8;
									GetDataRead = (unsigned long long)CanDataVec.data[7-DataCount];
									GetData = GetData + GetDataRead;
								}
								GetData = GetData >> bitOffset;
								DataMask = 0xFFFFFFFFFFFFFFFF;
								DataMask = DataMask << bitLen;
								DataFlag = DataMask;
								DataMask = ~DataMask;
								GetData = GetData & DataMask;

								if( bitLen == 32 ){
									target.ival = (int)GetData;
									if( data_type == CAN_FORMAT_TYPE_FLOAT ){
										YData = (double)target.fval;
										YData *= (double)pFormat->format.f.amplification;
										YData += (double)pFormat->format.f.offset;
									} else if( data_type == CAN_FORMAT_TYPE_INT ){
										YData = (double)target.ival;
										YData *= (double)pFormat->format.i.amplification;
										YData += (double)pFormat->format.i.offset;
									} else {
										YData = (double)target.uival;
										YData *= (double)pFormat->format.u.amplification;
										YData += (double)pFormat->format.u.offset;
									}
								} else if( bitLen == 64 ){
									long_target.ival = (long long)GetData;
									if( data_type == CAN_FORMAT_TYPE_FLOAT ){
										YData = (double)long_target.fval;
										YData *= (double)pFormat->format.f.amplification;
										YData += (double)pFormat->format.f.offset;
									} else if( data_type == CAN_FORMAT_TYPE_INT ){
										YData = (double)long_target.ival;
										YData *= (double)pFormat->format.i.amplification;
										YData += (double)pFormat->format.i.offset;
									} else {
										YData = (double)long_target.uival;
										YData *= (double)pFormat->format.u.amplification;
										YData += (double)pFormat->format.u.offset;
									}
								} else {
									if((((GetData >> ( bitLen - 1)) & 0x1 ) == 0x1 )
										&& ( data_type == CAN_FORMAT_TYPE_INT )){
										long_target.ival = (long long)GetData + (long long)DataFlag;
									} else {
										long_target.ival = (long long)GetData;
									}
									if( data_type == CAN_FORMAT_TYPE_INT ){
										YData = (double)long_target.ival;
										YData *= (double)pFormat->format.i.amplification;
										YData += (double)pFormat->format.i.offset;
									} else {
										YData = (double)long_target.uival;
										YData *= (double)pFormat->format.u.amplification;
										YData += (double)pFormat->format.u.offset;
									}
								}
								// Get Time
								GetTime = (unsigned long long)CanDataVec.mtime;
								GetTime = GetTime * 1000;
								GetTime = GetTime + (unsigned long long)CanDataVec.utime;
								if( TimeGetFlag == 0 ){
									MessageTimeGen = GetTime;
									TimeGetFlag = 1;
								}
								GetTime = GetTime - MessageTimeGen;
								XData = (double)GetTime / 1000000;

								// Write Data
								CurveData[GraphViewCount].append(QPointF(XData, YData));
							}
							MessageCount = MessageCount + 1;
						}
						MessageCount = 0;
						// View Curve
						pPlotter->setCurveData(GraphViewCount, CurveData[GraphViewCount]);
					}
				}
			}
		}
		MessageCount = 0;
		MessageTimeGen = 0;
		TimeGetFlag = 0;

		pInformation->Information_set("");
		pInformation->Information_append("Graph Create successfully");

		ui.btnGraphDraw->setEnabled(true);
		ui.chbGraph1->setEnabled(true);
//		ui.txtXaxisMax->setEnabled(true);
		ui.txtYaxisMin1->setEnabled(true);
		ui.txtYaxisMax1->setEnabled(true);
		if( ui.chbGraph1->isChecked() ){
			GraphWindow[0] = true;
			ui.cbbGraphId1->setEnabled(true);
			ui.cbbGraphFunc1->setEnabled(true);
			ui.cbbGraphItem1->setEnabled(true);
		} else {
			GraphWindow[0] = false;
			ui.cbbGraphId1->setEnabled(false);
			ui.cbbGraphFunc1->setEnabled(false);
			ui.cbbGraphItem1->setEnabled(false);
		}

		ui.chbGraph2->setEnabled(true);
		if( !ui.chbYaxis2->isChecked() ){
			ui.txtYaxisMin2->setEnabled(true);
			ui.txtYaxisMax2->setEnabled(true);
		} else {
			ui.txtYaxisMin2->setEnabled(false);
			ui.txtYaxisMax2->setEnabled(false);
		}
		if( ui.chbGraph2->isChecked() ){
			GraphWindow[1] = true;
			ui.cbbGraphId2->setEnabled(true);
			ui.cbbGraphFunc2->setEnabled(true);
			ui.cbbGraphItem2->setEnabled(true);
		} else {
			GraphWindow[1] = false;
			ui.cbbGraphId2->setEnabled(false);
			ui.cbbGraphFunc2->setEnabled(false);
			ui.cbbGraphItem2->setEnabled(false);
		}

		ui.chbGraph3->setEnabled(true);
		if( !ui.chbYaxis3->isChecked() ){
			ui.txtYaxisMin3->setEnabled(true);
			ui.txtYaxisMax3->setEnabled(true);
		} else {
			ui.txtYaxisMin3->setEnabled(false);
			ui.txtYaxisMax3->setEnabled(false);
		}
		if( ui.chbGraph3->isChecked() ){
			GraphWindow[2] = true;
			ui.cbbGraphId3->setEnabled(true);
			ui.cbbGraphFunc3->setEnabled(true);
			ui.cbbGraphItem3->setEnabled(true);
		} else {
			GraphWindow[2] = false;
			ui.cbbGraphId3->setEnabled(false);
			ui.cbbGraphFunc3->setEnabled(false);
			ui.cbbGraphItem3->setEnabled(false);
		}

		ui.chbGraph4->setEnabled(true);
		if( !ui.chbYaxis4->isChecked() ){
			ui.txtYaxisMin4->setEnabled(true);
			ui.txtYaxisMax4->setEnabled(true);
		} else {
			ui.txtYaxisMin4->setEnabled(false);
			ui.txtYaxisMax4->setEnabled(false);
		}
		if( ui.chbGraph4->isChecked() ){
			GraphWindow[3] = true;
			ui.cbbGraphId4->setEnabled(true);
			ui.cbbGraphFunc4->setEnabled(true);
			ui.cbbGraphItem4->setEnabled(true);
		} else {
			GraphWindow[3] = false;
			ui.cbbGraphId4->setEnabled(false);
			ui.cbbGraphFunc4->setEnabled(false);
			ui.cbbGraphItem4->setEnabled(false);
		}

		ui.chbGraph5->setEnabled(true);
		if( !ui.chbYaxis5->isChecked() ){
			ui.txtYaxisMin5->setEnabled(true);
			ui.txtYaxisMax5->setEnabled(true);
		} else {
			ui.txtYaxisMin5->setEnabled(false);
			ui.txtYaxisMax5->setEnabled(false);
		}
		if( ui.chbGraph5->isChecked() ){
			GraphWindow[4] = true;
			ui.cbbGraphId5->setEnabled(true);
			ui.cbbGraphFunc5->setEnabled(true);
			ui.cbbGraphItem5->setEnabled(true);
		} else {
			GraphWindow[4] = false;
			ui.cbbGraphId5->setEnabled(false);
			ui.cbbGraphFunc5->setEnabled(false);
			ui.cbbGraphItem5->setEnabled(false);
		}
	} else {
		// Buffer Clear
		pCanDataMng->clear( );
	}

}
// PlotterSetting
void Graph::PlotterSetting( )
{
	QString qt_str;

	// PlotSettings
	pPlotSettings->minX = 0.0;
	qt_str = ui.txtXaxisMax->text();
	pPlotSettings->maxX = qt_str.toDouble();
	pPlotSettings->numXTicks = 10;

	qt_str = ui.txtYaxisMin1->text();
	pPlotSettings->minY[1] = qt_str.toDouble();
	qt_str = ui.txtYaxisMax1->text();
	pPlotSettings->maxY[1] = qt_str.toDouble();

	if( ui.chbYaxis2->isChecked() ){
		qt_str = ui.txtYaxisMin1->text();
		pPlotSettings->minY[2] = qt_str.toDouble();
		qt_str = ui.txtYaxisMax1->text();
		pPlotSettings->maxY[2] = qt_str.toDouble();
	} else {
		qt_str = ui.txtYaxisMin2->text();
		pPlotSettings->minY[2] = qt_str.toDouble();
		qt_str = ui.txtYaxisMax2->text();
		pPlotSettings->maxY[2] = qt_str.toDouble();
	}
	if( ui.chbYaxis3->isChecked() ){
		qt_str = ui.txtYaxisMin1->text();
		pPlotSettings->minY[3] = qt_str.toDouble();
		qt_str = ui.txtYaxisMax1->text();
		pPlotSettings->maxY[3] = qt_str.toDouble();
	} else {
		qt_str = ui.txtYaxisMin3->text();
		pPlotSettings->minY[3] = qt_str.toDouble();
		qt_str = ui.txtYaxisMax3->text();
		pPlotSettings->maxY[3] = qt_str.toDouble();
	}
	if( ui.chbYaxis4->isChecked() ){
		qt_str = ui.txtYaxisMin1->text();
		pPlotSettings->minY[4] = qt_str.toDouble();
		qt_str = ui.txtYaxisMax1->text();
		pPlotSettings->maxY[4] = qt_str.toDouble();
	} else {
		qt_str = ui.txtYaxisMin4->text();
		pPlotSettings->minY[4] = qt_str.toDouble();
		qt_str = ui.txtYaxisMax4->text();
		pPlotSettings->maxY[4] = qt_str.toDouble();
	}
	if( ui.chbYaxis5->isChecked() ){
		qt_str = ui.txtYaxisMin1->text();
		pPlotSettings->minY[5] = qt_str.toDouble();
		qt_str = ui.txtYaxisMax1->text();
		pPlotSettings->maxY[5] = qt_str.toDouble();
	} else {
		qt_str = ui.txtYaxisMin5->text();
		pPlotSettings->minY[5] = qt_str.toDouble();
		qt_str = ui.txtYaxisMax5->text();
		pPlotSettings->maxY[5] = qt_str.toDouble();
	}

	pPlotSettings->numYTicks = 10;
	pPlotSettings->zoomSize = 1.0;
	// ReView
	pPlotter->PlotterStart();

}
// Select ID
int Graph::GetId(int Select)
{
	int GraphID;

	if( Select == 1 ){
		GraphID = ui.cbbGraphId2->currentIndex();
	} else if( Select == 2 ){
		GraphID = ui.cbbGraphId3->currentIndex();
	} else if( Select == 3 ){
		GraphID = ui.cbbGraphId4->currentIndex();
	} else if( Select == 4 ){
		GraphID = ui.cbbGraphId5->currentIndex();
	} else {
		GraphID = ui.cbbGraphId1->currentIndex();
	}

	return GraphID;

}
// Select FUNC
int Graph::GetFunc(int Select)
{
	int GraphFunc;

	if( Select == 1 ){
		GraphFunc = ui.cbbGraphFunc2->currentIndex();
	} else if( Select == 2 ){
		GraphFunc = ui.cbbGraphFunc3->currentIndex();
	} else if( Select == 3 ){
		GraphFunc = ui.cbbGraphFunc4->currentIndex();
	} else if( Select == 4 ){
		GraphFunc = ui.cbbGraphFunc5->currentIndex();
	} else {
		GraphFunc = ui.cbbGraphFunc1->currentIndex();
	}

	return GraphFunc;

}
// Select Items
int Graph::GetItem(int Select)
{
	int GraphItem;

	if( Select == 1 ){
		GraphItem = ui.cbbGraphItem2->currentIndex();
	} else if( Select == 2 ){
		GraphItem = ui.cbbGraphItem3->currentIndex();
	} else if( Select == 3 ){
		GraphItem = ui.cbbGraphItem4->currentIndex();
	} else if( Select == 4 ){
		GraphItem = ui.cbbGraphItem5->currentIndex();
	} else {
		GraphItem = ui.cbbGraphItem1->currentIndex();
	}
	return GraphItem;

}
// btnGraphClose
void Graph::btnGraphClose_Click()
{
	QString qt_str;

	GraphName = ui.txtGraphName->text();
	qt_str = "Setting(" + GraphName + ")";
	setWindowTitle(qt_str);
	pPlotter->GraphNameSet();
	GraphWindowOpen = 0;
	hide();
}
// btnGraphStartStop
void Graph::btnGraphStartStop_Click()
{
	GraphStartStop();
}
// GraphStartStop
void Graph::GraphStartStop()
{
	int TimerCount;
	QString qt_str;

	if( ui.rdbGraphRecive->isChecked() ){
		qt_str = ui.btnGraphStartStop->text();
		if( qt_str == "Start" ){
			// Clear Pointer
			for ( int lp = 0; lp < 5; lp=lp+1 ){
				pGraphItem[lp] = NULL;
			}

			// PlotterSetting
			PlotterSetting( );

			// Clear Curve
			for ( int lp = 0; lp < 5; lp=lp+1 ){
				pPlotter->clearCurve(lp);
			}

			GraphRighViewCount = 0;
			TimerCount = (int)pPlotSettings->maxX * 100;
			GraphTimer->start(TimerCount);
			ui.btnGraphStartStop->setText("Stop");

			ui.chbGraph1->setEnabled(false);
			ui.cbbGraphId1->setEnabled(false);
			ui.cbbGraphFunc1->setEnabled(false);
			ui.cbbGraphItem1->setEnabled(false);
			ui.txtXaxisMax->setEnabled(false);
			ui.txtYaxisMin1->setEnabled(false);
			ui.txtYaxisMax1->setEnabled(false);

			ui.chbGraph2->setEnabled(false);
			ui.cbbGraphId2->setEnabled(false);
			ui.cbbGraphFunc2->setEnabled(false);
			ui.cbbGraphItem2->setEnabled(false);
			ui.txtYaxisMin2->setEnabled(false);
			ui.txtYaxisMax2->setEnabled(false);

			ui.chbGraph3->setEnabled(false);
			ui.cbbGraphId3->setEnabled(false);
			ui.cbbGraphFunc3->setEnabled(false);
			ui.cbbGraphItem3->setEnabled(false);
			ui.txtYaxisMin3->setEnabled(false);
			ui.txtYaxisMax3->setEnabled(false);

			ui.chbGraph4->setEnabled(false);
			ui.cbbGraphId4->setEnabled(false);
			ui.cbbGraphFunc4->setEnabled(false);
			ui.cbbGraphItem4->setEnabled(false);
			ui.txtYaxisMin4->setEnabled(false);
			ui.txtYaxisMax4->setEnabled(false);

			ui.chbGraph5->setEnabled(false);
			ui.cbbGraphId5->setEnabled(false);
			ui.cbbGraphFunc5->setEnabled(false);
			ui.cbbGraphItem5->setEnabled(false);
			ui.txtYaxisMin5->setEnabled(false);
			ui.txtYaxisMax5->setEnabled(false);

			pInformation->Information_set("");
			pInformation->Information_append("Graph Timer Start");
		} else {
			GraphTimer->stop();
			TimeGetFlag = 0;
			GraphRighViewCount = 0;
			ui.btnGraphStartStop->setText("Start");

			ui.chbGraph1->setEnabled(true);
			ui.txtXaxisMax->setEnabled(true);
			ui.txtYaxisMin1->setEnabled(true);
			ui.txtYaxisMax1->setEnabled(true);
			if( ui.chbGraph1->isChecked() ){
				GraphWindow[0] = true;
				ui.cbbGraphId1->setEnabled(true);
				ui.cbbGraphFunc1->setEnabled(true);
				ui.cbbGraphItem1->setEnabled(true);
			} else {
				GraphWindow[0] = false;
				ui.cbbGraphId1->setEnabled(false);
				ui.cbbGraphFunc1->setEnabled(false);
				ui.cbbGraphItem1->setEnabled(false);
			}

			ui.chbGraph2->setEnabled(true);
			if( ui.chbYaxis2->isChecked() ){
				ui.txtYaxisMin2->setEnabled(false);
				ui.txtYaxisMax2->setEnabled(false);
			} else {
				ui.txtYaxisMin2->setEnabled(true);
				ui.txtYaxisMax2->setEnabled(true);
			}
			if( ui.chbGraph2->isChecked() ){
				GraphWindow[1] = true;
				ui.cbbGraphId2->setEnabled(true);
				ui.cbbGraphFunc2->setEnabled(true);
				ui.cbbGraphItem2->setEnabled(true);
			} else {
				GraphWindow[1] = false;
				ui.cbbGraphId2->setEnabled(false);
				ui.cbbGraphFunc2->setEnabled(false);
				ui.cbbGraphItem2->setEnabled(false);
			}

			ui.chbGraph3->setEnabled(true);
			if( ui.chbYaxis3->isChecked() ){
				ui.txtYaxisMin3->setEnabled(false);
				ui.txtYaxisMax3->setEnabled(false);
			} else {
				ui.txtYaxisMin3->setEnabled(true);
				ui.txtYaxisMax3->setEnabled(true);
			}
			if( ui.chbGraph3->isChecked() ){
				GraphWindow[2] = true;
				ui.cbbGraphId3->setEnabled(true);
				ui.cbbGraphFunc3->setEnabled(true);
				ui.cbbGraphItem3->setEnabled(true);
			} else {
				GraphWindow[2] = false;
				ui.cbbGraphId3->setEnabled(false);
				ui.cbbGraphFunc3->setEnabled(false);
				ui.cbbGraphItem3->setEnabled(false);
			}

			ui.chbGraph4->setEnabled(true);
			if( ui.chbYaxis4->isChecked() ){
				ui.txtYaxisMin4->setEnabled(false);
				ui.txtYaxisMax4->setEnabled(false);
			} else {
				ui.txtYaxisMin4->setEnabled(true);
				ui.txtYaxisMax4->setEnabled(true);
			}
			if( ui.chbGraph4->isChecked() ){
				GraphWindow[3] = true;
				ui.cbbGraphId4->setEnabled(true);
				ui.cbbGraphFunc4->setEnabled(true);
				ui.cbbGraphItem4->setEnabled(true);
			} else {
				GraphWindow[3] = false;
				ui.cbbGraphId4->setEnabled(false);
				ui.cbbGraphFunc4->setEnabled(false);
				ui.cbbGraphItem4->setEnabled(false);
			}

			ui.chbGraph5->setEnabled(true);
			if( ui.chbYaxis5->isChecked() ){
				ui.txtYaxisMin5->setEnabled(false);
				ui.txtYaxisMax5->setEnabled(false);
			} else {
				ui.txtYaxisMin5->setEnabled(true);
				ui.txtYaxisMax5->setEnabled(true);
			}
			if( ui.chbGraph5->isChecked() ){
				GraphWindow[4] = true;
				ui.cbbGraphId5->setEnabled(true);
				ui.cbbGraphFunc5->setEnabled(true);
				ui.cbbGraphItem5->setEnabled(true);
			} else {
				GraphWindow[4] = false;
				ui.cbbGraphId5->setEnabled(false);
				ui.cbbGraphFunc5->setEnabled(false);
				ui.cbbGraphItem5->setEnabled(false);
			}

			pInformation->Information_set("");
			pInformation->Information_append("Graph Timer Stop");
		}
	}
}
// btnGraphFileFind
void Graph::btnGraphFileFind_Click()
{
	QString fileName = QFileDialog::getOpenFileName(
														this,
					   									tr("Open Data file"),	// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter
	ui.txtGraphFileName->setText(fileName);

}
// btnGraphFileLoad
void Graph::btnGraphFileLoad_Click()
{
	CanData CanDataVec;
	QString qt_str;
	QString filename;
	int GraphFileLine;
	int Length;
	int count;
	int ret;
	int error_flag;
	QMessageBox msgBox;

	error_flag = 0;

	// Buffer Clear
	pCanDataMng->clear( );

	// File Name
	filename = ui.txtGraphFileName->text();
	QFile GraphFile(filename);

	GraphFileLine = 0;
	if (GraphFile.open(QIODevice::ReadOnly)) {
		QTextStream in(&GraphFile);
		while (!in.atEnd()) {
			QString line = in.readLine();
			QStringList coords = line.split(",");
			count = coords.count();
			if( count < 6 ){
				qt_str = "Error: Graph Initialize Illegal Value!";
				ret = QMessageBox::warning(this, tr("GraphInit"),
												qt_str,
												QMessageBox::Yes | QMessageBox::Default);
				break;
			}
			QStringList RxTime = coords[1].split(".");
			count = RxTime.count();
			if( count != 2 ){
				qt_str = "Error: Graph Initialize Illegal Value!";
				ret = QMessageBox::warning(this, tr("GraphInit"),
												qt_str,
												QMessageBox::Yes | QMessageBox::Default);
				break;
			}

			// Recive CobID
			ret = ValueCheck(coords[2]);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				CanDataVec.func = (int)coords[2].toUInt(0,16);
			}
			// Recive Id
			ret = ValueCheck(coords[3]);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				CanDataVec.id = (int)coords[3].toUInt(0,16);
			}
			// Recive Length
			ret = ValueCheck(coords[4]);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				CanDataVec.len = (int)coords[4].toUInt(0,16);
				Length = CanDataVec.len;
			}
			// Recive Data
			for(int i=0; i< Length; i=i+1) {
				ret = ValueCheck(coords[5+i]);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					CanDataVec.data[i] = (unsigned char)coords[5+i].toUInt(0,16);
				}
			}
			// Recive Time
			ret = ValueCheck(RxTime[0]);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				CanDataVec.mtime = (unsigned long long)RxTime[0].toUInt(0,10);
			}
			ret = ValueCheck(RxTime[1]);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				CanDataVec.utime = (unsigned short int)RxTime[1].toUInt(0,10);
			}
			// Buffer Write
			if( error_flag == 0 ){
				pCanDataMng->set(CanDataVec);
				GraphFileLine = GraphFileLine + 1;
			} else {
				qt_str = "Error: Graph Initialize Illegal Value!";
				ret = QMessageBox::warning(this, tr("GraphInit"),
												qt_str,
												QMessageBox::Yes | QMessageBox::Default);
				break;
			}
		}
		GraphFile.close();
	}
	if( error_flag == 0 ){
		pInformation->Information_set("");
		pInformation->Information_append("Load File :" + filename + " load successfully");
	} else {
		pInformation->Information_set("");
		pInformation->Information_append("Load File :" + filename + " load Error");
	}

}
// rdbGraphRecive
void Graph::rdbGraphRecive_Toggled()
{
	if( ui.rdbGraphRecive->isChecked() ){
		if( ui.btnGraphStartStop->text() == "Start" ){
			ui.btnGraphStartStop->setEnabled(true);
			ui.btnGraphDraw->setEnabled(false);
			ui.txtGraphFileName->setEnabled(false);
			ui.btnGraphFileFind->setEnabled(false);
			ui.btnGraphFileLoad->setEnabled(false);
			ui.txtXaxisMax->setEnabled(true);
			GraphReciveMode = 1;
		}
	} else {
		if( ui.btnGraphStartStop->text() == "Stop" ){
			ui.rdbGraphRecive->setChecked(true);
			GraphReciveMode = 1;
		} else {
			ui.btnGraphStartStop->setEnabled(false);
			ui.btnGraphDraw->setEnabled(true);
			ui.txtGraphFileName->setEnabled(true);
			ui.btnGraphFileFind->setEnabled(true);
			ui.btnGraphFileLoad->setEnabled(true);
			ui.txtXaxisMax->setEnabled(false);
			GraphReciveMode = 0;
		}
	}
}
// chbGraph1
void Graph::chbGraph1_Toggled()
{
	chbGraph1_Load();
}
// chbGraph1
void Graph::chbGraph1_Load()
{
	int i;
	int num;
	int nodeid;
	int qt_ret;
	QMessageBox msgBox;
	QString * nodeStr;
	QString node_id;
	QString qt_str;

	if( ui.chbGraph1->isChecked() ){
		GraphWindow[0] = true;
		ui.cbbGraphId1->setEnabled(true);
		ui.cbbGraphFunc1->setEnabled(true);
		ui.cbbGraphItem1->setEnabled(true);
		// Clear Item
		ui.cbbGraphId1->clear();
		ui.cbbGraphFunc1->clear();
		ui.cbbGraphItem1->clear();
		// Get Vector Num
		num = pCanFrame->nodeNum( );
		if( num == 0 ){
			msgBox.setText("Error : Unable to find NodeID!");
			qt_ret = msgBox.exec();
			LoardFileError = 1;

			GraphWindow[0] = false;
			ui.chbGraph1->setChecked(false);
			ui.cbbGraphId1->setEnabled(false);
			ui.cbbGraphFunc1->setEnabled(false);
			ui.cbbGraphItem1->setEnabled(false);
			ui.cbbGraphId1->clear();
			ui.cbbGraphFunc1->clear();
			ui.cbbGraphItem1->clear();
		} else {
			// Get Id Item Name
			for( i = 0; i < num; i=i+1 ){
				nodeStr = new QString();
				nodeid = pCanFrame->nodeID( i );
				pCanFrame->nodeName( i, * nodeStr );
				qt_str.sprintf("%03X", nodeid);
				node_id = ( * nodeStr ) + "[" + qt_str + "]";
				ui.cbbGraphId1->addItem( node_id );
				ui.cbbGraphId1->adjustSize();
			}
			cbbGraphId1_Load();
			GraphReSize();
		}
	} else {
		GraphWindow[0] = false;
		ui.cbbGraphId1->setEnabled(false);
		ui.cbbGraphFunc1->setEnabled(false);
		ui.cbbGraphItem1->setEnabled(false);
		ui.cbbGraphId1->clear();
		ui.cbbGraphFunc1->clear();
		ui.cbbGraphItem1->clear();
		ui.cbbGraphId1->adjustSize();
		ui.cbbGraphFunc1->adjustSize();
		ui.cbbGraphItem1->adjustSize();
		GraphReSize();
	}
}
// chbGraph2
void Graph::chbGraph2_Toggled()
{
	chbGraph2_Load();
}
// chbGraph2
void Graph::chbGraph2_Load()
{
	int i;
	int num;
	int nodeid;
	int qt_ret;
	QMessageBox msgBox;
	QString * nodeStr;
	QString node_id;
	QString qt_str;

	if( ui.chbGraph2->isChecked() ){
		GraphWindow[1] = true;
		ui.cbbGraphId2->setEnabled(true);
		ui.cbbGraphFunc2->setEnabled(true);
		ui.cbbGraphItem2->setEnabled(true);
		// Clear Item
		ui.cbbGraphId2->clear();
		ui.cbbGraphFunc2->clear();
		ui.cbbGraphItem2->clear();
		// Get Vector Num
		num = pCanFrame->nodeNum( );
		if( num == 0 ){
			msgBox.setText("Error : Unable to find NodeID!");
			qt_ret = msgBox.exec();
			LoardFileError = 1;

			GraphWindow[1] = false;
			ui.chbGraph2->setChecked(false);
			ui.cbbGraphId2->setEnabled(false);
			ui.cbbGraphFunc2->setEnabled(false);
			ui.cbbGraphItem2->setEnabled(false);
			ui.cbbGraphId2->clear();
			ui.cbbGraphFunc2->clear();
			ui.cbbGraphItem2->clear();
		} else {
			// Get Id Item Name
			for( i = 0; i < num; i=i+1 ){
				nodeStr = new QString();
				nodeid = pCanFrame->nodeID( i );
				pCanFrame->nodeName( i, * nodeStr );
				qt_str.sprintf("%03X", nodeid);
				node_id = ( * nodeStr ) + "[" + qt_str + "]";
				ui.cbbGraphId2->addItem( node_id );
				ui.cbbGraphId2->adjustSize();
			}
			cbbGraphId2_Load();
			GraphReSize();
		}
	} else {
		GraphWindow[1] = false;
		ui.cbbGraphId2->setEnabled(false);
		ui.cbbGraphFunc2->setEnabled(false);
		ui.cbbGraphItem2->setEnabled(false);
		ui.cbbGraphId2->clear();
		ui.cbbGraphFunc2->clear();
		ui.cbbGraphItem2->clear();
		ui.cbbGraphId2->adjustSize();
		ui.cbbGraphFunc2->adjustSize();
		ui.cbbGraphItem2->adjustSize();
		GraphReSize();
	}
}
// chbGraph3
void Graph::chbGraph3_Toggled()
{
	chbGraph3_Load();
}
// chbGraph3
void Graph::chbGraph3_Load()
{
	int i;
	int num;
	int nodeid;
	int qt_ret;
	QMessageBox msgBox;
	QString * nodeStr;
	QString node_id;
	QString qt_str;

	if( ui.chbGraph3->isChecked() ){
		GraphWindow[2] = true;
		ui.cbbGraphId3->setEnabled(true);
		ui.cbbGraphFunc3->setEnabled(true);
		ui.cbbGraphItem3->setEnabled(true);
		// Clear Item
		ui.cbbGraphId3->clear();
		ui.cbbGraphFunc3->clear();
		ui.cbbGraphItem3->clear();
		// Get Vector Num
		num = pCanFrame->nodeNum( );
		if( num == 0 ){
			msgBox.setText("Error : Unable to find NodeID!");
			qt_ret = msgBox.exec();
			LoardFileError = 1;

			GraphWindow[2] = false;
			ui.chbGraph3->setChecked(false);
			ui.cbbGraphId3->setEnabled(false);
			ui.cbbGraphFunc3->setEnabled(false);
			ui.cbbGraphItem3->setEnabled(false);
			ui.cbbGraphId3->clear();
			ui.cbbGraphFunc3->clear();
			ui.cbbGraphItem3->clear();
		} else {
			// Get Id Item Name
			for( i = 0; i < num; i=i+1 ){
				nodeStr = new QString();
				nodeid = pCanFrame->nodeID( i );
				pCanFrame->nodeName( i, * nodeStr );
				qt_str.sprintf("%03X", nodeid);
				node_id = ( * nodeStr ) + "[" + qt_str + "]";
				ui.cbbGraphId3->addItem( node_id );
				ui.cbbGraphId3->adjustSize();
			}
			cbbGraphId3_Load();
			GraphReSize();
		}
	} else {
		GraphWindow[2] = false;
		ui.cbbGraphId3->setEnabled(false);
		ui.cbbGraphFunc3->setEnabled(false);
		ui.cbbGraphItem3->setEnabled(false);
		ui.cbbGraphId3->clear();
		ui.cbbGraphFunc3->clear();
		ui.cbbGraphItem3->clear();
		ui.cbbGraphId3->adjustSize();
		ui.cbbGraphFunc3->adjustSize();
		ui.cbbGraphItem3->adjustSize();
		GraphReSize();
	}
}
// chbGraph4
void Graph::chbGraph4_Toggled()
{
	chbGraph4_Load();
}
// chbGraph4
void Graph::chbGraph4_Load()
{
	int i;
	int num;
	int nodeid;
	int qt_ret;
	QMessageBox msgBox;
	QString * nodeStr;
	QString node_id;
	QString qt_str;

	if( ui.chbGraph4->isChecked() ){
		GraphWindow[3] = true;
		ui.cbbGraphId4->setEnabled(true);
		ui.cbbGraphFunc4->setEnabled(true);
		ui.cbbGraphItem4->setEnabled(true);
		// Clear Item
		ui.cbbGraphId4->clear();
		ui.cbbGraphFunc4->clear();
		ui.cbbGraphItem4->clear();
		// Get Vector Num
		num = pCanFrame->nodeNum( );
		if( num == 0 ){
			msgBox.setText("Error : Unable to find NodeID!");
			qt_ret = msgBox.exec();
			LoardFileError = 1;

			GraphWindow[3] = false;
			ui.chbGraph4->setChecked(false);
			ui.cbbGraphId4->setEnabled(false);
			ui.cbbGraphFunc4->setEnabled(false);
			ui.cbbGraphItem4->setEnabled(false);
			ui.cbbGraphId4->clear();
			ui.cbbGraphFunc4->clear();
			ui.cbbGraphItem4->clear();
		} else {
			// Get Id Item Name
			for( i = 0; i < num; i=i+1 ){
				nodeStr = new QString();
				nodeid = pCanFrame->nodeID( i );
				pCanFrame->nodeName( i, * nodeStr );
				qt_str.sprintf("%03X", nodeid);
				node_id = ( * nodeStr ) + "[" + qt_str + "]";
				ui.cbbGraphId4->addItem( node_id );
				ui.cbbGraphId4->adjustSize();
			}
			cbbGraphId4_Load();
			GraphReSize();
		}
	} else {
		GraphWindow[3] = false;
		ui.cbbGraphId4->setEnabled(false);
		ui.cbbGraphFunc4->setEnabled(false);
		ui.cbbGraphItem4->setEnabled(false);
		ui.cbbGraphId4->clear();
		ui.cbbGraphFunc4->clear();
		ui.cbbGraphItem4->clear();
		ui.cbbGraphId4->adjustSize();
		ui.cbbGraphFunc4->adjustSize();
		ui.cbbGraphItem4->adjustSize();
		GraphReSize();
	}
}
// chbGraph5
void Graph::chbGraph5_Toggled()
{
	chbGraph5_Load();
}
// chbGraph5
void Graph::chbGraph5_Load()
{
	int i;
	int num;
	int nodeid;
	int qt_ret;
	QMessageBox msgBox;
	QString * nodeStr;
	QString node_id;
	QString qt_str;

	if( ui.chbGraph5->isChecked() ){
		GraphWindow[4] = true;
		ui.cbbGraphId5->setEnabled(true);
		ui.cbbGraphFunc5->setEnabled(true);
		ui.cbbGraphItem5->setEnabled(true);
		// Clear Item
		ui.cbbGraphId5->clear();
		ui.cbbGraphFunc5->clear();
		ui.cbbGraphItem5->clear();
		// Get Vector Num
		num = pCanFrame->nodeNum( );
		if( num == 0 ){
			msgBox.setText("Error : Unable to find NodeID!");
			qt_ret = msgBox.exec();
			LoardFileError = 1;

			GraphWindow[4] = false;
			ui.chbGraph5->setChecked(false);
			ui.cbbGraphId5->setEnabled(false);
			ui.cbbGraphFunc5->setEnabled(false);
			ui.cbbGraphItem5->setEnabled(false);
			ui.cbbGraphId5->clear();
			ui.cbbGraphFunc5->clear();
			ui.cbbGraphItem5->clear();
		} else {
			// Get Id Item Name
			for( i = 0; i < num; i=i+1 ){
				nodeStr = new QString();
				nodeid = pCanFrame->nodeID( i );
				pCanFrame->nodeName( i, * nodeStr );
				qt_str.sprintf("%03X", nodeid);
				node_id = ( * nodeStr ) + "[" + qt_str + "]";
				ui.cbbGraphId5->addItem( node_id );
				ui.cbbGraphId5->adjustSize();
			}
			cbbGraphId5_Load();
			GraphReSize();
		}
	} else {
		GraphWindow[4] = false;
		ui.cbbGraphId5->setEnabled(false);
		ui.cbbGraphFunc5->setEnabled(false);
		ui.cbbGraphItem5->setEnabled(false);
		ui.cbbGraphId5->clear();
		ui.cbbGraphFunc5->clear();
		ui.cbbGraphItem5->clear();
		ui.cbbGraphId5->adjustSize();
		ui.cbbGraphFunc5->adjustSize();
		ui.cbbGraphItem5->adjustSize();
		GraphReSize();
	}
}

// chbYaxis2
void Graph::chbYaxis2_Toggled()
{
	if( ui.chbYaxis2->isChecked() ){
		ui.txtYaxisMin2->setEnabled(false);
		ui.txtYaxisMax2->setEnabled(false);
		GraphYaxisSelect[1] = 1;
	} else {
		ui.txtYaxisMin2->setEnabled(true);
		ui.txtYaxisMax2->setEnabled(true);
		GraphYaxisSelect[1] = 0;
	}

}

// chbYaxis3
void Graph::chbYaxis3_Toggled()
{
	if( ui.chbYaxis3->isChecked() ){
		ui.txtYaxisMin3->setEnabled(false);
		ui.txtYaxisMax3->setEnabled(false);
		GraphYaxisSelect[2] = 1;
	} else {
		ui.txtYaxisMin3->setEnabled(true);
		ui.txtYaxisMax3->setEnabled(true);
		GraphYaxisSelect[2] = 0;
	}

}

// chbYaxis4
void Graph::chbYaxis4_Toggled()
{
	if( ui.chbYaxis4->isChecked() ){
		ui.txtYaxisMin4->setEnabled(false);
		ui.txtYaxisMax4->setEnabled(false);
		GraphYaxisSelect[3] = 1;
	} else {
		ui.txtYaxisMin4->setEnabled(true);
		ui.txtYaxisMax4->setEnabled(true);
		GraphYaxisSelect[3] = 0;
	}

}

// chbYaxis5
void Graph::chbYaxis5_Toggled()
{
	if( ui.chbYaxis5->isChecked() ){
		ui.txtYaxisMin5->setEnabled(false);
		ui.txtYaxisMax5->setEnabled(false);
		GraphYaxisSelect[4] = 1;
	} else {
		ui.txtYaxisMin5->setEnabled(true);
		ui.txtYaxisMax5->setEnabled(true);
		GraphYaxisSelect[4] = 0;
	}

}

// GraphTimer
void Graph::timGraph()
{
	int index;
	int GraphId;
	int GraphFunc;
	int GraphItem;
	int GraphViewCount;
	int bitOffset;
	int bitLen;
	int DataLoop;
	int MessageCountMax;
	int DataCount;
	unsigned long long GetData;
	unsigned long long GetDataRead;
	unsigned long long GetTime;
	unsigned long long DataMask;
	unsigned long long DataFlag;
    double XData;
    double YData;
    QVector<QPointF> CurveData[6];
	CanData CanDataVec;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;
	CanFrameFormatType	data_type;
	union IntAndFloat target;
	union LongIntAndFloat long_target;

	MessageCountMax = pCanDataMng->num( );
	if( MessageCount < MessageCountMax ){
		for( GraphViewCount = 0; GraphViewCount < 5; GraphViewCount=GraphViewCount+1 ){
			if( GraphWindow[GraphViewCount] ){

				// Get Setting
				index = GetId(GraphViewCount);
				GraphId = pCanFrame->nodeID(index);
				pNode = pCanFrame->nodeSearch(GraphId);
				index = GetFunc(GraphViewCount);
				GraphFunc = pNode->functionCode(index);
				pFunction = pNode->functionSearch(GraphFunc);
				index = GetItem(GraphViewCount);
				GraphItem = pFunction->formatNo(index);
				// Get Format Pattern
				pFunction = pCanFrame->functionSearch(GraphId,GraphFunc);
				if( pFunction == NULL ){
					pInformation->Information_set("");
					pInformation->Information_append("ID or Function Search Not Find Error");
					bitOffset = 0;
					bitLen = 8;
					data_type = CAN_FORMAT_TYPE_ERROR;
				} else {
					pFormat = pFunction->formatGet(GraphItem);
					if( pFormat == NULL ){
						pInformation->Information_set("");
						pInformation->Information_append("Format Search Not Find Error");
						bitOffset = 0;
						bitLen = 8;
						data_type = CAN_FORMAT_TYPE_ERROR;
					} else {
						bitOffset = pFormat->bitOffset;
						bitLen = pFormat->bitLen;
						data_type = pFormat->type;
						pGraphItem[GraphViewCount] = pFormat;
					}
				}
				for( DataLoop = MessageCount; DataLoop <= MessageCountMax; DataLoop=DataLoop+1 ){
					// Get Data
					if(pCanDataMng->get(MessageCount,CanDataVec)){
						break;
					}
					if( CanDataVec.id == GraphId && CanDataVec.func == GraphFunc ){
						// Get Item
						GetDataRead = 0;
						GetData = 0;
						for(DataCount=0;DataCount<8;DataCount=DataCount+1){
							GetData = GetData << 8;
							GetDataRead = (unsigned long long)CanDataVec.data[7-DataCount];
							GetData = GetData + GetDataRead;
						}
						GetData = GetData >> bitOffset;
						DataMask = 0xFFFFFFFFFFFFFFFF;
						DataMask = DataMask << bitLen;
						DataFlag = DataMask;
						DataMask = ~DataMask;
						GetData = GetData & DataMask;

						if( bitLen == 32 ){
							target.ival = (int)GetData;
							if( data_type == CAN_FORMAT_TYPE_FLOAT ){
								YData = (double)target.fval;
								YData *= (double)pFormat->format.f.amplification;
								YData += (double)pFormat->format.f.offset;
							} else if( data_type == CAN_FORMAT_TYPE_INT ){
								YData = (double)target.ival;
								YData *= (double)pFormat->format.i.amplification;
								YData += (double)pFormat->format.i.offset;
							} else {
								YData = (double)target.uival;
								YData *= (double)pFormat->format.u.amplification;
								YData += (double)pFormat->format.u.offset;
							}
						} else if( bitLen == 64 ){
							long_target.ival = (long long)GetData;
							if( data_type == CAN_FORMAT_TYPE_FLOAT ){
								YData = (double)long_target.fval;
								YData *= (double)pFormat->format.f.amplification;
								YData += (double)pFormat->format.f.offset;
							} else if( data_type == CAN_FORMAT_TYPE_INT ){
								YData = (double)long_target.ival;
								YData *= (double)pFormat->format.i.amplification;
								YData += (double)pFormat->format.i.offset;
							} else {
								YData = (double)long_target.uival;
								YData *= (double)pFormat->format.u.amplification;
								YData += (double)pFormat->format.u.offset;
							}
						} else {
							if((((GetData >> ( bitLen - 1)) & 0x1 ) == 0x1 )
								&& ( data_type == CAN_FORMAT_TYPE_INT )){
								long_target.ival = (long long)GetData + (long long)DataFlag;
							} else {
								long_target.ival = (long long)GetData;
							}
							if( data_type == CAN_FORMAT_TYPE_INT ){
								YData = (double)long_target.ival;
								YData *= (double)pFormat->format.i.amplification;
								YData += (double)pFormat->format.i.offset;
							} else {
								YData = (double)long_target.uival;
								YData *= (double)pFormat->format.u.amplification;
								YData += (double)pFormat->format.u.offset;
							}
						}
						// Get Time
						GetTime = (unsigned long long)CanDataVec.mtime;
						GetTime = GetTime * 1000;
						GetTime = GetTime + (unsigned long long)CanDataVec.utime;
						if( TimeGetFlag == 0 && MessageCountMax != 0 ){
							MessageTimeGen = GetTime;
							TimeGetFlag = 1;
						}
						GetTime = GetTime - MessageTimeGen;
						XData = (double)GetTime / 1000000;

						// Write Data
		                CurveData[GraphViewCount].append(QPointF(XData, YData));
					}
					MessageCount = MessageCount + 1;
				}
				MessageCount = 0;
				// View Curve
				pPlotter->setCurveData(GraphViewCount, CurveData[GraphViewCount]);
			}
		}
	}
	if( TimeGetFlag == 1 ){
		if( GraphRighViewCount < 10 ){
			GraphRighViewCount = GraphRighViewCount + 1;
		}
		if( GraphRighViewCount > 9 ){
			pPlotter->PlotterRighView();
		}
	}
}
// cbbGraphId1
void Graph::cbbGraphId1_Changed( const QString &s )
{
	cbbGraphId1_Load();
}
// cbbGraphId1
void Graph::cbbGraphId1_Load()
{
	int i;
	int num;
	int index;
	int id;
	int func;
	int qt_ret;
	QMessageBox msgBox;
	QString * funcStr;
	QString func_cobid;
	QString qt_str;
	CanFrameNode * pNode;


	// Clear Item
	ui.cbbGraphFunc1->clear();

	// Get Index
	index = ui.cbbGraphId1->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);

	// Get Vector Num
	num = pNode->functionNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find CobID!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			funcStr = new QString();
			pNode->functionName( i, * funcStr );
			func = pNode->functionCode( i );
			qt_str.sprintf("%03X", func);
			func_cobid = ( * funcStr ) + "[" + qt_str + "]";
			ui.cbbGraphFunc1->addItem( func_cobid );
			ui.cbbGraphFunc1->adjustSize();
		}
		cbbGraphFunc1_Load();
		GraphReSize();
	}

}
// cbbGraphId2
void Graph::cbbGraphId2_Changed( const QString &s )
{
	cbbGraphId2_Load();
}
// cbbGraphId2
void Graph::cbbGraphId2_Load()
{
	int i;
	int num;
	int index;
	int id;
	int func;
	int qt_ret;
	QMessageBox msgBox;
	QString * funcStr;
	QString func_cobid;
	QString qt_str;
	CanFrameNode * pNode;


	// Clear Item
	ui.cbbGraphFunc2->clear();

	// Get Index
	index = ui.cbbGraphId2->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);

	// Get Vector Num
	num = pNode->functionNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find CobID!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			funcStr = new QString();
			pNode->functionName( i, * funcStr );
			func = pNode->functionCode( i );
			qt_str.sprintf("%03X", func);
			func_cobid = ( * funcStr ) + "[" + qt_str + "]";
			ui.cbbGraphFunc2->addItem( func_cobid );
			ui.cbbGraphFunc2->adjustSize();
		}
		cbbGraphFunc2_Load();
		GraphReSize();
	}

}
// cbbGraphId3
void Graph::cbbGraphId3_Changed( const QString &s )
{
	cbbGraphId3_Load();
}
// cbbGraphId3
void Graph::cbbGraphId3_Load()
{
	int i;
	int num;
	int index;
	int id;
	int func;
	int qt_ret;
	QMessageBox msgBox;
	QString * funcStr;
	QString func_cobid;
	QString qt_str;
	CanFrameNode * pNode;


	// Clear Item
	ui.cbbGraphFunc3->clear();

	// Get Index
	index = ui.cbbGraphId3->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);

	// Get Vector Num
	num = pNode->functionNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find CobID!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			funcStr = new QString();
			pNode->functionName( i, * funcStr );
			func = pNode->functionCode( i );
			qt_str.sprintf("%03X", func);
			func_cobid = ( * funcStr ) + "[" + qt_str + "]";
			ui.cbbGraphFunc3->addItem( func_cobid );
			ui.cbbGraphFunc3->adjustSize();
		}
		cbbGraphFunc3_Load();
		GraphReSize();
	}

}
// cbbGraphId4
void Graph::cbbGraphId4_Changed( const QString &s )
{
	cbbGraphId4_Load();
}
// cbbGraphId4
void Graph::cbbGraphId4_Load()
{
	int i;
	int num;
	int index;
	int id;
	int func;
	int qt_ret;
	QMessageBox msgBox;
	QString * funcStr;
	QString func_cobid;
	QString qt_str;
	CanFrameNode * pNode;


	// Clear Item
	ui.cbbGraphFunc4->clear();

	// Get Index
	index = ui.cbbGraphId4->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);

	// Get Vector Num
	num = pNode->functionNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find CobID!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			funcStr = new QString();
			pNode->functionName( i, * funcStr );
			func = pNode->functionCode( i );
			qt_str.sprintf("%03X", func);
			func_cobid = ( * funcStr ) + "[" + qt_str + "]";
			ui.cbbGraphFunc4->addItem( func_cobid );
			ui.cbbGraphFunc4->adjustSize();
		}
		cbbGraphFunc4_Load();
		GraphReSize();
	}

}
// cbbGraphId5
void Graph::cbbGraphId5_Changed( const QString &s )
{
	cbbGraphId5_Load();
}
// cbbGraphId5
void Graph::cbbGraphId5_Load()
{
	int i;
	int num;
	int index;
	int id;
	int func;
	int qt_ret;
	QMessageBox msgBox;
	QString * funcStr;
	QString func_cobid;
	QString qt_str;
	CanFrameNode * pNode;


	// Clear Item
	ui.cbbGraphFunc5->clear();

	// Get Index
	index = ui.cbbGraphId5->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);

	// Get Vector Num
	num = pNode->functionNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find CobID!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			funcStr = new QString();
			pNode->functionName( i, * funcStr );
			func = pNode->functionCode( i );
			qt_str.sprintf("%03X", func);
			func_cobid = ( * funcStr ) + "[" + qt_str + "]";
			ui.cbbGraphFunc5->addItem( func_cobid );
			ui.cbbGraphFunc5->adjustSize();
		}
		cbbGraphFunc5_Load();
		GraphReSize();
	}

}
// cbbGraphFunc1
void Graph::cbbGraphFunc1_Changed( const QString &s )
{
	cbbGraphFunc1_Load();
}
// cbbGraphFunc1
void Graph::cbbGraphFunc1_Load()
{
	int i;
	int num;
	int index;
	int id;
	int code;
	int no;
	int qt_ret;
	QMessageBox msgBox;
	QString * formatStr;
	QString format_no;
	QString qt_str;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;

	// Clear Item
	ui.cbbGraphItem1->clear();

	// Get Index
	index = ui.cbbGraphId1->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);
	index = ui.cbbGraphFunc1->currentIndex();
	code = pNode->functionCode(index);
	pFunction = pCanFrame->functionSearch(id,code);

	// Get Vector Num
	num = pFunction->formatNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find Item!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			formatStr = new QString();
			pFunction->formatName( i, * formatStr );
			no = pFunction->formatNo( i );
			qt_str.sprintf("%d", no);
			format_no = ( * formatStr ) + "[" + qt_str + "]";
			ui.cbbGraphItem1->addItem( format_no );
			ui.cbbGraphItem1->adjustSize();
		}
		GraphReSize();
	}

}
// cbbGraphFunc2
void Graph::cbbGraphFunc2_Changed( const QString &s )
{
	cbbGraphFunc2_Load();
}
// cbbGraphFunc2
void Graph::cbbGraphFunc2_Load()
{
	int i;
	int num;
	int index;
	int id;
	int code;
	int no;
	int qt_ret;
	QMessageBox msgBox;
	QString * formatStr;
	QString format_no;
	QString qt_str;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;

	// Clear Item
	ui.cbbGraphItem2->clear();

	// Get Index
	index = ui.cbbGraphId2->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);
	index = ui.cbbGraphFunc2->currentIndex();
	code = pNode->functionCode(index);
	pFunction = pCanFrame->functionSearch(id,code);

	// Get Vector Num
	num = pFunction->formatNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find Item!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			formatStr = new QString();
			pFunction->formatName( i, * formatStr );
			no = pFunction->formatNo( i );
			qt_str.sprintf("%d", no);
			format_no = ( * formatStr ) + "[" + qt_str + "]";
			ui.cbbGraphItem2->addItem( format_no );
			ui.cbbGraphItem2->adjustSize();
		}
		GraphReSize();
	}

}
// cbbGraphFunc3
void Graph::cbbGraphFunc3_Changed( const QString &s )
{
	cbbGraphFunc3_Load();
}
// cbbGraphFunc3
void Graph::cbbGraphFunc3_Load()
{
	int i;
	int num;
	int index;
	int id;
	int code;
	int no;
	int qt_ret;
	QMessageBox msgBox;
	QString * formatStr;
	QString format_no;
	QString qt_str;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;

	// Clear Item
	ui.cbbGraphItem3->clear();

	// Get Index
	index = ui.cbbGraphId3->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);
	index = ui.cbbGraphFunc3->currentIndex();
	code = pNode->functionCode(index);
	pFunction = pCanFrame->functionSearch(id,code);

	// Get Vector Num
	num = pFunction->formatNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find Item!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			formatStr = new QString();
			pFunction->formatName( i, * formatStr );
			no = pFunction->formatNo( i );
			qt_str.sprintf("%d", no);
			format_no = ( * formatStr ) + "[" + qt_str + "]";
			ui.cbbGraphItem3->addItem( format_no );
			ui.cbbGraphItem3->adjustSize();
		}
		GraphReSize();
	}

}
// cbbGraphFunc4
void Graph::cbbGraphFunc4_Changed( const QString &s )
{
	cbbGraphFunc4_Load();
}
// cbbGraphFunc4
void Graph::cbbGraphFunc4_Load()
{
	int i;
	int num;
	int index;
	int id;
	int code;
	int no;
	int qt_ret;
	QMessageBox msgBox;
	QString * formatStr;
	QString format_no;
	QString qt_str;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;

	// Clear Item
	ui.cbbGraphItem4->clear();

	// Get Index
	index = ui.cbbGraphId4->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);
	index = ui.cbbGraphFunc4->currentIndex();
	code = pNode->functionCode(index);
	pFunction = pCanFrame->functionSearch(id,code);

	// Get Vector Num
	num = pFunction->formatNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find Item!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			formatStr = new QString();
			pFunction->formatName( i, * formatStr );
			no = pFunction->formatNo( i );
			qt_str.sprintf("%d", no);
			format_no = ( * formatStr ) + "[" + qt_str + "]";
			ui.cbbGraphItem4->addItem( format_no );
			ui.cbbGraphItem4->adjustSize();
		}
		GraphReSize();
	}

}
// cbbGraphFunc5
void Graph::cbbGraphFunc5_Changed( const QString &s )
{
	cbbGraphFunc5_Load();
}
// cbbGraphFunc5
void Graph::cbbGraphFunc5_Load()
{
	int i;
	int num;
	int index;
	int id;
	int code;
	int no;
	int qt_ret;
	QMessageBox msgBox;
	QString * formatStr;
	QString format_no;
	QString qt_str;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;

	// Clear Item
	ui.cbbGraphItem5->clear();

	// Get Index
	index = ui.cbbGraphId5->currentIndex();
	id = pCanFrame->nodeID( index );
	pNode = pCanFrame->nodeSearch(id);
	index = ui.cbbGraphFunc5->currentIndex();
	code = pNode->functionCode(index);
	pFunction = pCanFrame->functionSearch(id,code);

	// Get Vector Num
	num = pFunction->formatNum( );
	if( num == 0 ){
		msgBox.setText("Error : Unable to find Item!");
		qt_ret = msgBox.exec();
		LoardFileError = 1;
	} else {
		// Get Func Item Name
		for( i = 0; i < num; i=i+1 ){
			formatStr = new QString();
			pFunction->formatName( i, * formatStr );
			no = pFunction->formatNo( i );
			qt_str.sprintf("%d", no);
			format_no = ( * formatStr ) + "[" + qt_str + "]";
			ui.cbbGraphItem5->addItem( format_no );
			ui.cbbGraphItem5->adjustSize();
		}
		GraphReSize();
	}

}
// GraphInit
QString Graph::GraphInit(int mode, QString line)
{
	int index;
	int ret;
	int error_flag;
	QString index_str;
	QString qt_str;
	QStringList coords;

	qt_str = "";
	error_flag = 0;

	if( mode == 0 ){
		// Load Initialize Mode 
		LoardFileError = 0;
		coords = line.split(",");
		// Recive / File
		if( coords[0] == "0" ){ 
			ui.rdbGraphRecive->setChecked(true);
			ui.rdbGraphRecive->setEnabled(true);
			ui.btnGraphStartStop->setEnabled(true);
			ui.btnGraphDraw->setEnabled(false);
			ui.txtGraphFileName->setEnabled(false);
			ui.btnGraphFileFind->setEnabled(false);
			ui.btnGraphFileLoad->setEnabled(false);
		} else {
			ui.rdbGraphFile->setChecked(true);
			ui.rdbGraphFile->setEnabled(true);
			ui.btnGraphStartStop->setEnabled(false);
			ui.btnGraphDraw->setEnabled(true);
			ui.txtGraphFileName->setEnabled(true);
			ui.btnGraphFileFind->setEnabled(true);
			ui.btnGraphFileLoad->setEnabled(true);
		}
		// FileName
		ui.txtGraphFileName->setText(coords[1]);
		// GraphName
		ui.txtGraphName->setText(coords[2]);
		GraphName = ui.txtGraphName->text();
		qt_str = "Setting(" + GraphName + ")";
		setWindowTitle(qt_str);
		pPlotter->GraphNameSet();
		// Graph1
		if( coords[3] == "1" ){
			ui.chbGraph1->setChecked(true);
			if( LoardFileError == 0 ){
				chbGraph1_Load();
			}
			// ID
			ret = ValueCheck(coords[4]);
			if( ret == 1 ){
				error_flag = 1;
			} else {
				index = coords[4].toUInt(0,16);
				ui.cbbGraphId1->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphId1_Load();
				}
			}
			// Cob-ID
			ret = ValueCheck(coords[5]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[5].toUInt(0,16);
				ui.cbbGraphFunc1->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphFunc1_Load();
				}
			}
			// Item
			ret = ValueCheck(coords[6]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[6].toUInt(0,16);
				ui.cbbGraphItem1->setCurrentIndex(index); 
			}
			// X-axis Max
			ui.txtXaxisMax->setText(coords[7]);
			// Y-axis Min1
			ui.txtYaxisMin1->setText(coords[8]);
			// Y-axis Max1
			ui.txtYaxisMax1->setText(coords[9]);
		}
		// Graph2
		if( coords[10] == "1" ){
			ui.chbGraph2->setChecked(true);
			if( LoardFileError == 0 ){
				chbGraph2_Load();
			}
			// ID
			ret = ValueCheck(coords[11]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[11].toUInt(0,16);
				ui.cbbGraphId2->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphId2_Load();
				}
			}
			// Cob-ID
			ret = ValueCheck(coords[12]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[12].toUInt(0,16);
				ui.cbbGraphFunc2->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphFunc2_Load();
				}
			}
			// Item
			ret = ValueCheck(coords[13]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[13].toUInt(0,16);
				ui.cbbGraphItem2->setCurrentIndex(index); 
			}
			// Y-axis Min2
			ui.txtYaxisMin2->setText(coords[14]);
			// Y-axis Max2
			ui.txtYaxisMax2->setText(coords[15]);
			// Y-axis Apply to Graph1
			if( coords[16] == "1" ){
				ui.chbYaxis2->setChecked(true);
			} else {
				ui.chbYaxis2->setChecked(false);
			}
		}
		// Graph3
		if( coords[17] == "1" ){
			ui.chbGraph3->setChecked(true);
			if( LoardFileError == 0 ){
				chbGraph3_Load();
			}
			// ID
			ret = ValueCheck(coords[18]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[18].toUInt(0,16);
				ui.cbbGraphId3->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphId3_Load();
				}
			}
			// Cob-ID
			ret = ValueCheck(coords[19]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[19].toUInt(0,16);
				ui.cbbGraphFunc3->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphFunc3_Load();
				}
			}
			// Item
			ret = ValueCheck(coords[20]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[20].toUInt(0,16);
				ui.cbbGraphItem3->setCurrentIndex(index); 
			}
			// Y-axis Min3
			ui.txtYaxisMin3->setText(coords[21]);
			// Y-axis Max3
			ui.txtYaxisMax3->setText(coords[22]);
			// Y-axis Apply to Graph1
			if( coords[23] == "1" ){
				ui.chbYaxis3->setChecked(true);
			} else {
				ui.chbYaxis3->setChecked(false);
			}
		}
		// Graph4
		if( coords[24] == "1" ){
			ui.chbGraph4->setChecked(true);
			if( LoardFileError == 0 ){
				chbGraph4_Load();
			}
			// ID
			ret = ValueCheck(coords[25]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[25].toUInt(0,16);
				ui.cbbGraphId4->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphId4_Load();
				}
			}
			// Cob-ID
			ret = ValueCheck(coords[26]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[26].toUInt(0,16);
				ui.cbbGraphFunc4->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphFunc4_Load();
				}
			}
			// Item
			ret = ValueCheck(coords[27]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[27].toUInt(0,16);
				ui.cbbGraphItem4->setCurrentIndex(index); 
			}
			// Y-axis Min4
			ui.txtYaxisMin4->setText(coords[28]);
			// Y-axis Max4
			ui.txtYaxisMax4->setText(coords[29]);
			// Y-axis Apply to Graph1
			if( coords[30] == "1" ){
				ui.chbYaxis4->setChecked(true);
			} else {
				ui.chbYaxis4->setChecked(false);
			}
		}
		// Graph5
		if( coords[31] == "1" ){
			ui.chbGraph5->setChecked(true);
			if( LoardFileError == 0 ){
				chbGraph5_Load();
			}
			// ID
			ret = ValueCheck(coords[32]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[32].toUInt(0,16);
				ui.cbbGraphId5->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphId5_Load();
				}
			}
			// Cob-ID
			ret = ValueCheck(coords[33]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[33].toUInt(0,16);
				ui.cbbGraphFunc5->setCurrentIndex(index); 
				if( LoardFileError == 0 ){
					cbbGraphFunc5_Load();
				}
			}
			// Item
			ret = ValueCheck(coords[34]);
			if( ret == 1 ){
				error_flag = 1;
			} else if( error_flag == 0 ){
				index = coords[34].toUInt(0,16);
				ui.cbbGraphItem5->setCurrentIndex(index); 
			}
			// Y-axis Min5
			ui.txtYaxisMin5->setText(coords[35]);
			// Y-axis Max5
			ui.txtYaxisMax5->setText(coords[36]);
			// Y-axis Apply to Graph1
			if( coords[37] == "1" ){
				ui.chbYaxis5->setChecked(true);
			} else {
				ui.chbYaxis5->setChecked(false);
			}
		}
	} else {
		// Save Initialize Mode 
		if( ui.rdbGraphRecive->isChecked() ){
			qt_str = "0," + ui.txtGraphFileName->text() + "," + ui.txtGraphName->text() + ",";
		} else {
			qt_str = "1," + ui.txtGraphFileName->text() + "," + ui.txtGraphName->text() + ",";
		}
		// Graph1
		if( ui.chbGraph1->isChecked() ){
			qt_str = qt_str + "1,";
			// ID
			index_str.sprintf("%X", ui.cbbGraphId1->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Cob-ID
			index_str.sprintf("%X", ui.cbbGraphFunc1->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Item
			index_str.sprintf("%X", ui.cbbGraphItem1->currentIndex());
			qt_str = qt_str + index_str + ",";
			// X-axis Max
			qt_str = qt_str + ui.txtXaxisMax->text() + ",";
			// Y-axis Min1
			qt_str = qt_str + ui.txtYaxisMin1->text() + ",";
			// Y-axis Max1
			qt_str = qt_str + ui.txtYaxisMax1->text() + ",";
		} else {
			qt_str = qt_str + "0,####,####,####,####,####,####,";
		}
		// Graph2
		if( ui.chbGraph2->isChecked() ){
			qt_str = qt_str + "1,";
			// ID
			index_str.sprintf("%X", ui.cbbGraphId2->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Cob-ID
			index_str.sprintf("%X", ui.cbbGraphFunc2->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Item
			index_str.sprintf("%X", ui.cbbGraphItem2->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Y-axis Min2
			qt_str = qt_str + ui.txtYaxisMin2->text() + ",";
			// Y-axis Max2
			qt_str = qt_str + ui.txtYaxisMax2->text() + ",";
			// Y-axis Apply to Graph1
			if( ui.chbYaxis2->isChecked() ){
				qt_str = qt_str + "1,";
			} else {
				qt_str = qt_str + "0,";
			}
		} else {
			qt_str = qt_str + "0,####,####,####,####,####,####,";
		}
		// Graph3
		if( ui.chbGraph3->isChecked() ){
			qt_str = qt_str + "1,";
			// ID
			index_str.sprintf("%X", ui.cbbGraphId3->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Cob-ID
			index_str.sprintf("%X", ui.cbbGraphFunc3->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Item
			index_str.sprintf("%X", ui.cbbGraphItem3->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Y-axis Min3
			qt_str = qt_str + ui.txtYaxisMin3->text() + ",";
			// Y-axis Max3
			qt_str = qt_str + ui.txtYaxisMax3->text() + ",";
			// Y-axis Apply to Graph1
			if( ui.chbYaxis3->isChecked() ){
				qt_str = qt_str + "1,";
			} else {
				qt_str = qt_str + "0,";
			}
		} else {
			qt_str = qt_str + "0,####,####,####,####,####,####,";
		}
		// Graph4
		if( ui.chbGraph4->isChecked() ){
			qt_str = qt_str + "1,";
			// ID
			index_str.sprintf("%X", ui.cbbGraphId4->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Cob-ID
			index_str.sprintf("%X", ui.cbbGraphFunc4->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Item
			index_str.sprintf("%X", ui.cbbGraphItem4->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Y-axis Min4
			qt_str = qt_str + ui.txtYaxisMin4->text() + ",";
			// Y-axis Max4
			qt_str = qt_str + ui.txtYaxisMax4->text() + ",";
			// Y-axis Apply to Graph1
			if( ui.chbYaxis4->isChecked() ){
				qt_str = qt_str + "1,";
			} else {
				qt_str = qt_str + "0,";
			}
		} else {
			qt_str = qt_str + "0,####,####,####,####,####,####,";
		}
		// Graph5
		if( ui.chbGraph5->isChecked() ){
			qt_str = qt_str + "1,";
			// ID
			index_str.sprintf("%X", ui.cbbGraphId5->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Cob-ID
			index_str.sprintf("%X", ui.cbbGraphFunc5->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Item
			index_str.sprintf("%X", ui.cbbGraphItem5->currentIndex());
			qt_str = qt_str + index_str + ",";
			// Y-axis Min5
			qt_str = qt_str + ui.txtYaxisMin5->text() + ",";
			// Y-axis Max5
			qt_str = qt_str + ui.txtYaxisMax5->text() + ",";
			// Y-axis Apply to Graph1
			if( ui.chbYaxis5->isChecked() ){
				qt_str = qt_str + "1\n";
			} else {
				qt_str = qt_str + "0\n";
			}
		} else {
			qt_str = qt_str + "0,####,####,####,####,####,####\n";
		}
	}
	LoardFileError = 0;

	return qt_str;

}

int Graph::ValueCheck(QString ValueString)
{
	int error_flag;
	int loop;
	int ValueLength;
	QString GetValue;

	error_flag = 1;
	ValueLength = ValueString.length();
	for( loop=0; loop<ValueLength; loop=loop+1 ){
		GetValue = ValueString[loop];
		if( "0" == GetValue ){        error_flag = 0;
		} else if( "1" == GetValue ){ error_flag = 0;
		} else if( "2" == GetValue ){ error_flag = 0;
		} else if( "3" == GetValue ){ error_flag = 0;
		} else if( "4" == GetValue ){ error_flag = 0;
		} else if( "5" == GetValue ){ error_flag = 0;
		} else if( "6" == GetValue ){ error_flag = 0;
		} else if( "7" == GetValue ){ error_flag = 0;
		} else if( "8" == GetValue ){ error_flag = 0;
		} else if( "9" == GetValue ){ error_flag = 0;
		} else if( "a" == GetValue ){ error_flag = 0;
		} else if( "b" == GetValue ){ error_flag = 0;
		} else if( "c" == GetValue ){ error_flag = 0;
		} else if( "d" == GetValue ){ error_flag = 0;
		} else if( "e" == GetValue ){ error_flag = 0;
		} else if( "f" == GetValue ){ error_flag = 0;
		} else if( "A" == GetValue ){ error_flag = 0;
		} else if( "B" == GetValue ){ error_flag = 0;
		} else if( "C" == GetValue ){ error_flag = 0;
		} else if( "D" == GetValue ){ error_flag = 0;
		} else if( "E" == GetValue ){ error_flag = 0;
		} else if( "F" == GetValue ){ error_flag = 0;
		} else {
			error_flag = 1;
			break;
		}
	}
	return error_flag;

}

double Graph::EndScroll( )
{
	int MessageCountMax;
	double maxtime;
	CanData CanDataVec;

	MessageCountMax = pCanDataMng->num( );
	if( MessageCountMax != 0 ){
		if(pCanDataMng->get(MessageCountMax-1,CanDataVec) == -1 ){
			pInformation->Information_set("");
			pInformation->Information_append("Unable to Get Buffer!!");
			maxtime = 0;
		} else {
			maxtime = (double)CanDataVec.mtime;
		}
	}

	return maxtime;

}

void Graph::GraphReSize( )
{
	int id_size;
	int func_size;
	int item_size;
	int width_size;

	id_size    = ui.cbbGraphId1->width();
	if( ui.cbbGraphId2->width() > id_size ){ id_size = ui.cbbGraphId2->width(); }
	if( ui.cbbGraphId3->width() > id_size ){ id_size = ui.cbbGraphId3->width(); }
	if( ui.cbbGraphId4->width() > id_size ){ id_size = ui.cbbGraphId4->width(); }
	if( ui.cbbGraphId5->width() > id_size ){ id_size = ui.cbbGraphId5->width(); }

	func_size  = ui.cbbGraphFunc1->width();
	if( ui.cbbGraphFunc2->width() > func_size ){ func_size = ui.cbbGraphFunc2->width(); }
	if( ui.cbbGraphFunc3->width() > func_size ){ func_size = ui.cbbGraphFunc3->width(); }
	if( ui.cbbGraphFunc4->width() > func_size ){ func_size = ui.cbbGraphFunc4->width(); }
	if( ui.cbbGraphFunc5->width() > func_size ){ func_size = ui.cbbGraphFunc5->width(); }

	item_size  = ui.cbbGraphItem1->width();
	if( ui.cbbGraphItem2->width() > item_size ){ item_size = ui.cbbGraphItem2->width(); }
	if( ui.cbbGraphItem3->width() > item_size ){ item_size = ui.cbbGraphItem3->width(); }
	if( ui.cbbGraphItem4->width() > item_size ){ item_size = ui.cbbGraphItem4->width(); }
	if( ui.cbbGraphItem5->width() > item_size ){ item_size = ui.cbbGraphItem5->width(); }

	width_size = 80 + id_size + 9 + func_size + 9 + item_size + 9 + 210;

	this->setMinimumWidth(width_size);
	this->setMaximumWidth(width_size);

	//Graph1
	ui.lblId1->move(80, 160);
	ui.cbbGraphId1->move(80, 180);
	ui.lblFunc1->move(80 + id_size + 9, 160);
	ui.cbbGraphFunc1->move(80 + id_size + 9, 180);
	ui.lblItem1->move(80 + id_size + 9 + func_size + 9, 160);
	ui.cbbGraphItem1->move(80 + id_size + 9 + func_size + 9, 180);
	ui.lblXaxisMax->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 160);
	ui.txtXaxisMax->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 180);
	ui.lblYaxisMin1->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 160);
	ui.txtYaxisMin1->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 180);
	ui.lblYaxisMax1->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 140, 160);
	ui.txtYaxisMax1->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 140, 180);

	//Graph2
	ui.lblId2->move(80, 210);
	ui.cbbGraphId2->move(80, 230);
	ui.lblFunc2->move(80 + id_size + 9, 210);
	ui.cbbGraphFunc2->move(80 + id_size + 9, 230);
	ui.lblItem2->move(80 + id_size + 9 + func_size + 9, 210);
	ui.cbbGraphItem2->move(80 + id_size + 9 + func_size + 9, 230);
	ui.lblYaxisMin2->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 210);
	ui.txtYaxisMin2->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 230);
	ui.lblYaxisMax2->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 210);
	ui.txtYaxisMax2->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 230);
	ui.chbYaxis2->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 140, 230);

	//Graph3
	ui.lblId3->move(80, 260);
	ui.cbbGraphId3->move(80, 280);
	ui.lblFunc3->move(80 + id_size + 9, 260);
	ui.cbbGraphFunc3->move(80 + id_size + 9, 280);
	ui.lblItem3->move(80 + id_size + 9 + func_size + 9, 260);
	ui.cbbGraphItem3->move(80 + id_size + 9 + func_size + 9, 280);
	ui.lblYaxisMin3->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 260);
	ui.txtYaxisMin3->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 280);
	ui.lblYaxisMax3->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 260);
	ui.txtYaxisMax3->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 280);
	ui.chbYaxis3->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 140, 280);

	//Graph4
	ui.lblId4->move(80, 310);
	ui.cbbGraphId4->move(80, 330);
	ui.lblFunc4->move(80 + id_size + 9, 310);
	ui.cbbGraphFunc4->move(80 + id_size + 9, 330);
	ui.lblItem4->move(80 + id_size + 9 + func_size + 9, 310);
	ui.cbbGraphItem4->move(80 + id_size + 9 + func_size + 9, 330);
	ui.lblYaxisMin4->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 310);
	ui.txtYaxisMin4->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 330);
	ui.lblYaxisMax4->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 310);
	ui.txtYaxisMax4->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 330);
	ui.chbYaxis4->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 140, 330);

	//Graph5
	ui.lblId5->move(80, 360);
	ui.cbbGraphId5->move(80, 380);
	ui.lblFunc5->move(80 + id_size + 9, 360);
	ui.cbbGraphFunc5->move(80 + id_size + 9, 380);
	ui.lblItem5->move(80 + id_size + 9 + func_size + 9, 360);
	ui.cbbGraphItem5->move(80 + id_size + 9 + func_size + 9, 380);
	ui.lblYaxisMin5->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 360);
	ui.txtYaxisMin5->move(80 + id_size + 9 + func_size + 9 + item_size + 9, 380);
	ui.lblYaxisMax5->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 360);
	ui.txtYaxisMax5->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 70, 380);
	ui.chbYaxis5->move(80 + id_size + 9 + func_size + 9 + item_size + 9 + 140, 380);

}

////////////////////////////////////////
// Setting Menu
////////////////////////////////////////
void Graph::createMenus()
{
	QMenu   * pMenu;

	//File Menu
	pMenu = ui.menuBar->addMenu( tr("File") );
	SettingMenu.pMenu = pMenu;
    connect(pMenu, SIGNAL(aboutToShow()), this, SLOT(menu_triggered()));

	createMenuActions();

}
void Graph::createMenuActions()
{
	QAction * pAction;
	QString qt_str;

	/* Clear */
	SettingMenu.pMenu->clear( );
	
	/* Load File */
	pAction = new QAction( tr("Open Graph Setting"), this );
	pAction->setShortcut(tr("Ctrl+O"));
	SettingMenu.pLoadFile = pAction;
	SettingMenu.pMenu->addAction( pAction );
    connect(pAction, SIGNAL(triggered()), this, SLOT(menu_loadfile()));

	/* Save File */
	pAction = new QAction( tr("Save Graph Setting"), this );
	pAction->setShortcut(tr("Ctrl+S"));
	SettingMenu.pSaveFile = pAction;
	SettingMenu.pMenu->addAction( pAction );
    connect(pAction, SIGNAL(triggered()), this, SLOT(menu_savefile()));

}

////////////////////////////////////////
// Menu Action
////////////////////////////////////////
void Graph::menu_triggered()
{
	createMenuActions();
}
void Graph::menu_loadfile()
{
	DWORD loop;
	QString qt_str;
	QString line;
	QString qt_ret;

	// File Select
	QString fileName = "";
	fileName = QFileDialog::getOpenFileName(
												this,
			   									tr("Load File"),		// title
//												QDir::homePath(),		// \Ƃ̃Jgpath
												QDir::currentPath(),	// \Ƃ̃Jgpath
												tr("All Files (*)"));	// filter

	// File Open
	QFile LoadFile(fileName);

	// File Read
	if (LoadFile.open(QIODevice::ReadOnly)) {
		QTextStream in(&LoadFile);
		qt_str = "";
		while (!in.atEnd()) {
			line = in.readLine();
			qt_str = qt_str + line + ",";
		}
		// Load Setting
		qt_ret = GraphInit(0, qt_str);
		// File Close
		LoadFile.close();
		// File Close
		pInformation->Information_append("Load File successfully");
	} else {
		pInformation->Information_append("Can not open load file");
	}

}
void Graph::menu_savefile()
{
	DWORD loop;
	DWORD loop_max;
	QString qt_str;
	QString line;
	QString qt_ret;

	// File Select
	QString fileName = "";
	fileName = QFileDialog::getSaveFileName(
												this,
			   									tr("Save File"),		// title
//												QDir::homePath(),		// \Ƃ̃Jgpath
												QDir::currentPath(),	// \Ƃ̃Jgpath
												tr("All Files (*)"));	// filter

	// File Open
	QFile SaveFile(fileName);

	// File Write
	if(SaveFile.open(QIODevice::WriteOnly)) {
		QTextStream outputfile(&SaveFile);
		line = GraphInit(1,qt_str);
		QStringList coords = line.split(",");
		loop_max = (coords.size()-3) / 7;
		qt_str = "";
		qt_str = qt_str + coords[0] + ",";
		qt_str = qt_str + coords[1] + ",";
		qt_str = qt_str + coords[2] + "\n";
		outputfile << qt_str;
		for( loop = 0; loop < loop_max; loop=loop+1 ){
			qt_str = "";
			qt_str = qt_str + coords[loop*7+3] + ",";
			qt_str = qt_str + coords[loop*7+4] + ",";
			qt_str = qt_str + coords[loop*7+5] + ",";
			qt_str = qt_str + coords[loop*7+6] + ",";
			qt_str = qt_str + coords[loop*7+7] + ",";
			qt_str = qt_str + coords[loop*7+8] + ",";
			qt_str = qt_str + coords[loop*7+9] + "\n";
			outputfile << qt_str;
		}
		// File Close
		SaveFile.close();
		// File Close
		pInformation->Information_append("Save File successfully");
	} else {
		pInformation->Information_append("Can not open save file");
	}

}

