#include <QtGui>
#include <windows.h>

#include "PCANBasic.h"
#include "hardware.h"
#include "information.h"
#include "fcan_view.h"

Hardware::Hardware(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
	hide();

	pInformation = NULL;
	pFcanView = NULL;

	// txtDevNumber
//	connect( ui.txtDevNumber,SIGNAL(keyPressEvent()),this,SLOT(txtDevNumber_KeyPress()));
//	connect( ui.txtDevNumber,SIGNAL(Leave()),this,SLOT(txtDevNumber_Leave()));
	// btnDllInfo
	connect( ui.btnDllInfo,SIGNAL(clicked()),this,SLOT(btnDllInfo_Click()));
	// btnGetDevNumber
	connect( ui.btnGetDevNumber,SIGNAL(clicked()),this,SLOT(btnGetDevNumber_Click()));
	// btnSetDevNumber
	connect( ui.btnSetDevNumber,SIGNAL(clicked()),this,SLOT(btnSetDevNumber_Click()));
	// btnInit
	connect( ui.btnInit,SIGNAL(clicked()),this,SLOT(btnInit_Click()));
	// btnInfo
	connect( ui.btnInfo,SIGNAL(clicked()),this,SLOT(btnInfo_Click()));
	// cbbInterrupt
	// cbbIO
	// cbbMsgType
	// cbbBaudrates
//	connect( ui.cbbBaudrates,SIGNAL(SelectedIndexChanged()),this,SLOT(void cbbBaudrates_SelectedIndexChanged()));
	// cbbHws
	connect( ui.cbbHws,SIGNAL(activated( const QString & )),this,SLOT(cbbHws_Changed( const QString & )));
	// btnWrite
//	connect( ui.btnWrite,SIGNAL(clicked()),this,SLOT(btnWrite_Click()));
	// chbRemote
//	connect( ui.chbRemote,SIGNAL(CheckedChanged()),this,SLOT(void chbRemote_CheckedChanged()));
	// chbExtended
//	connect( ui.chbExtended,SIGNAL(CheckedChanged()),this,SLOT(void chbExtended_CheckedChanged()));
	// txtData7
//	connect( ui.txtData7,SIGNAL(KeyPress()),this,SLOT(void txtID_KeyPress()));
//	connect( ui.txtData7,SIGNAL(Leave()),this,SLOT(void txtData0_Leave()));
	// txtData6
	// txtData5
	// txtData4
	// txtData3
	// txtData2
	// txtData1
	// txtData0
	// nudLength
//	connect( ui.nudLength,SIGNAL(ValueChanged()),this,SLOT(void nudLength_ValueChanged()));
	// txtID
//	connect( ui.txtID,SIGNAL(clicked()),this,SLOT(void txtID_KeyPress()));
//	connect( ui.txtID,SIGNAL(clicked()),this,SLOT(void txtID_Leave()));

	// rdbStandard
//	connect( ui.rdbStandard,SIGNAL(CheckedChanged()),this,SLOT(void rdbStandard_CheckedChanged()));
	// rdbExtended
	// txtIdTo
//	connect( ui.txtIdTo,SIGNAL(KeyPress()),this,SLOT(void txtID_KeyPress()));
//	connect( ui.txtIdTo,SIGNAL(Leave()),this,SLOT(void txtIdFrom_Leave()));
	// txtIdFrom
//	connect( ui.txtIdFrom,SIGNAL(KeyPress()),this,SLOT(void txtID_KeyPress()));
//	connect( ui.txtIdFrom,SIGNAL(Leave()),this,SLOT(void txtIdFrom_Leave()));
	// btnResetFilter
//	connect( ui.btnResetFilter,SIGNAL(clicked()),this,SLOT(btnResetFilter_Click()));
	// btnSetFilter
//	connect( ui.btnSetFilter,SIGNAL(clicked()),this,SLOT(btnSetFilter_Click()));

	// rdbEvent
	// rdbTimer
//	connect( ui.rdbTimer,SIGNAL(CheckedChanged()),this,SLOT(rdbTimer_CheckedChanged()));
	// chbTimeStamp
//	connect( ui.chbTimeStamp,SIGNAL(CheckedChanged()),this,SLOT(chbTimeStamp_CheckedChanged()));
	// lstMessages
//	connect( ui.lstMessages,SIGNAL(DoubleClick()),this,SLOT(lstMessages_DoubleClick()));

	// txtInfo
//	connect( ui.txtInfo,SIGNAL(DoubleClick()),this,SLOT(txtInfo_DoubleClick()));
	// btnClose
//	connect( ui.btnClose,SIGNAL(clicked()),this,SLOT(btnClose_Click()));

	// tmrRead
//	connect( ui.pushButton,SIGNAL(clicked()),this,SLOT(tmrRead_Tick()));


	//Init members
	//
	m_bWasLoaded = false;
	m_hDll = NULL;
	m_PcanHandle = NULL;

	// Loads the API
	//
	LoadAPI();

	ui.btnDllInfo->setEnabled(false);

	ui.cbbHws->setEnabled(true);
	ui.cbbBaudrates->setEnabled(true);
	ui.cbbMsgType->setEnabled(true);
	ui.cbbIO->setEnabled(false);
	ui.cbbInterrupt->setEnabled(false);
	ui.btnGetDevNumber->setEnabled(false);
	ui.btnSetDevNumber->setEnabled(false);
	ui.btnInfo->setEnabled(false);
	ui.btnDllInfo->setEnabled(false);
	ui.btnInit->setEnabled(true);
	ui.btnInit->setText("Initialize");
	ui.txtDevNumber->setEnabled(false);

	m_HandlesArray[0] = PCAN_ISABUS1;
	m_HandlesArray[1] = PCAN_ISABUS2;
	m_HandlesArray[2] = PCAN_ISABUS3;
	m_HandlesArray[3] = PCAN_ISABUS4;
	m_HandlesArray[4] = PCAN_ISABUS5;
	m_HandlesArray[5] = PCAN_ISABUS6;
	m_HandlesArray[6] = PCAN_ISABUS7;
	m_HandlesArray[7] = PCAN_ISABUS8;
	m_HandlesArray[8] = PCAN_DNGBUS1;
	m_HandlesArray[9] = PCAN_PCIBUS1;
	m_HandlesArray[10] = PCAN_PCIBUS2;
	m_HandlesArray[11] = PCAN_PCIBUS3;
	m_HandlesArray[12] = PCAN_PCIBUS4;
	m_HandlesArray[13] = PCAN_PCIBUS5;
	m_HandlesArray[14] = PCAN_PCIBUS6;
	m_HandlesArray[15] = PCAN_PCIBUS7;
	m_HandlesArray[16] = PCAN_PCIBUS8;
	m_HandlesArray[17] = PCAN_USBBUS1;
	m_HandlesArray[18] = PCAN_USBBUS2;
	m_HandlesArray[19] = PCAN_USBBUS3;
	m_HandlesArray[20] = PCAN_USBBUS4;
	m_HandlesArray[21] = PCAN_USBBUS5;
	m_HandlesArray[22] = PCAN_USBBUS6;
	m_HandlesArray[23] = PCAN_USBBUS7;
	m_HandlesArray[24] = PCAN_USBBUS8;
	m_HandlesArray[25] = PCAN_PCCBUS1;
	m_HandlesArray[26] = PCAN_PCCBUS2;


	int i;
	int iBuffer;
	TPCANStatus stsResult;

	ui.cbbHws->clear();

	// Checks for a Plug&Play Handle and, according with the return value, includes it
	// into the list of available hardware channels.
	//
	for (i = 0; i < (sizeof(m_HandlesArray) /sizeof(TPCANHandle)) ; i++){
		if (m_HandlesArray[i] > PCAN_DNGBUS1){
			stsResult = GetValue((TPCANHandle)m_HandlesArray[i], PCAN_CHANNEL_CONDITION, (void*)&iBuffer, sizeof(iBuffer));
			if (((stsResult) == PCAN_ERROR_OK) && (iBuffer == PCAN_CHANNEL_AVAILABLE)){
				ui.cbbHws->addItem(FormatChannelName(m_HandlesArray[i]));
			}
		}
	}

	// Includes all no-Plug&Play Handles
	//
	for (i = 0; i < (sizeof(m_HandlesArray) /sizeof(TPCANHandle)) ; i++){
		if (m_HandlesArray[i] <= PCAN_DNGBUS1){
			ui.cbbHws->addItem(FormatChannelName(m_HandlesArray[i]));
		}
	}


	HardwareInitSet = 0;
	HardwareIoInterruptSelect = 0;

	// Menu Init
	createMenus();

}

Hardware::~Hardware()
{

	if( HardwareInitSet == 1 ){
		if(m_hThread != NULL){
			TerminateThread(m_hThread, -1000);
			m_hThread = NULL;
		}
		// Releases a current connected PCAN-Basic channel
		if( m_PcanHandle != NULL ){
			Uninitialize(m_PcanHandle);
		}
		UnloadAPI();
		pFcanView->ViewWindow[1] = false;
	}

}

////////////////////////////////////////
// Pointer Setting
////////////////////////////////////////
void Hardware::InformationSet( Information * information )
{
	pInformation = information;
}
void Hardware::FcanViewSet( FCAN_View * fcanview )
{
	pFcanView = fcanview;
}

////////////////////////////////////////////////////////////////////////////////
// Pcan-Basic-Class
////////////////////////////////////////////////////////////////////////////////
void Hardware::LoadAPI()
{
	int qt_ret;
	QMessageBox msgBox;

	// Initializes pointers
	//
	InitializePointers();

	// Loads the DLL
	//
	if(!LoadDllHandle())
	{
		msgBox.setText("Error: Unable to find the DLL PCANBasic.dll!");
		qt_ret = msgBox.exec();
		return;
	}

	// Loads API functions
	//
	m_pInitialize = (fpInitialize)GetFunction("CAN_Initialize");
	m_pUnInitialize = (fpUninitialize)GetFunction("CAN_Uninitialize");
	m_pReset = (fpReset)GetFunction("CAN_Reset");
	m_pGetStatus = (fpGetStatus)GetFunction("CAN_GetStatus");
	m_pRead = (fpRead)GetFunction("CAN_Read");
	m_pWrite = (fpWrite)GetFunction("CAN_Write");
	m_pFilterMessages = (fpFilterMessages)GetFunction("CAN_FilterMessages");
	m_pGetValue = (fpSetValue)GetFunction("CAN_GetValue");
	m_pSetValue = (fpGetValue)GetFunction("CAN_SetValue");
	m_pGetTextError = (fpGetErrorText)GetFunction("CAN_GetErrorText");

	m_bWasLoaded = m_pInitialize && m_pUnInitialize && m_pReset && m_pGetStatus && m_pRead
		&& m_pWrite && m_pFilterMessages && m_pGetValue && m_pSetValue && m_pGetTextError;
	
	// If the API was not loaded (Wrong version), an error message is shown. 
	//
	if(!m_bWasLoaded){
		msgBox.setText("Error: DLL functions could not be loaded!");
		qt_ret = msgBox.exec();
	}
}

void Hardware::UnloadAPI()
{
	// Frees a loaded DLL
	//
	if(m_hDll != NULL)
		FreeLibrary(m_hDll);
	m_hDll = NULL;	

	// Initializes pointers
	//
	InitializePointers();

	m_bWasLoaded = false;
}

QString Hardware::FormatChannelName(TPCANHandle handle)
{
	QString qt_str;
	QString result;
	BYTE byChannel;

	// Gets the owner device and channel for a 
	// PCAN-Basic handle
	//
	byChannel = (BYTE)(handle) & 0xF;

	// Constructs the PCAN-Basic Channel name and return it
	//
	qt_str = GetTPCANHandleName(handle);

//	result.sprintf("%d (%Xh)", byChannel, handle);
	result.sprintf("%d", byChannel);

	result = qt_str + " " + result;
	return result;
}

QString Hardware::GetTPCANHandleName(TPCANHandle handle)
{
	QString result = "PCAN_NONE";
	switch(handle)
	{
	case PCAN_ISABUS1:
	case PCAN_ISABUS2:
	case PCAN_ISABUS3:
	case PCAN_ISABUS4:
	case PCAN_ISABUS5:
	case PCAN_ISABUS6:
	case PCAN_ISABUS7:
	case PCAN_ISABUS8:
		result = "ISA-Channel";
		break;

	case PCAN_DNGBUS1:
		result = "DNG-Channel";
		break;

	case PCAN_PCIBUS1:
	case PCAN_PCIBUS2:
	case PCAN_PCIBUS3:
	case PCAN_PCIBUS4:
	case PCAN_PCIBUS5:
	case PCAN_PCIBUS6:
	case PCAN_PCIBUS7:
	case PCAN_PCIBUS8:
		result = "PCI-Channel";
		break;

	case PCAN_USBBUS1:
	case PCAN_USBBUS2:
	case PCAN_USBBUS3:
	case PCAN_USBBUS4:
	case PCAN_USBBUS5:
	case PCAN_USBBUS6:
	case PCAN_USBBUS7:
	case PCAN_USBBUS8:
		result = "USB-Channel";
		break;

	case PCAN_PCCBUS1:
	case PCAN_PCCBUS2:
		result = "PCC-Channel";
		break;
	}
	return result;
}

void Hardware::InitializePointers()
{
	// Initializes thepointers for the PCANBasic functions
	//
	m_pInitialize = NULL;
	m_pUnInitialize = NULL;
	m_pReset = NULL;
	m_pGetStatus = NULL;
	m_pRead = NULL;
	m_pWrite = NULL;
	m_pFilterMessages = NULL;
	m_pGetValue = NULL;
	m_pSetValue = NULL;	
	m_pGetTextError = NULL;
}

bool Hardware::LoadDllHandle()
{   
	QString cDllName;
	LPCTSTR sDllName;

	// Was already loaded
	//
	if(m_bWasLoaded)
		return true;

	//Loads Dll
	//
	cDllName = "PCANBasic";
	sDllName = (LPCTSTR)cDllName.utf16();
	m_hDll = LoadLibrary(sDllName);
//	m_hDll = LoadLibrary("PCANBasic");

	// Return true if the DLL was loaded or false otherwise
	//
	return (m_hDll != NULL);
}

FARPROC Hardware::GetFunction(char* strName)
{
	// There is no DLL loaded
	//
	if(m_hDll  == NULL)
		return NULL;

	// Gets the address of the given function in the loeaded DLL
	//
	return GetProcAddress(m_hDll, strName);
}

TPCANStatus Hardware::Initialize(
        TPCANHandle Channel, 
        TPCANBaudrate Btr0Btr1, 
        TPCANType HwType,
		DWORD IOPort, 
		WORD Interrupt)
{
	if(!m_bWasLoaded)
		return PCAN_ERROR_UNKNOWN;

	return (TPCANStatus)m_pInitialize(Channel, Btr0Btr1, HwType, IOPort, Interrupt); 
}

TPCANStatus Hardware::Uninitialize(
        TPCANHandle Channel)
{
	if(!m_bWasLoaded)
		return PCAN_ERROR_UNKNOWN;

	return (TPCANStatus)m_pUnInitialize(Channel);  
}

TPCANStatus Hardware::Reset(
     TPCANHandle Channel)
{
    if(!m_bWasLoaded)
        return PCAN_ERROR_UNKNOWN;

    return (TPCANStatus)m_pReset(Channel);
}

TPCANStatus Hardware::GetStatus(
        TPCANHandle Channel)
{
    if(!m_bWasLoaded)
        return PCAN_ERROR_UNKNOWN;

    return (TPCANStatus)m_pGetStatus(Channel);
}

TPCANStatus Hardware::Read(
        TPCANHandle Channel, 
        TPCANMsg* MessageBuffer, 
        TPCANTimestamp* TimestampBuffer)
{
	if(!m_bWasLoaded)
		return PCAN_ERROR_UNKNOWN;

	return (TPCANStatus)m_pRead(Channel, MessageBuffer, TimestampBuffer);  
}

TPCANStatus Hardware::Write(
        TPCANHandle Channel, 
        TPCANMsg* MessageBuffer)
{
	if(!m_bWasLoaded)
		return PCAN_ERROR_UNKNOWN;

	return (TPCANStatus)m_pWrite(Channel, MessageBuffer);  
}

TPCANStatus Hardware::FilterMessages(
        TPCANHandle Channel, 
        DWORD FromID, 
        DWORD ToID, 
        TPCANMode Mode)
{
	if(!m_bWasLoaded)
		return PCAN_ERROR_UNKNOWN;

	return (TPCANStatus)m_pFilterMessages(Channel, FromID, ToID, Mode);  
}

TPCANStatus Hardware::GetValue(
        TPCANHandle Channel, 
        TPCANParameter Parameter,  
        void* Buffer, 
        DWORD BufferLength)
{
	if(!m_bWasLoaded)
		return PCAN_ERROR_UNKNOWN;

	return (TPCANStatus)m_pGetValue(Channel, Parameter, Buffer, BufferLength); 
}

TPCANStatus Hardware::SetValue(
        TPCANHandle Channel,
        TPCANParameter Parameter,
        void* Buffer,
		DWORD BufferLength)
{
	if(!m_bWasLoaded)
		return PCAN_ERROR_UNKNOWN;

	return (TPCANStatus)m_pSetValue(Channel, Parameter, Buffer, BufferLength); 
}

TPCANStatus Hardware::GetErrorText(
        TPCANStatus Error, 
        WORD Language, 
        LPSTR Buffer)
{
	if(!m_bWasLoaded)
		return PCAN_ERROR_UNKNOWN;

	return (TPCANStatus)m_pGetTextError(Error, Language, Buffer); 
}


////////////////////////////////////////
// Hardware Function
////////////////////////////////////////
// Close
void	Hardware::closeEvent(QCloseEvent * pEvent)
{

	if( HardwareInitSet == 1 ){

		int qt_ret = QMessageBox::warning(this, tr("Hardware"),
										tr("Release Hardware when Close a Window.\n"
										   "Are you all right ?"),
										QMessageBox::Yes | QMessageBox::Default,
										QMessageBox::No );

		if( qt_ret == QMessageBox::Yes ){
			if(m_hThread != NULL){
				TerminateThread(m_hThread, -1000);
				m_hThread = NULL;
			}
			// Releases a current connected PCAN-Basic channel
			if( m_PcanHandle != NULL ){
				Uninitialize(m_PcanHandle);
			}

			UnloadAPI();

			pFcanView->ViewWindow[1] = false;

			pEvent->accept();
		} else {
			pEvent->ignore();
		}
	} else {
		if(m_hThread != NULL){
			TerminateThread(m_hThread, -1000);
			m_hThread = NULL;
		}
		// Releases a current connected PCAN-Basic channel
		if( m_PcanHandle != NULL ){
			Uninitialize(m_PcanHandle);
		}

		pFcanView->ViewWindow[1] = false;
	}

}
void	Hardware::btnDllInfo_Click()
{

	TPCANStatus stsResult;
	char buffer[256];
	QString info, strToken;
	int iPos = 0;
	QMessageBox msgBox;
	int qt_ret;
	QString qt_str;

	memset(buffer,'\0',255);

	// We get the vesion of the PCAN-Basic API
	//
	stsResult = GetValue(PCAN_NONEBUS, PCAN_API_VERSION, buffer, 256);
	if (stsResult == PCAN_ERROR_OK) {
		pInformation->Information_set("");
		info = buffer;
		pInformation->Information_append("API Version: " + info);
		// We get the driver version of the channel being used
		//
		stsResult = GetValue(m_PcanHandle, PCAN_CHANNEL_VERSION, buffer, 256);
		if (stsResult == PCAN_ERROR_OK) {
			info = buffer;
			pInformation->Information_append("Channel/Driver Version: " + info);
		}
	}

	// If the function fail, an error message is shown
	//
	if(stsResult != PCAN_ERROR_OK) {
		qt_str = GetFormatedError(stsResult);
		msgBox.setText(qt_str);
		qt_ret = msgBox.exec();
	}

}

void	Hardware::btnGetDevNumber_Click()
{

	TPCANStatus stsResult;
	int iBuffer;
	QString info;
	QMessageBox msgBox;
	int qt_ret;
	QString qt_str;

	// The Device-Number of an USB channel will be get
	//
	stsResult = GetValue(m_PcanHandle, PCAN_DEVICE_NUMBER, (void*)&iBuffer, sizeof(iBuffer));
	if(stsResult == PCAN_ERROR_OK) {
		info.sprintf("The configured Device-Number is %d", iBuffer);
		pInformation->Information_set("");
		pInformation->Information_append(info);
	} else {
		qt_str = GetFormatedError(stsResult);
		msgBox.setText(qt_str);
		qt_ret = msgBox.exec();
	}

}

void	Hardware::btnSetDevNumber_Click()
{

	TPCANStatus stsResult;
	int iBuffer;
	QString info;
	QString qt_str;
	QMessageBox msgBox;
	int qt_ret;

	// The Device-Number of an USB channel will be set
	//
	qt_str = ui.txtDevNumber->text();
	iBuffer = qt_str.toUInt(0,10);

	stsResult = SetValue(m_PcanHandle, PCAN_DEVICE_NUMBER, (void*)&iBuffer, sizeof(iBuffer));

	if(stsResult == PCAN_ERROR_OK) {
		pInformation->Information_set("");
		pInformation->Information_append("The desired Device-Number was successfully configured");
	} else {
		qt_str = GetFormatedError(stsResult);
		msgBox.setText(qt_str);
		qt_ret = msgBox.exec();
	}

}

void	Hardware::btnInit_Click()
{

	TPCANStatus stsResult;
	int selectedIO;
	int selectedInterrupt;

	int qt_ret;
	QMessageBox msgBox;
	QString	SelectData_Qstr;


	// Initialize Select
	if( ui.btnInit->text() == "Initialize" ){
		// Parse Hardware
		//
		SelectData_Qstr = ui.cbbHws->currentText();
		if( SelectData_Qstr == "DNG-Channel 1" ){ m_PcanHandle = PCAN_DNGBUS1; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "ISA-Channel 1" ){ m_PcanHandle = PCAN_ISABUS1; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "ISA-Channel 2" ){ m_PcanHandle = PCAN_ISABUS2; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "ISA-Channel 3" ){ m_PcanHandle = PCAN_ISABUS3; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "ISA-Channel 4" ){ m_PcanHandle = PCAN_ISABUS4; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "ISA-Channel 5" ){ m_PcanHandle = PCAN_ISABUS5; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "ISA-Channel 6" ){ m_PcanHandle = PCAN_ISABUS6; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "ISA-Channel 7" ){ m_PcanHandle = PCAN_ISABUS7; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "ISA-Channel 8" ){ m_PcanHandle = PCAN_ISABUS8; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "PCC-Channel 1" ){ m_PcanHandle = PCAN_PCCBUS1; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "PCC-Channel 2" ){ m_PcanHandle = PCAN_PCCBUS2; HardwareIoInterruptSelect=1;
		} else if( SelectData_Qstr == "PCI-Channel 1" ){ m_PcanHandle = PCAN_PCIBUS1; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "PCI-Channel 2" ){ m_PcanHandle = PCAN_PCIBUS2; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "PCI-Channel 3" ){ m_PcanHandle = PCAN_PCIBUS3; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "PCI-Channel 4" ){ m_PcanHandle = PCAN_PCIBUS4; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "PCI-Channel 5" ){ m_PcanHandle = PCAN_PCIBUS5; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "PCI-Channel 6" ){ m_PcanHandle = PCAN_PCIBUS6; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "PCI-Channel 7" ){ m_PcanHandle = PCAN_PCIBUS7; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "PCI-Channel 8" ){ m_PcanHandle = PCAN_PCIBUS8; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "USB-Channel 1" ){ m_PcanHandle = PCAN_USBBUS1; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "USB-Channel 2" ){ m_PcanHandle = PCAN_USBBUS2; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "USB-Channel 3" ){ m_PcanHandle = PCAN_USBBUS3; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "USB-Channel 4" ){ m_PcanHandle = PCAN_USBBUS4; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "USB-Channel 5" ){ m_PcanHandle = PCAN_USBBUS5; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "USB-Channel 6" ){ m_PcanHandle = PCAN_USBBUS6; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "USB-Channel 7" ){ m_PcanHandle = PCAN_USBBUS7; HardwareIoInterruptSelect=0;
		} else if( SelectData_Qstr == "USB-Channel 8" ){ m_PcanHandle = PCAN_USBBUS8; HardwareIoInterruptSelect=0;
		} else { m_PcanHandle = PCAN_NONEBUS; HardwareIoInterruptSelect=0;
		}

		// Parse Baudrates
		//
		SelectData_Qstr = ui.cbbBaudrates->currentText();
		if( SelectData_Qstr == "1 Mbit/sec" ){ m_Baudrate = PCAN_BAUD_1M;
		} else if( SelectData_Qstr == "500 KBit/sec" ){ m_Baudrate = PCAN_BAUD_500K;
		} else if( SelectData_Qstr == "250 KBit/sec" ){ m_Baudrate = PCAN_BAUD_250K;
		} else if( SelectData_Qstr == "125 KBit/sec" ){ m_Baudrate = PCAN_BAUD_125K;
		} else if( SelectData_Qstr == "100 KBit/sec" ){ m_Baudrate = PCAN_BAUD_100K;
		} else if( SelectData_Qstr == "50 KBit/sec"  ){ m_Baudrate = PCAN_BAUD_50K;
		} else if( SelectData_Qstr == "20 KBit/sec"  ){ m_Baudrate = PCAN_BAUD_20K;
		} else if( SelectData_Qstr == "10 KBit/sec"  ){ m_Baudrate = PCAN_BAUD_10K;
		} else if( SelectData_Qstr == "5 KBit/sec"   ){ m_Baudrate = PCAN_BAUD_5K;
		} else { m_Baudrate = PCAN_BAUD_500K;
		}

		// Parse HardwareType
		//
		m_HwType = PCAN_TYPE_ISA;

		// Parse IO
		//
		SelectData_Qstr = ui.cbbIO->currentText();
		selectedIO = SelectData_Qstr.toUInt(0,16);

		// Parse Interrupt
		//
		SelectData_Qstr = ui.cbbInterrupt->currentText();
		selectedInterrupt = SelectData_Qstr.toUInt(0,16);

		// Connects a selected PCAN-Basic channel
		//
		stsResult = Initialize(m_PcanHandle, m_Baudrate, m_HwType, selectedIO, selectedInterrupt);

		if (stsResult != PCAN_ERROR_OK){
			msgBox.setText("Error: Hardware Initialize Not Creat!");
			qt_ret = msgBox.exec();
			HardwareInitSet = 0;
		} else {
			HardwareInitSet = 1;
			pInformation->Information_set("");
			pInformation->Information_append("Hardware Initialize");

			// Hardware Reset
			stsResult = Reset(m_PcanHandle);
			if (stsResult != PCAN_ERROR_OK){
				msgBox.setText("Error: Hardware Reset Not Creat!");
				qt_ret = msgBox.exec();
			} else {
				pInformation->Information_append("Hardware Reset");
			}

			if( ui.cbbHws->currentText() == "ISA-Channel 1"
				|| ui.cbbHws->currentText() == "ISA-Channel 2"
				|| ui.cbbHws->currentText() == "ISA-Channel 3"
				|| ui.cbbHws->currentText() == "ISA-Channel 4"
				|| ui.cbbHws->currentText() == "ISA-Channel 5"
				|| ui.cbbHws->currentText() == "ISA-Channel 6"
				|| ui.cbbHws->currentText() == "ISA-Channel 7"
				|| ui.cbbHws->currentText() == "ISA-Channel 8" ){
				SelectData_Qstr = ui.cbbHws->currentText() + "  ";
				SelectData_Qstr = SelectData_Qstr + ui.cbbBaudrates->currentText() + "  ";
				SelectData_Qstr = SelectData_Qstr + ui.cbbMsgType->currentText() + "  ";
				SelectData_Qstr = SelectData_Qstr + ui.cbbIO->currentText() + " ";
//				SelectData_Qstr = SelectData_Qstr + ui.cbbInterrupt->currentText() + "  ";
			} else {
				SelectData_Qstr = ui.cbbHws->currentText() + "  ";
				SelectData_Qstr = SelectData_Qstr + ui.cbbBaudrates->currentText() + "  ";
//				SelectData_Qstr = SelectData_Qstr + ui.cbbMsgType->currentText() + "  ";
			}
			pFcanView->HardwareSetting("");
			pFcanView->statusBar_message(SelectData_Qstr);
			pFcanView->HardwareSetting(SelectData_Qstr);

			// groupBox1
			ui.btnInit->setText("Release");
			ui.cbbHws->setEnabled(false);
			ui.cbbBaudrates->setEnabled(false);
			ui.cbbMsgType->setEnabled(false);
			ui.cbbIO->setEnabled(false);
			ui.cbbInterrupt->setEnabled(false);
			ui.btnGetDevNumber->setEnabled(true);
			ui.btnSetDevNumber->setEnabled(true);
			ui.btnInfo->setEnabled(true);
			ui.btnDllInfo->setEnabled(true);
			ui.txtDevNumber->setEnabled(true);

		}

		// Sets the connection status of the main-form
		//
//		SetConnectionStatus(stsResult == PCAN_ERROR_OK);
	} else {
		// Terminate Read Thread if it exists
		//
		if(m_hThread != NULL)
		{
			TerminateThread(m_hThread, -1000);
			m_hThread = NULL;
		}

		// Releases a current connected PCAN-Basic channel
		//
		Uninitialize(m_PcanHandle);

		// Sets the connection status of the main-form
		//
//		SetConnectionStatus(false);
		HardwareInitSet = 0;

		pInformation->Information_set("");
		pInformation->Information_append("Hardware Release");

		pFcanView->HardwareSetting("");
		pFcanView->statusBar_clear( );


		// groupBox1
		ui.btnInit->setText("Initialize");
		ui.cbbHws->setEnabled(true);
		ui.cbbHws->setCurrentIndex(0);
		ui.cbbBaudrates->setEnabled(true);
		ui.cbbMsgType->setEnabled(true);
		if( HardwareIoInterruptSelect == 1 ){
			ui.cbbIO->setEnabled(true);
			ui.cbbInterrupt->setEnabled(true);
		} else {
			ui.cbbIO->setEnabled(false);
			ui.cbbInterrupt->setEnabled(false);
		}
		ui.btnGetDevNumber->setEnabled(false);
		ui.btnSetDevNumber->setEnabled(false);
		ui.btnInfo->setEnabled(false);
		ui.btnDllInfo->setEnabled(false);
		ui.txtDevNumber->setEnabled(false);

	}

}

void	Hardware::btnInfo_Click()
{

	TPCANStatus status;
	QString errorName;

	// Gets the current BUS status of a PCAN Channel.
	//
	status = GetStatus(m_PcanHandle);

	// Switch On Error Name
	//
	switch(status)
	{
		case PCAN_ERROR_INITIALIZE:
			errorName = "PCAN_ERROR_INITIALIZE";
			break;

		case PCAN_ERROR_BUSLIGHT:
			errorName = "PCAN_ERROR_BUSLIGHT";
			break;

		case PCAN_ERROR_BUSHEAVY:
			errorName = "PCAN_ERROR_BUSHEAVY";
			break;

		case PCAN_ERROR_BUSOFF:
			errorName = "PCAN_ERROR_BUSOFF";
			break;

		case PCAN_ERROR_OK:
			errorName = "PCAN_ERROR_OK";
			break;

		default:
			errorName = "See Documentation";
			break;
	}

	// Display Message
	//
	pInformation->Information_set("");
	pInformation->Information_append(errorName);

}

// ListenSet
void	Hardware::ListenSet(int mode)
{

	TPCANStatus stsResult;
	int iBuffer;
	QString info;
	QString qt_str;
	QMessageBox msgBox;
	int qt_ret;

	// Set/Reset set
	//
	if( mode == 1 ){
		iBuffer = PCAN_PARAMETER_ON;
	} else { 
		iBuffer = PCAN_PARAMETER_OFF;
	}
	stsResult = SetValue(m_PcanHandle, PCAN_LISTEN_ONLY, (void*)&iBuffer, sizeof(iBuffer));
	if(stsResult != PCAN_ERROR_OK) {
		pInformation->Information_set("");
		pInformation->Information_append("The CAN-option Listen-Only was setting Error.");
	}

}

// ResetSet
void	Hardware::ResetSet( )
{

	TPCANStatus stsResult;
	QMessageBox msgBox;
	int qt_ret;

	// Hardware Reset
	stsResult = Reset(m_PcanHandle);
	if (stsResult != PCAN_ERROR_OK){
		msgBox.setText("Error: Hardware Reset Not Creat!");
		qt_ret = msgBox.exec();
	} else {
		pInformation->Information_append("Hardware Reset");
	}
}

TPCANStatus Hardware::btnWrite_Click(TPCANMsg* MessageBuffer)
{
	TPCANStatus stsResult;

	// The message is sent to the configured hardware
	stsResult = Write(m_PcanHandle, MessageBuffer);
	return stsResult;

}

TPCANStatus Hardware::btnSetFilter_Click(DWORD FromID, DWORD ToID, TPCANMode Mode)
{
	TPCANStatus stsResult;
	int iBuffer;

	// Configures the message filter for a custom range of messages
	iBuffer = PCAN_FILTER_CLOSE;
	stsResult = SetValue(m_PcanHandle, PCAN_MESSAGE_FILTER, (void*)&iBuffer, sizeof(iBuffer));
	if (stsResult == PCAN_ERROR_OK) {
		stsResult = FilterMessages(m_PcanHandle, FromID, ToID, Mode);
	}
	return stsResult;

}

TPCANStatus Hardware::btnResetFilter_Click(DWORD FromID, DWORD ToID, TPCANMode Mode)
{
	TPCANStatus stsResult;
	int iBuffer;

	// Configures the message filter for a custom range of messages
	iBuffer = PCAN_FILTER_CLOSE;
	stsResult = SetValue(m_PcanHandle, PCAN_MESSAGE_FILTER, (void*)&iBuffer, sizeof(iBuffer));
	if (stsResult == PCAN_ERROR_OK) {
		stsResult = FilterMessages(m_PcanHandle, FromID, ToID, Mode);
	}
	return stsResult;

}

QString Hardware::GetFormatedError(TPCANStatus error)
{
	TPCANStatus status;
	char buffer[256];	
	QString result;

	memset(buffer,'\0',255);
	// Gets the text using the GetErrorText API function
	// If the function success, the translated error is returned. If it fails,
	// a text describing the current error is returned.
	//
	status = GetErrorText(error, 0, buffer);
	if(status != PCAN_ERROR_OK)
		result = "An error ocurred. Error-code's text couldn't be retrieved";
	else
		result = buffer;
	return result;
}

bool Hardware::GetFilterStatus(int* status)
{
	TPCANStatus stsResult;
	int qt_ret;
	QString qt_str;
	QMessageBox msgBox;

	// Tries to get the stataus of the filter for the current connected hardware
	//
	stsResult = GetValue(m_PcanHandle, PCAN_MESSAGE_FILTER, (void*)status, sizeof(int));

	// If it fails, a error message is shown
	//
	if (stsResult != PCAN_ERROR_OK)
	{
		qt_str = GetFormatedError(stsResult);
		msgBox.setText(qt_str);
		qt_ret = msgBox.exec();
		return false;
	}
	return true;
}

//2011/01/10	void Hardware::ProcessMessage(TPCANMsg MyMsg, TPCANTimestamp MyTimeStamp)
//2011/01/10	{
//2011/01/10	
//2011/01/10		int Check_ID = 0;
//2011/01/10		DWORD Curr_ID;
//2011/01/10		DWORD Curr_Count;
//2011/01/10	    QString qt_str_millis;
//2011/01/10	    QString qt_str_micros;
//2011/01/10		QString qt_str;
//2011/01/10		QString qt_str_data;
//2011/01/10	
//2011/01/10		// Recive Id
//2011/01/10		qt_str = ui.txtRcvId->text();
//2011/01/10		Curr_ID = qt_str.toULong(0,16);
//2011/01/10		if( MyMsg.ID == Curr_ID ){
//2011/01/10			Check_ID = 1;
//2011/01/10		} else { 
//2011/01/10			Check_ID = 0;
//2011/01/10		}
//2011/01/10	
//2011/01/10		// Recive Type
//2011/01/10		if( MyMsg.MSGTYPE == PCAN_MESSAGE_STANDARD ){
//2011/01/10			ui.txtRcvType->setText("Standard");
//2011/01/10			qt_str.sprintf("%03x", MyMsg.ID);
//2011/01/10			ui.txtRcvId->setText(qt_str);
//2011/01/10		} else if( MyMsg.MSGTYPE == PCAN_MESSAGE_EXTENDED ){
//2011/01/10			ui.txtRcvType->setText("Extended");
//2011/01/10			qt_str.sprintf("%08x", MyMsg.ID);
//2011/01/10			ui.txtRcvId->setText(qt_str);
//2011/01/10		} else {
//2011/01/10			ui.txtRcvType->setText("");
//2011/01/10		}
//2011/01/10	
//2011/01/10		// Recive Length
//2011/01/10		ui.txtRcvLen->setText(qt_str.setNum(MyMsg.LEN,16));
//2011/01/10	
//2011/01/10		// Recive Data
//2011/01/10		qt_str = "";
//2011/01/10		for(int i=0; i< 8; i++) {
//2011/01/10			qt_str_data.sprintf("%02x ", MyMsg.DATA[i]);
//2011/01/10			qt_str = qt_str + qt_str_data;
//2011/01/10		}
//2011/01/10		ui.txtRcvData->setText(qt_str);
//2011/01/10	
//2011/01/10		// Recive Count
//2011/01/10		if( Check_ID == 0 ){
//2011/01/10			ui.txtRcvCount->setText("1");
//2011/01/10		} else {
//2011/01/10			qt_str = ui.txtRcvCount->text();
//2011/01/10			Curr_Count = qt_str.toULong(0,10);
//2011/01/10			Curr_Count = Curr_Count + 1;
//2011/01/10			ui.txtRcvCount->setText(qt_str.setNum(Curr_Count,10));
//2011/01/10		}
//2011/01/10	
//2011/01/10		// Recive Time
//2011/01/10		if( ui.chbTimeStamp->isChecked() ){
//2011/01/10		    qt_str_millis.sprintf("%4d ", (WORD)MyTimeStamp.millis);
//2011/01/10		   	 qt_str_micros.sprintf("%03d ", MyTimeStamp.micros);
//2011/01/10			qt_str = qt_str_millis + "." + qt_str_micros;
//2011/01/10			ui.txtRcvTime->setText(qt_str);
//2011/01/10		} else { 
//2011/01/10			ui.txtRcvTime->setText("-");
//2011/01/10		}
//2011/01/10	
//2011/01/10	}

TPCANStatus Hardware::timRead(TPCANMsg* CANMsg, TPCANTimestamp* CANTimeStamp)
{
	TPCANStatus stsResult;
	QString	qt_str;

	// We execute the "Read" function of the PCANBasic                
	//
	stsResult = Read(m_PcanHandle, CANMsg, CANTimeStamp);
	if (stsResult == PCAN_ERROR_OK) {
		// We show the received message
		//
	} else if (stsResult == PCAN_ERROR_QRCVEMPTY) {
		// Receive queue is empty
		//
	} else {
		// If an error occurred, an information message is included
		//
		qt_str = GetFormatedError(stsResult);
		pInformation->Information_set("");
		pInformation->Information_append(qt_str);
	}

	return stsResult;

}
// HardwareInit
QString Hardware::HardwareInit(int mode, QString line)
{
	TPCANStatus stsResult;
	int selectedIO;
	int selectedInterrupt;

	int error_flag;
	int qt_ret;
	int index;
	QString	SelectData_Qstr;
	QString	qt_str;

	// Load Initialize Mode 
	if( mode == 0 ){
		QStringList coords = line.split(",");
		if( coords[0] == "1" ){
			error_flag = 0;
			// Parse Hardware
			SelectData_Qstr = coords[1];
			if( SelectData_Qstr == "DNG-Channel 1" ){ m_PcanHandle = PCAN_DNGBUS1;
			} else if( SelectData_Qstr == "ISA-Channel 1" ){ m_PcanHandle = PCAN_ISABUS1;
			} else if( SelectData_Qstr == "ISA-Channel 2" ){ m_PcanHandle = PCAN_ISABUS2;
			} else if( SelectData_Qstr == "ISA-Channel 3" ){ m_PcanHandle = PCAN_ISABUS3;
			} else if( SelectData_Qstr == "ISA-Channel 4" ){ m_PcanHandle = PCAN_ISABUS4;
			} else if( SelectData_Qstr == "ISA-Channel 5" ){ m_PcanHandle = PCAN_ISABUS5;
			} else if( SelectData_Qstr == "ISA-Channel 6" ){ m_PcanHandle = PCAN_ISABUS6;
			} else if( SelectData_Qstr == "ISA-Channel 7" ){ m_PcanHandle = PCAN_ISABUS7;
			} else if( SelectData_Qstr == "ISA-Channel 8" ){ m_PcanHandle = PCAN_ISABUS8;
			} else if( SelectData_Qstr == "PCC-Channel 1" ){ m_PcanHandle = PCAN_PCCBUS1;
			} else if( SelectData_Qstr == "PCC-Channel 2" ){ m_PcanHandle = PCAN_PCCBUS2;
			} else if( SelectData_Qstr == "PCI-Channel 1" ){ m_PcanHandle = PCAN_PCIBUS1;
			} else if( SelectData_Qstr == "PCI-Channel 2" ){ m_PcanHandle = PCAN_PCIBUS2;
			} else if( SelectData_Qstr == "PCI-Channel 3" ){ m_PcanHandle = PCAN_PCIBUS3;
			} else if( SelectData_Qstr == "PCI-Channel 4" ){ m_PcanHandle = PCAN_PCIBUS4;
			} else if( SelectData_Qstr == "PCI-Channel 5" ){ m_PcanHandle = PCAN_PCIBUS5;
			} else if( SelectData_Qstr == "PCI-Channel 6" ){ m_PcanHandle = PCAN_PCIBUS6;
			} else if( SelectData_Qstr == "PCI-Channel 7" ){ m_PcanHandle = PCAN_PCIBUS7;
			} else if( SelectData_Qstr == "PCI-Channel 8" ){ m_PcanHandle = PCAN_PCIBUS8;
			} else if( SelectData_Qstr == "USB-Channel 1" ){ m_PcanHandle = PCAN_USBBUS1;
			} else if( SelectData_Qstr == "USB-Channel 2" ){ m_PcanHandle = PCAN_USBBUS2;
			} else if( SelectData_Qstr == "USB-Channel 3" ){ m_PcanHandle = PCAN_USBBUS3;
			} else if( SelectData_Qstr == "USB-Channel 4" ){ m_PcanHandle = PCAN_USBBUS4;
			} else if( SelectData_Qstr == "USB-Channel 5" ){ m_PcanHandle = PCAN_USBBUS5;
			} else if( SelectData_Qstr == "USB-Channel 6" ){ m_PcanHandle = PCAN_USBBUS6;
			} else if( SelectData_Qstr == "USB-Channel 7" ){ m_PcanHandle = PCAN_USBBUS7;
			} else if( SelectData_Qstr == "USB-Channel 8" ){ m_PcanHandle = PCAN_USBBUS8;
			} else { m_PcanHandle = PCAN_NONEBUS;
			}
			qt_ret = ValueCheck(coords[2]);
			if( qt_ret == 1 ){
				error_flag = 1;
			} else {
				index = coords[2].toULong(0,16);
			}
			ui.cbbHws->setCurrentIndex(index); 
			// Parse Baudrates
			SelectData_Qstr = coords[3];
			if( SelectData_Qstr == "1 Mbit/sec" ){ m_Baudrate = PCAN_BAUD_1M;
			} else if( SelectData_Qstr == "500 KBit/sec" ){ m_Baudrate = PCAN_BAUD_500K;
			} else if( SelectData_Qstr == "250 KBit/sec" ){ m_Baudrate = PCAN_BAUD_250K;
			} else if( SelectData_Qstr == "125 KBit/sec" ){ m_Baudrate = PCAN_BAUD_125K;
			} else if( SelectData_Qstr == "100 KBit/sec" ){ m_Baudrate = PCAN_BAUD_100K;
			} else if( SelectData_Qstr == "50 KBit/sec"  ){ m_Baudrate = PCAN_BAUD_50K;
			} else if( SelectData_Qstr == "20 KBit/sec"  ){ m_Baudrate = PCAN_BAUD_20K;
			} else if( SelectData_Qstr == "10 KBit/sec"  ){ m_Baudrate = PCAN_BAUD_10K;
			} else if( SelectData_Qstr == "5 KBit/sec"   ){ m_Baudrate = PCAN_BAUD_5K;
			} else { m_Baudrate = PCAN_BAUD_500K;
			}
			qt_ret = ValueCheck(coords[4]);
			if( qt_ret == 1 ){
				error_flag = 1;
			} else {
				index = coords[4].toULong(0,16);
			}
			ui.cbbBaudrates->setCurrentIndex(index); 
			// Parse HardwareType
			m_HwType = PCAN_TYPE_ISA;
			// Parse IO
			SelectData_Qstr = coords[5];
			qt_ret = ValueCheck(coords[5]);
			if( qt_ret == 1 ){
				error_flag = 1;
			} else {
				selectedIO = SelectData_Qstr.toUInt(0,16);
			}
			qt_ret = ValueCheck(coords[6]);
			if( qt_ret == 1 ){
				error_flag = 1;
			} else {
				index = coords[6].toULong(0,16);
			}
			ui.cbbIO->setCurrentIndex(index); 
			// Parse Interrupt
			SelectData_Qstr = coords[7];
			qt_ret = ValueCheck(coords[7]);
			if( qt_ret == 1 ){
				error_flag = 1;
			} else {
				selectedInterrupt = SelectData_Qstr.toUInt(0,16);
			}
			qt_ret = ValueCheck(coords[8]);
			if( qt_ret == 1 ){
				error_flag = 1;
			} else {
				index = coords[8].toULong(0,16);
			}
			ui.cbbInterrupt->setCurrentIndex(index); 
			// Connects a selected PCAN-Basic channel
			if( error_flag == 0 ){
				stsResult = Initialize(m_PcanHandle, m_Baudrate, m_HwType, selectedIO, selectedInterrupt);
				if (stsResult != PCAN_ERROR_OK){
					qt_str = "Error: Hardware Initialize Not Creat!";
					qt_ret = QMessageBox::warning(this, tr("HardwareInit"),
													qt_str,
													QMessageBox::Yes | QMessageBox::Default);
				} else {
					// Hardware Reset
					stsResult = Reset(m_PcanHandle);
					if (stsResult != PCAN_ERROR_OK){
						qt_str = "Error: Hardware Reset Not Creat!";
						qt_ret = QMessageBox::warning(this, tr("HardwareInit"),
														qt_str,
														QMessageBox::Yes | QMessageBox::Default);
						if(m_hThread != NULL){
							TerminateThread(m_hThread, -1000);
							m_hThread = NULL;
						}
						Uninitialize(m_PcanHandle);
					} else {
						ui.btnInit->setText("Release");
						ui.cbbHws->setEnabled(false);
						ui.cbbBaudrates->setEnabled(false);
						ui.cbbMsgType->setEnabled(false);
						ui.cbbIO->setEnabled(false);
						ui.cbbInterrupt->setEnabled(false);
						ui.btnGetDevNumber->setEnabled(true);
						ui.btnSetDevNumber->setEnabled(true);
						ui.btnInfo->setEnabled(true);
						ui.btnDllInfo->setEnabled(true);
						ui.txtDevNumber->setEnabled(true);
					}
				}
				if( ui.cbbHws->currentText() == "ISA-Channel 1"
					|| ui.cbbHws->currentText() == "ISA-Channel 2"
					|| ui.cbbHws->currentText() == "ISA-Channel 3"
					|| ui.cbbHws->currentText() == "ISA-Channel 4"
					|| ui.cbbHws->currentText() == "ISA-Channel 5"
					|| ui.cbbHws->currentText() == "ISA-Channel 6"
					|| ui.cbbHws->currentText() == "ISA-Channel 7"
					|| ui.cbbHws->currentText() == "ISA-Channel 8" ){
					SelectData_Qstr = ui.cbbHws->currentText() + "  ";
					SelectData_Qstr = SelectData_Qstr + ui.cbbBaudrates->currentText() + "  ";
					SelectData_Qstr = SelectData_Qstr + ui.cbbMsgType->currentText() + "  ";
					SelectData_Qstr = SelectData_Qstr + ui.cbbIO->currentText() + " ";
//					SelectData_Qstr = SelectData_Qstr + ui.cbbInterrupt->currentText() + "  ";
				} else {
					SelectData_Qstr = ui.cbbHws->currentText() + "  ";
					SelectData_Qstr = SelectData_Qstr + ui.cbbBaudrates->currentText() + "  ";
//					SelectData_Qstr = SelectData_Qstr + ui.cbbMsgType->currentText() + "  ";
				}
				pFcanView->HardwareSetting("");
				pFcanView->statusBar_message(SelectData_Qstr);
				pFcanView->HardwareSetting(SelectData_Qstr);
			} else {
				qt_str = "Error: Hardware Initialize Illegal Value!";
				qt_ret = QMessageBox::warning(this, tr("HardwareInit"),
														qt_str,
														QMessageBox::Yes | QMessageBox::Default);
			}
		}
		SelectData_Qstr = "";
	// Save Initialize Mode 
	} else {
		// Initialize Button
		if( ui.btnInit->text() == "Initialize" ){
			SelectData_Qstr = "0,";
		} else {
			SelectData_Qstr = "1,";
		}
		// Hardware
		SelectData_Qstr = SelectData_Qstr + ui.cbbHws->currentText() + ",";
		qt_str.setNum(ui.cbbHws->currentIndex(),16);
		SelectData_Qstr = SelectData_Qstr + qt_str + ",";
		// Baudrates
		SelectData_Qstr = SelectData_Qstr + ui.cbbBaudrates->currentText() + ",";
		qt_str.setNum(ui.cbbBaudrates->currentIndex(),16);
		SelectData_Qstr = SelectData_Qstr + qt_str + ",";
		// IO
		SelectData_Qstr = SelectData_Qstr + ui.cbbIO->currentText() + ",";
		qt_str.setNum(ui.cbbIO->currentIndex(),16);
		SelectData_Qstr = SelectData_Qstr + qt_str + ",";
		// Interrupt
		SelectData_Qstr = SelectData_Qstr + ui.cbbInterrupt->currentText() + ",";
		qt_str.setNum(ui.cbbInterrupt->currentIndex(),16);
		SelectData_Qstr = SelectData_Qstr + qt_str + "\n";
	}

	return SelectData_Qstr;

}

// cbbHws
void Hardware::cbbHws_Changed( const QString &s )
{

	if( ui.cbbHws->currentText() == "ISA-Channel 1"
		|| ui.cbbHws->currentText() == "ISA-Channel 2"
		|| ui.cbbHws->currentText() == "ISA-Channel 3"
		|| ui.cbbHws->currentText() == "ISA-Channel 4"
		|| ui.cbbHws->currentText() == "ISA-Channel 5"
		|| ui.cbbHws->currentText() == "ISA-Channel 6"
		|| ui.cbbHws->currentText() == "ISA-Channel 7"
		|| ui.cbbHws->currentText() == "ISA-Channel 8" ){
		ui.cbbIO->setEnabled(true);
		ui.cbbInterrupt->setEnabled(true);
	} else {
		ui.cbbIO->setEnabled(false);
		ui.cbbInterrupt->setEnabled(false);
	}

}

int Hardware::ValueCheck(QString ValueString)
{
	int error_flag;
	int loop;
	int ValueLength;
	QString GetValue;

	error_flag = 1;
	ValueLength = ValueString.length();
	for( loop=0; loop<ValueLength; loop=loop+1 ){
		GetValue = ValueString[loop];
		if( "0" == GetValue ){        error_flag = 0;
		} else if( "1" == GetValue ){ error_flag = 0;
		} else if( "2" == GetValue ){ error_flag = 0;
		} else if( "3" == GetValue ){ error_flag = 0;
		} else if( "4" == GetValue ){ error_flag = 0;
		} else if( "5" == GetValue ){ error_flag = 0;
		} else if( "6" == GetValue ){ error_flag = 0;
		} else if( "7" == GetValue ){ error_flag = 0;
		} else if( "8" == GetValue ){ error_flag = 0;
		} else if( "9" == GetValue ){ error_flag = 0;
		} else if( "a" == GetValue ){ error_flag = 0;
		} else if( "b" == GetValue ){ error_flag = 0;
		} else if( "c" == GetValue ){ error_flag = 0;
		} else if( "d" == GetValue ){ error_flag = 0;
		} else if( "e" == GetValue ){ error_flag = 0;
		} else if( "f" == GetValue ){ error_flag = 0;
		} else if( "A" == GetValue ){ error_flag = 0;
		} else if( "B" == GetValue ){ error_flag = 0;
		} else if( "C" == GetValue ){ error_flag = 0;
		} else if( "D" == GetValue ){ error_flag = 0;
		} else if( "E" == GetValue ){ error_flag = 0;
		} else if( "F" == GetValue ){ error_flag = 0;
		} else {
			error_flag = 1;
			break;
		}
	}
	return error_flag;

}
////////////////////////////////////////
// Setting Menu
////////////////////////////////////////
void Hardware::createMenus()
{
	QMenu   * pMenu;

	//File Menu
	pMenu = ui.menuBar->addMenu( tr("File") );
	SettingMenu.pMenu = pMenu;
    connect(pMenu, SIGNAL(aboutToShow()), this, SLOT(menu_triggered()));

	createMenuActions();

}
void Hardware::createMenuActions()
{
	QAction * pAction;
	QString qt_str;

	/* Clear */
	SettingMenu.pMenu->clear( );
	
	/* Load File */
	pAction = new QAction( tr("Open Setting File"), this );
	SettingMenu.pMenu->addAction( pAction );
	SettingMenu.pLoadFile = pAction;
	SettingMenu.pLoadFile->setShortcut(tr("Ctrl+O"));
    connect(SettingMenu.pLoadFile, SIGNAL(triggered()), this, SLOT(menu_loadfile()));

	/* Save File */
	pAction = new QAction( tr("Save Setting File"), this );
	SettingMenu.pMenu->addAction( pAction );
	SettingMenu.pSaveFile = pAction;
	SettingMenu.pSaveFile->setShortcut(tr("Ctrl+S"));
    connect(SettingMenu.pSaveFile, SIGNAL(triggered()), this, SLOT(menu_savefile()));

}

////////////////////////////////////////
// Menu Action
////////////////////////////////////////
void Hardware::menu_triggered()
{
	createMenuActions();
}
void Hardware::menu_loadfile()
{
	DWORD loop;
	QString qt_str;
	QString line;
	QString qt_ret;

	// File Select
	QString fileName = QFileDialog::getOpenFileName(
														this,
					   									tr("Load File"),		// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter

	// File Open
	QFile LoadFile(fileName);

	// File Read
	if (LoadFile.open(QIODevice::ReadOnly)) {
		QTextStream in(&LoadFile);
		line = in.readLine();
		// Load Setting
		qt_ret = HardwareInit(0, line);
		// File Close
		LoadFile.close();
		// File Close
		pInformation->Information_append("Load File open successfully");
	} else {
		pInformation->Information_append("Can not open load file");
	}

}
void Hardware::menu_savefile()
{
	DWORD loop;
	DWORD loop_max;
	QString qt_str;
	QString line;

	// File Select
	QString fileName = QFileDialog::getSaveFileName(
														this,
					   									tr("Save File"),		// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter

	// File Open
	QFile SaveFile(fileName);

	// File Write
	if(SaveFile.open(QIODevice::WriteOnly)) {
		QTextStream outputfile(&SaveFile);
		qt_str = "";
		line = HardwareInit(1,qt_str);
		outputfile << line;
		// File Close
		SaveFile.close();
		// File Close
		pInformation->Information_append("Save File successfully");
	} else {
		pInformation->Information_append("Can not open save file");
	}

}


