#ifndef INITFILE_H
#define INITFILE_H

#include <QtGui>
#include <QWidget>
#include "ui_initfile.h"

#include "hardware.h"
#include "rxdatafilter.h"
#include "rxdataformat.h"
#include "txdata.h"
#include "information.h"

class FCAN_View;

class InitFile : public QWidget
{
	Q_OBJECT

public:
	InitFile(QWidget *parent = 0);
	~InitFile();

	void HardwareSet( Hardware * hardware );
	void RxDataFilterSet( RxDataFilter * rxdatafilter );
	void RxDataFormatSet( RxDataFormat * rxdataformat );
	void TxDataSet( TxData * txdata );
	void InformationSet( Information * information );
	void FcanViewSet( FCAN_View * fcanview );


private slots:
	// Close
	void closeEvent( QCloseEvent * event );
	// btnInitLoadFileFind
	void btnInitLoadFileFind_Click();
	// btnInitLoad
	void btnInitLoad_Click();
	// btnInitSaveFileFind
	void btnInitSaveFileFind_Click();
	// btnInitSaveFile
	void btnInitSaveFile_Click();


private:
	Ui::InitFile ui;

	Hardware * pHardware;
	RxDataFilter * pRxDataFilter;
	RxDataFormat * pRxDataFormat;
	TxData * pTxData;
	Information * pInformation;
	FCAN_View * pFcanView;


};

#endif // INITFILE_H
