#include "fcan_view.h"
#include <QtGui/QApplication>


#include "initfile.h"
#include "hardware.h"
#include "rxdata.h"
#include "txdata.h"
#include "rxdataformat.h"
#include "rxdatafilter.h"
#include "graph.h"
#include "plotter.h"
#include "information.h"
#include "SysConfig.h"
#include "CanData.h"
#include "CanFrame.h"

int main(int argc, char *argv[])
{
//	QApplication a(argc, argv);
//	FcanView w;
//	w.show();
//	return a.exec();

	QApplication app( argc, argv );

	FCAN_View pFcanView;
	SysConfig  sysconfig;
	InitFile initfile;
	Hardware hardware;
	RxData rxdata;
	TxData txdata;
	RxDataFormat rxdataformat;
	RxDataFilter rxdatafilter;
	Graph graph;
	Plotter plotter;
	PlotSettings plotsettings;
	Information information;
	CanData candata;
	CanDataMng data( sysconfig.canDataBuffNum() );
	CanFrame canframe;

	pFcanView.GraphNumber = 0;

	pFcanView.SysConfigSet( & sysconfig );
	pFcanView.InitFileSet( & initfile );
	pFcanView.HardwareSet( & hardware );
	pFcanView.RxDataSet( & rxdata );
	pFcanView.TxDataSet( & txdata );
	pFcanView.RxDataFormatSet( & rxdataformat );
	pFcanView.RxDataFilterSet( & rxdatafilter );
	pFcanView.GraphSet( & graph );
	pFcanView.PlotterSet( & plotter );
	pFcanView.PlotSettingsSet( & plotsettings );
	pFcanView.InformationSet( & information );
	pFcanView.CanDataSet( & candata );
	pFcanView.CanDataMngSet( &data );
	pFcanView.CanFrameSet( & canframe );



	pFcanView.Start();

//	mainWindow.canDataMngSet( &data );

	pFcanView.show();
	return app.exec();


}
