#ifndef PLOTTER_H
#define PLOTTER_H

#include <QtGui>
#include <QWidget>
#include <QMap>
#include <QPixmap>
#include <QVector>
#include "ui_plotter.h"

class QToolButton;
class PlotSettings;
class FCAN_View;
class Graph;
class QAction;
class QMenu;

class Plotter : public QWidget
{
	Q_OBJECT

public:
	Plotter(QWidget *parent = 0);
	~Plotter();

    void setPlotSettings(const PlotSettings &settings);
    void setCurveData(int id, const QVector<QPointF> &data);
    void clearCurve(int id);
    void PlotterStart();
	void FcanViewSet( FCAN_View * fcanview );
	void GraphSet( Graph * graph );
	void PlotSettingsSet( PlotSettings * plotsettings );
	void PlotterRighView();
	void GraphNameSet();

    QSize minimumSizeHint() const;
    QSize sizeHint() const;

public slots:
    void zoomIn();
    void zoomOut();
	void menu_triggered( );
	void menu_setting( );
	void menu_startstop( );
	void menu_viewendpoint( );
	void menu_print( );
	void closeEvent( QCloseEvent * event );

protected:
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void keyPressEvent(QKeyEvent *event);
    void wheelEvent(QWheelEvent *event);

private:
	Ui::Plotter ui;

    void updateRubberBandRegion();
    void refreshPixmap();
    void drawGrid(QPainter *painter);
    void drawCurves(QPainter *painter);
    QString TimeCalc(double time);
    void EndScroll();
	void createMenus();
	void createMenuActions();

    enum { Margin = 50 };
    enum { MarginH = 60 };
	int MarginX;
	int GraphCount;
	int TimeMode;
	int Graph1Yaxis;

    QToolButton *zoomInButton;
    QToolButton *zoomOutButton;
	QLabel *lblZoom;

    QMap<int, QVector<QPointF> > curveMap;
    QVector<PlotSettings> zoomStack;
    int curZoom;
    bool rubberBandIsShown;
    QRect rubberBandRect;
    QPixmap pixmap;
	FCAN_View * pFcanView;
	Graph * pGraph;
	PlotSettings * pPlotSettings;

	struct {
		QMenu * pMenu;
		QAction * pSetting;
		QAction * pPrint;
	} SettingMenu;

	struct {
		QMenu * pMenu;
		QAction * pStartStop;
		QAction * pViewEndPoint;
	} GraphMenu;

};

class PlotSettings
{
public:
    PlotSettings();

    void scroll(int dx, int dy);
    void adjust();
    double spanX() const { return maxX - minX; }
    double spanY1() const { return maxY[1] - minY[1]; }
    double spanY2() const { return maxY[2] - minY[2]; }
    double spanY3() const { return maxY[3] - minY[3]; }
    double spanY4() const { return maxY[4] - minY[4]; }
    double spanY5() const { return maxY[5] - minY[5]; }

    double minX;
    double maxX;
    int numXTicks;
    double minY[6];
    double maxY[6];
    int numYTicks;
    double zoomSize;

private:
    static void adjustAxis(double &min, double &max, int &numTicks);
};

#endif // PLOTTER_H
