#ifndef RXDATA_H
#define RXDATA_H

#include <QtGui>
#include <QWidget>
#include <qtimer.h>
#include "ui_rxdata.h"
#include "hardware.h"
#include "information.h"
#include "rxdatafilter.h"
#include "SysConfig.h"
#include "CanData.h"
#include "PCANBasic.h"

class FCAN_View;

class RxData : public QWidget
{
	Q_OBJECT

public:
	RxData(QWidget *parent = 0);
	~RxData();

	void SysConfigSet( SysConfig * sysconfig );
	void HardwareSet( Hardware * hardware );
	void RxDataFilterSet( RxDataFilter * rxdatafilter );
	void InformationSet( Information * information );
	void CanDataSet( CanData * candata );
	void CanDataMngSet( CanDataMng * candatamng );
	void FcanViewSet( FCAN_View * fcanview );

private slots:
	// btnReadStart
	void btnRxStartStop_Click();
	// btnReadFileFind
	void btnRxDataFind_Click();
	// chbViewReport
	void chbViewReport_Toggled();
	// Timer
	void timRead();
	// Timer
	void timDisplay();
	// Close
	void closeEvent( QCloseEvent * event );
	// resizeEvent
    void resizeEvent(QResizeEvent *event);

private:
	Ui::RxData ui;

	SysConfig * pSysConfig;
	Hardware * pHardware;
	RxDataFilter * pRxDataFilter;
	Information * pInformation;
	CanData * pCanData;
	CanDataMng * pCanDataMng;
	FCAN_View * pFcanView;

	// Read Messages
	TPCANStatus Read_Message(TPCANMsg* MessageBuffer, TPCANTimestamp* TimestampBuffer);
	// Read Messages File Write
	void RxDataFileWrite(DWORD Count);
	// Read Messages Control
	void ProcessMessage(TPCANMsg MyMsg, TPCANTimestamp MyTimeStamp);
	// Read Messages Time 
	void RxDataTime(TPCANTimestamp MyTimeStamp);

	// Timer
	QTimer	*ReadTimer;
	QTimer	*DisplayTimer;

	DWORD MessageCountNow;
	DWORD DisplayMessageCountNow;
	DWORD RcvMessageCountMax;
	DWORD DefaultTimeMillis;
	WORD DefaultTimeMicros;
	DWORD RxDataTimeMillis;
	WORD RxDataTimeMicros;
	int TimeGetFlag;
	QString RcvCountMax_str;


};

#endif // RXDATA_H
