#include <QtGui>
#include <qstring.h>
#include "rxdataformat.h"
#include "information.h"
#include "CanFrame.h"
#include "fcan_view.h"

RxDataFormat::RxDataFormat(QWidget *parent)
	: QWidget(parent)
{
	ui.setupUi(this);
	hide();

	pCanFrame = NULL;
	pInformation = NULL;
	pFcanView = NULL;

	// btnSetFormat
	connect( ui.btnSetFormat,SIGNAL(clicked()),this,SLOT(btnSetFormat_Click()));
	// btnOverWriteFormat
	connect( ui.btnOverWriteFormat,SIGNAL(clicked()),this,SLOT(btnOverWriteFormat_Click()));
	// btnDeleteFormat
	connect( ui.btnDeleteFormat,SIGNAL(clicked()),this,SLOT(btnDeleteFormat_Click()));
	// btnDeleteAllFormat
	connect( ui.btnDeleteAllFormat,SIGNAL(clicked()),this,SLOT(btnDeleteAllFormat_Click()));
	// tblView_CellClickd
    connect(ui.tblView, SIGNAL(cellClicked(int, int)), this, SLOT(tblView_CellClicked(int, int)) );
	// tblView_CellDoubleClickd
    connect(ui.tblView, SIGNAL(cellDoubleClicked(int, int)), this, SLOT(tblView_CellDoubleClicked(int, int)) );

	FormatLoadSettingMode = "0";
	FormatLoadSettingName = "none";

	ui.btnSetFormat->setEnabled(true);
	ui.txtNodeId->setEnabled(true);
	ui.txtNodeName->setEnabled(true);
	ui.txtCobId->setEnabled(true);
	ui.txtCobIdName->setEnabled(true);
	ui.cbbDataType->setEnabled(true);
	ui.txtItemNo->setEnabled(true);
	ui.txtName->setEnabled(true);
	ui.txtOffset->setEnabled(true);
	ui.txtLength->setEnabled(true);
	ui.txtDenomination->setEnabled(true);
	ui.txtAmplification->setEnabled(true);
	ui.txtDataOffset->setEnabled(true);

	// Menu Init
	createMenus();

}

RxDataFormat::~RxDataFormat()
{

}
////////////////////////////////////////
// Pointer Setting
////////////////////////////////////////
void RxDataFormat::CanFrameSet( CanFrame * canframe )
{
	pCanFrame = canframe;
}
void RxDataFormat::InformationSet( Information * information )
{
	pInformation = information;
}
void RxDataFormat::FcanViewSet( FCAN_View * fcanview )
{
	pFcanView = fcanview;
}
////////////////////////////////////////
// RxDataFormat Function
////////////////////////////////////////
// Close
void RxDataFormat::closeEvent(QCloseEvent * pEvent)
{
	pFcanView->ViewWindow[4] = false;
	pFcanView->ViewWindow[7] = false;
}
void RxDataFormat::resizeEvent(QResizeEvent * /* event */)
{
	ui.tblView->resize(851 + (width() - 870),161 + (height() - 290));
}
void RxDataFormat::keyPressEvent(QKeyEvent *event)
{
	switch (event->key()) {
	case Qt::Key_Delete:
		DelFormat();
		break;
	default:
		QWidget::keyPressEvent(event);
	}
}
// btnSetFormat
void RxDataFormat::btnSetFormat_Click()
{
	int node;
	int func;
	int item;
	int offset;
	int data_type;
	int len;
	int tmp;
	int ret;
	int node_null_check;
	int cob_null_check;
	int cancel_check;
	float amp;
	float data_offset;
	QString qt_str;
	QString qt_str_node;
	QString qt_str_func;
	QString qt_str_name;
	QString qt_str_denomi;
	QTableWidgetItem * pItem;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;

	node_null_check = 0;
	cob_null_check = 0;
	cancel_check = 0;

	// Node/Cobid Get
	qt_str = ui.txtNodeId->text();
	node = qt_str.toUInt(0,16);
	qt_str_node = ui.txtNodeName->text();

	qt_str = ui.txtCobId->text();
	func = qt_str.toUInt(0,16);
	qt_str_func = ui.txtCobIdName->text();

	// Node Add
	pNode = pCanFrame->nodeSearch( node );
	if( pNode == NULL ){
		node_null_check = 1;
		cob_null_check = 1;
	} else {
		qt_str = pNode->name;
		if( qt_str != qt_str_node ){
			qt_str = "Do you change Node Name? old name(" + qt_str + ") -> new name(" + qt_str_node + ")\n";
			qt_str = qt_str + "Because there is the same NodeID, should I make it OverWrite movement?";

			ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
										qt_str,
										QMessageBox::Yes,
										QMessageBox::No | QMessageBox::Default);
			if( ret == QMessageBox::Yes ){
			} else {
				cancel_check = 1;
			}
		}
	}
	// CobId Add
	if(( cancel_check == 0 ) && ( node_null_check == 0 )){
		pNode = pCanFrame->nodeSearch( node );
		pFunction = pNode->functionSearch( func );
		if( pFunction == NULL ){
			cob_null_check = 1;
		} else {
			qt_str = pFunction->m_name;
			if( qt_str != qt_str_func ){
				qt_str = "Do you change CobID Name? old name(" + qt_str + ") -> new name(" + qt_str_func + ")\n";
				qt_str = qt_str + "Because there is the same CobID, should I make it OverWrite movement?";
				ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
											qt_str,
											QMessageBox::Yes,
											QMessageBox::No | QMessageBox::Default);
				if( ret == QMessageBox::Yes ){
				} else {
					cancel_check = 1;
				}
			}
		}
	}
	// Item Add
	if( cancel_check == 0 ){
		if( node_null_check == 1 ){
			pCanFrame->nodeAdd( node, qt_str_node );
		} else {
			pNode->name = qt_str_node;
		}
		pNode = pCanFrame->nodeSearch( node );
		pFunction = pNode->functionSearch( func );
		if( cob_null_check == 1 ){
			pNode->functionAdd( func, qt_str_func );
		} else {
			pFunction->m_name = qt_str_func;
		}

		qt_str = ui.txtItemNo->text();
		item = qt_str.toUInt(0,10);

		qt_str = ui.txtName->text();
		qt_str_name = qt_str;

		qt_str = ui.txtOffset->text();
		offset = qt_str.toUInt(0,10);

		qt_str = ui.txtLength->text();
		len = qt_str.toUInt(0,10);

		// Data Type Select
		data_type = ui.cbbDataType->currentIndex();
		qt_str.sprintf("%1d", data_type );

		qt_str = ui.txtDenomination->text();
		qt_str_denomi = qt_str;

		qt_str = ui.txtAmplification->text();
		amp = qt_str.toFloat();

		qt_str = ui.txtDataOffset->text();
		data_offset = qt_str.toFloat();

		pFunction = pNode->functionSearch( func );
		pFormat = pFunction->formatGet( item );
		if( pFormat == NULL ){
			if( data_type == 0 ){
				pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (float)amp, (float)data_offset );
			} else if( data_type == 1 ){
//				pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (unsigned long long)amp, (unsigned long long)data_offset );
				pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (float)amp, (unsigned long long)data_offset );
			} else {
//				pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (long long)amp, (long long)data_offset );
				pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (float)amp, (long long)data_offset );
			}
			ret = pFunction->formatAdd( pFormat );
		} else {
			pFormat->no = item;
			pFormat->name = qt_str_name;
			pFormat->bitOffset = offset;
			pFormat->bitLen = len;
			pFormat->denomination = qt_str_denomi;
			if( data_type == 0 ){
				pFormat->format.f.offset = (float)data_offset;
				pFormat->format.f.amplification = (float)amp;
				pFormat->type = CAN_FORMAT_TYPE_FLOAT;
			} else if( data_type == 1 ){
				pFormat->format.u.offset = (unsigned long long)data_offset;
//				pFormat->format.u.amplification = (unsigned long long)amp;
				pFormat->format.u.amplification = (float)amp;
				pFormat->type = CAN_FORMAT_TYPE_UINT;
			} else {
				pFormat->format.i.offset = (long long)data_offset;
//				pFormat->format.i.amplification = (long )amp;
				pFormat->format.i.amplification = (float)amp;
				pFormat->type = CAN_FORMAT_TYPE_INT;
			}
		}
	}

	if( cancel_check == 0 ){
		ViewFormat();
//		pInformation->Information_set("");
		pInformation->Information_append("Format Set was successfully");
	} else {
//		pInformation->Information_set("");
		pInformation->Information_append("Format Set was Cancel!");
	}

}
// btnOverWriteFormat
void RxDataFormat::btnOverWriteFormat_Click()
{
	int lp;
	int tmp;
	int node;
	int func;
	int item;
	int len;
	int row;
	int row_max;
	int over_write_check;
//	int null_check;
//	int func_num;
//	int item_num;
	int ret;
	QString qt_str;
	QString qt_str_node;
	QString qt_str_func;
	QString qt_str_name;

	QTableWidgetItem * pItem;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;


//	null_check = 0;
	over_write_check = 0;
	row = ui.tblView->currentRow();
	row_max = ui.tblView->rowCount();


	// OverWriteCheck
	// Same NodeID/CobID/ItemNo Check
	qt_str = ui.txtNodeId->text();
	node = qt_str.toUInt(0,16);
	qt_str_node = ui.txtNodeName->text();

	qt_str = ui.txtCobId->text();
	func = qt_str.toUInt(0,16);
	qt_str_func = ui.txtCobIdName->text();

	qt_str = ui.txtItemNo->text();
	item = qt_str.toUInt(0,10);
	qt_str_name = ui.txtName->text();

	for( lp=0; lp<row_max; lp=lp+1 ){
		// Node Get
		pItem = ui.tblView->item(lp, 2);
		qt_str = pItem->text();
		tmp = qt_str.toUInt(0,16);
		if( node == tmp ){
			// CobID Get
			pItem = ui.tblView->item(lp, 0);
			qt_str = pItem->text();
			tmp = qt_str.toUInt(0,16);
			if( func == tmp ){
				// Item Get
				pItem = ui.tblView->item(lp, 4);
				qt_str = pItem->text();
				tmp = qt_str.toUInt(0,10);
				if( item == tmp ){
					if( row != lp ){
						qt_str.sprintf("%d", (lp+1));
						qt_str = "Same CobID/NodeID/ItenNo(RowItem = " + qt_str + ") exists. May I delete it?";
						ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
													qt_str,
													QMessageBox::Yes,
													QMessageBox::No | QMessageBox::Default);
						if( ret == QMessageBox::Yes ){
							ui.tblView->removeRow(lp);
							row_max = row_max - 1;
							if( row > lp ){
								row = row - 1;
							}
							// Delete Item
							pNode = pCanFrame->nodeSearch( node );
							pFunction = pNode->functionSearch( func );
							pFunction->formatDeleteItem( item );
							if( pFunction->formatNum( ) == 0 ){
								pNode->functionDeleteFunc( func );
								if( pNode->functionNum( ) == 0 ){
									pCanFrame->nodeDeleteId( node );
								}
							}
						} else {
							over_write_check = over_write_check + 1;
						}
					}
				}
			}
		}
	}


	// Node Check
	if( over_write_check == 0 ){
		for( lp=0; lp<row_max; lp=lp+1 ){
			pItem = ui.tblView->item(lp, 2);
			qt_str = pItem->text();
			tmp = qt_str.toUInt(0,16);
			if( node == tmp ){
				pItem = ui.tblView->item(lp, 3);
				qt_str = pItem->text();
				if(( lp != row ) && ( qt_str != qt_str_node )){
					qt_str = "Do you change Node Name? old name(" + qt_str + ") -> new name(" + qt_str_node + ")\n";
					qt_str = qt_str + "Should the list with the other same NodeID be changed, too?";
					ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
												qt_str,
												QMessageBox::Yes,
												QMessageBox::No | QMessageBox::Default);
					if( ret == QMessageBox::Yes ){
					} else {
						over_write_check = over_write_check + 1;
					}
					break;
				}
			}
		}
	}
//	// Node Check
//	if( over_write_check == 0 ){
//		pNode = pCanFrame->nodeSearch( node );
//		if( pNode == NULL ){
//			null_check = 1;
//		} else {
//			qt_str = pNode->name;
//			func_num = pNode->functionNum( );
//			pFunction = pNode->functionSearch( func );
//			if( pFunction == NULL ){
//				item_num = 0;
//			} else {
//				item_num = pFunction->formatNum( );
//			}
//
//			if(( qt_str != qt_str_node ) && (( func_num != 1 ) || ( item_num != 1 ))){
//				qt_str = "Do you change Node Name? old name(" + qt_str + ") -> new name(" + qt_str_node + ")\n";
//				qt_str = qt_str + "Should the list with the other same NodeID be changed, too?";
//				ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
//											qt_str,
//											QMessageBox::Yes,
//											QMessageBox::No | QMessageBox::Default);
//				if( ret == QMessageBox::Yes ){
//				} else {
//					over_write_check = over_write_check + 1;
//				}
//			}
//		}
//	}

	// CobId Check
	if( over_write_check == 0 ){
		for( lp=0; lp<row_max; lp=lp+1 ){
			pItem = ui.tblView->item(lp, 2);
			qt_str = pItem->text();
			tmp = qt_str.toUInt(0,16);
			if( node == tmp ){
				pItem = ui.tblView->item(lp, 0);
				qt_str = pItem->text();
				tmp = qt_str.toUInt(0,16);
				if( func == tmp ){
					pItem = ui.tblView->item(lp, 1);
					qt_str = pItem->text();
					if(( lp != row ) && ( qt_str != qt_str_func )){
						qt_str = "Do you change CobID Name? old name(" + qt_str + ") -> new name(" + qt_str_func + ")\n";
						qt_str = qt_str + "Should the list with the other same CobID be changed, too?";
						ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
													qt_str,
													QMessageBox::Yes,
													QMessageBox::No | QMessageBox::Default);
						if( ret == QMessageBox::Yes ){
						} else {
							over_write_check = over_write_check + 1;
						}
						break;
					}
				}
			}
		}
	}
//	// CobId Check
//	if(( null_check == 0 ) && ( over_write_check == 0 )){
//		pFunction = pNode->functionSearch( func );
//		if( pFunction == NULL ){
//			null_check = 1;
//		} else {
//			qt_str = pFunction->m_name;
//			item_num = pFunction->formatNum( );
//
//			if(( qt_str != qt_str_func ) && ( item_num != 1 )){
//				qt_str = "Do you change CobID Name? old name(" + qt_str + ") -> new name(" + qt_str_func + ")\n";
//				qt_str = qt_str + "Should the list with the other same CobID be changed, too?";
//				ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
//											qt_str,
//											QMessageBox::Yes,
//											QMessageBox::No | QMessageBox::Default);
//				if( ret == QMessageBox::Yes ){
//				} else {
//					over_write_check = over_write_check + 1;
//				}
//			}
//		}
//	}
	// Item Check
//	if(( null_check == 0 ) && ( over_write_check == 0 )){
//		pFormat = pFunction->formatGet( item );
//		if( pFormat == NULL ){
//		} else {
//			qt_str = pFormat->name;
//			if( qt_str != qt_str_name ){
//				qt_str = "Do you change Item Name? old name(" + qt_str + ") -> new name(" + qt_str_name + ")";
//				ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
//											qt_str,
//											QMessageBox::Yes,
//											QMessageBox::No | QMessageBox::Default);
//				if( ret == QMessageBox::Yes ){
//				} else {
//					over_write_check = over_write_check + 1;
//				}
//			}
//		}
//	}

	if( over_write_check != 0 ){
		// OverWriteCheck=NG

//		pInformation->Information_set("");
		pInformation->Information_append("Format OverWrite was Cancel");

	} else {
		// OverWriteCheck=OK

		// Node/CobID/Item Change
		for( lp=0; lp<row_max; lp=lp+1 ){
			// Node Change
			pItem = ui.tblView->item(lp, 2);
			qt_str = pItem->text();
			tmp = qt_str.toUInt(0,16);
			if( node == tmp ){
				pItem = ui.tblView->item(lp, 3);
				pItem->setText(qt_str_node);
				// CobID Change
				pItem = ui.tblView->item(lp, 0);
				qt_str = pItem->text();
				tmp = qt_str.toUInt(0,16);
				if( func == tmp ){
					pItem = ui.tblView->item(lp, 1);
					pItem->setText(qt_str_func);
					// Item Change
					pItem = ui.tblView->item(lp, 4);
					qt_str = pItem->text();
					tmp = qt_str.toUInt(0,10);
					if( item == tmp ){
						pItem = ui.tblView->item(lp, 5);
						pItem->setText(qt_str_func);
					}
				}
			}
		}

//		// FormatDelete
//		pItem = ui.tblView->item(row, 2);
//		qt_str = pItem->text();
//		node = qt_str.toUInt(0,16);
//		pNode = pCanFrame->nodeSearch( node );
//
//		pItem = ui.tblView->item(row, 0);
//		qt_str = pItem->text();
//		func = qt_str.toUInt(0,16);
//		pFunction = pNode->functionSearch( func );
//
//		pItem = ui.tblView->item(row, 4);
//		qt_str = pItem->text();
//		item = qt_str.toUInt(0,16);
//
//		pFunction->formatDeleteItem( item );
//		if( pFunction->formatNum( ) == 0 ){
//			if( pNode->functionNum( ) == 1 ){
//				pNode->functionDelete( func );
//				if( pCanFrame->nodeNum( ) == 1 ){
//					pCanFrame->nodeDelete( node );
//				}
//			}
//		}

		// Item OverWrite Copy
		pItem = ui.tblView->item(row, 0);
		pItem->setText(ui.txtCobId->text());
		pItem = ui.tblView->item(row, 1);
		pItem->setText(ui.txtCobIdName->text());
		pItem = ui.tblView->item(row, 2);
		pItem->setText(ui.txtNodeId->text());
		pItem = ui.tblView->item(row, 3);
		pItem->setText(ui.txtNodeName->text());
		pItem = ui.tblView->item(row, 4);
		pItem->setText(ui.txtItemNo->text());
		pItem = ui.tblView->item(row, 5);
		pItem->setText(ui.txtName->text());
		pItem = ui.tblView->item(row, 6);
		pItem->setText(ui.txtOffset->text());
		pItem = ui.tblView->item(row, 7);
		pItem->setText(ui.txtLength->text());
		pItem = ui.tblView->item(row, 8);
		if( ui.cbbDataType->currentIndex() == 0 ){
			pItem->setText("FLOAT");
		} else if( ui.cbbDataType->currentIndex() == 1 ){
			pItem->setText("UINT");
		} else {
			pItem->setText("INT");
		}
		pItem = ui.tblView->item(row, 9);
		pItem->setText(ui.txtDenomination->text());
		pItem = ui.tblView->item(row, 10);
		pItem->setText(ui.txtAmplification->text());
		pItem = ui.tblView->item(row, 11);
		pItem->setText(ui.txtDataOffset->text());

		DelFormatAll();
		ViewFormatWrite();
		ui.tblView->selectRow(row);
		ui.tblView->resizeColumnsToContents();
		ui.tblView->resizeRowsToContents();

//		pInformation->Information_set("");
		pInformation->Information_append("Format OverWrite was successfully");

	}

}
// btnDeleteFormat
void RxDataFormat::btnDeleteFormat_Click()
{
	DelFormat();
}
// btnDeleteAllFormat
void RxDataFormat::btnDeleteAllFormat_Click()
{
	QString qt_str;

	qt_str = "Do you really All delete Format ?";
	int qt_ret = QMessageBox::warning(this, tr("RxDataAllFormatDelate"),
										qt_str,
										QMessageBox::Yes,
										QMessageBox::No | QMessageBox::Default);
	if( qt_ret == QMessageBox::Yes ){
		DelFormatAll();
		ViewFormat();
	}
}
// RxDataFormatInit
QString RxDataFormat::RxDataFormatInit(int mode, QString line)
{
	QString qt_str;
	QString qt_str_node;
	QString qt_str_func;
	QString qt_str_name;
	QString qt_str_denomi;
	int node;
	int func;
	int item;
	int offset;
	int data_type;
	int len;
	float amp;
	float data_offset;
	int ret;
	int error_flag;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;
	QString str;
	QString str_name;
	QString qt_ret;
	QMessageBox msgBox;

	error_flag = 0;

	// Load Initialize Mode 
	if( mode == 0 ){
		DelFormatAll();
		QStringList coords = line.split(",");
		if( coords[0] == "1" ){
			// File Name
			qt_str = coords[1];
			QFile FormatFile(qt_str);
			FormatLoadSettingMode = "1";
			FormatLoadSettingName = qt_str;

			if (FormatFile.open(QIODevice::ReadOnly)) {
				QTextStream in(&FormatFile);
				while (!in.atEnd()) {
					QString line = in.readLine();
					QStringList coords = line.split(",");
					qt_str = coords[0];
					if( qt_str[0] != '#' ){
						// Node Add
						ret = ValueCheck(coords[2]);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							node = coords[2].toUInt(0,16);
							str = coords[3];
							pNode = pCanFrame->nodeSearch( node );
							if( pNode == NULL ){
								pCanFrame->nodeAdd( node, str );
							}
							pNode = pCanFrame->nodeSearch( node );
						}
						// Function Add
						ret = ValueCheck(coords[0]);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							func = coords[0].toUInt(0,16);
							str = coords[1];
							pFunction = pNode->functionSearch( func );
							if( pFunction == NULL ){
								pNode->functionAdd( func, str );
							}
						}
						// Data Type Select
						ret = ValueCheck(coords[8]);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							data_type = coords[8].toUInt(0,16);
						}
						// Item Add
						ret = ValueCheck(coords[4]);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							item = coords[4].toUInt(0,10);
						}
						str_name = coords[5];
						ret = ValueCheck(coords[6]);
						if( ret == 1 ){
							error_flag = 1;
						} else {
						offset = coords[6].toUInt(0,10);
						}
						ret = ValueCheck(coords[7]);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							len = coords[7].toUInt(0,10);
						}
						str = coords[9];
						ret = ValueCheck(coords[10]);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							amp = coords[10].toFloat();
						}
						ret = ValueCheck(coords[11]);
						if( ret == 1 ){
							error_flag = 1;
						} else {
							data_offset = coords[11].toFloat();
						}
						if( error_flag == 0 ){
							pFunction = pNode->functionSearch( func );
							pFormat = pFunction->formatGet( item );
							if( pFormat == NULL ){
								if( data_type == 0 ){
									pFormat = new CanFrameFormat( item, str_name, offset, len, str, (float)amp, (float)data_offset );
								} else if( data_type == 1 ){
//									pFormat = new CanFrameFormat( item, str_name, offset, len, str, (unsigned long long)amp, (unsigned long long)data_offset );
									pFormat = new CanFrameFormat( item, str_name, offset, len, str, (float)amp, (unsigned long long)data_offset );
								} else {
//									pFormat = new CanFrameFormat( item, str_name, offset, len, str, (long long)amp, (long long)data_offset );
									pFormat = new CanFrameFormat( item, str_name, offset, len, str, (float)amp, (long long)data_offset );
								}
								ret = pFunction->formatAdd( pFormat );
							} else {
								pFormat->no = item;
								pFormat->name = str_name;
								pFormat->bitOffset = offset;
								pFormat->bitLen = len;
								pFormat->denomination = str;
								if( data_type == 0 ){
									pFormat->format.f.offset = (float)data_offset;
									pFormat->format.f.amplification = (float)amp;
									pFormat->type = CAN_FORMAT_TYPE_FLOAT;
								} else if( data_type == 1 ){
									pFormat->format.u.offset = (unsigned long long)data_offset;
//									pFormat->format.u.amplification = (unsigned long long)amp;
									pFormat->format.u.amplification = (float)amp;
									pFormat->type = CAN_FORMAT_TYPE_UINT;
								} else {
									pFormat->format.i.offset = (long long)data_offset;
//									pFormat->format.i.amplification = (long long)amp;
									pFormat->format.i.amplification = (float)amp;
									pFormat->type = CAN_FORMAT_TYPE_INT;
								}
							}
						}
					}
					if( error_flag == 1 ){
						qt_str = "Error: Format Initialize Illegal Value!";
						qt_ret = QMessageBox::warning(this, tr("FormatInit"),
														qt_str,
														QMessageBox::Yes | QMessageBox::Default);
						break;
					}
				}
				FormatFile.close();
				ViewFormat();
			} else {
				msgBox.setText("Can not open file :" + coords[1]);
				ret = msgBox.exec();
			}
		}
		qt_ret = "";
	// Save Initialize Mode 
	} else {
		qt_ret = FormatLoadSettingMode + "," + FormatLoadSettingName + "\n";
	}

	return qt_ret;

}

// ViewFormat
void RxDataFormat::ViewFormat()
{
	int loop;
	int node_loop;
	int cob_loop;
	int item_loop;
	int node_num;
	int cob_num;
	int item_num;
	int row_max;
	int qt_int;
	int qint;
	unsigned int quint;
	float qfloat;
	QString cob_no_str;
	QString cob_name_str;
	QString node_no_str;
	QString node_name_str;
	QString item_no_str;
	QString item_name_str;
	QString bit_offset_str;
	QString bit_length_str;
	QString type_str;
	QString denomi_str;
	QString amp_str;
	QString data_offset_str;
	QString * nodeStr;
	QString * funcStr;
	QString * itemStr;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;
	QTableWidgetItem * pItem[12];


	// Clear Item
	row_max = ui.tblView->rowCount();
	for( loop = row_max-1; loop >= 0; loop=loop-1 ){
		ui.tblView->removeRow(loop);
	}
	row_max = 0;

	// Get Node Num
	node_num = pCanFrame->nodeNum( );
	for( node_loop = 0; node_loop < node_num; node_loop=node_loop+1){
		// Node Id
		qt_int = pCanFrame->nodeID( node_loop );
		node_no_str.sprintf("%08X", qt_int );
		// Node Name
		nodeStr = new QString();
		pCanFrame->nodeName( node_loop, * nodeStr );
		node_name_str = * nodeStr;
		// Node Get
		pNode = pCanFrame->nodeSearch( qt_int );
		// Cob Num Get
		cob_num = pNode->functionNum( );
		for( cob_loop = 0; cob_loop < cob_num; cob_loop=cob_loop+1){
			// Cob Id
			qt_int = pNode->functionCode( cob_loop );
			cob_no_str.sprintf("%08X", qt_int );
			// Cob Name
			funcStr = new QString();
			pNode->functionName( cob_loop, * funcStr );
			cob_name_str = * funcStr;
			// Function Get
			pFunction = pNode->functionSearch( qt_int );
			// Item Num Get
			item_num = pFunction->formatNum( );
			for( item_loop = 0; item_loop < item_num; item_loop=item_loop+1){
				// Item No
				qt_int = pFunction->formatNo( item_loop );
				item_no_str.sprintf("%02d", qt_int );
				// Item Name
				itemStr = new QString();
				pFunction->formatName( item_loop, * itemStr );
				item_name_str = * itemStr;
				// Format Get
				pFormat = pFunction->formatGet( qt_int );

				if( pFormat->type == CAN_FORMAT_TYPE_FLOAT ){
					// BitOffset
					qint = pFormat->bitOffset;
					bit_offset_str.sprintf("%02d", qint );
					// BitLength
					qint = pFormat->bitLen;
					bit_length_str.sprintf("%02d", qint );
					// type
					type_str = "FLOAT";
					// denomination
					denomi_str = pFormat->denomination;
					// amplification
					qfloat = pFormat->format.f.amplification;
					amp_str.sprintf("%3.4f", qfloat );
					// dataoffset
					qfloat = pFormat->format.f.offset;
					data_offset_str.sprintf("%3.4f", qfloat );
				} else if( pFormat->type == CAN_FORMAT_TYPE_UINT ){
					// BitOffset
					qint = pFormat->bitOffset;
					bit_offset_str.sprintf("%02d", qint );
					// BitLength
					qint = pFormat->bitLen;
					bit_length_str.sprintf("%02d", qint );
					// type
					type_str = "UINT";
					// denomination
					denomi_str = pFormat->denomination;
					// amplification
//					quint = pFormat->format.u.amplification;
//					amp_str.sprintf("%08d", quint );
					qfloat = pFormat->format.u.amplification;
					amp_str.sprintf("%3.4f", qfloat );
					// dataoffset
					quint = pFormat->format.u.offset;
					data_offset_str.sprintf("%08d", quint );
				} else {
					// BitOffset
					qint = pFormat->bitOffset;
					bit_offset_str.sprintf("%02d", qint );
					// BitLength
					qint = pFormat->bitLen;
					bit_length_str.sprintf("%02d", qint );
					// type
					type_str = "INT";
					// denomination
					denomi_str = pFormat->denomination;
					// amplification
//					qint = pFormat->format.i.amplification;
//					amp_str.sprintf("%08d", qint );
					qfloat = pFormat->format.i.amplification;
					amp_str.sprintf("%3.4f", qfloat );
					// dataoffset
					qint = pFormat->format.i.offset;
					data_offset_str.sprintf("%08d", qint );
				}

				// QTableWidget Create
				ui.tblView->setRowCount(row_max+1);
				for(loop = 0; loop < 12; loop=loop+1 ){
					pItem[loop] = new QTableWidgetItem();
					ui.tblView->setItem(row_max, loop, pItem[loop]);
				}
				row_max = row_max + 1;
				pItem[0]->setText(cob_no_str);
				pItem[1]->setText(cob_name_str);
				pItem[2]->setText(node_no_str);
				pItem[3]->setText(node_name_str);
				pItem[4]->setText(item_no_str);
				pItem[5]->setText(item_name_str);
				pItem[6]->setText(bit_offset_str);
				pItem[7]->setText(bit_length_str);
				pItem[8]->setText(type_str);
				pItem[9]->setText(denomi_str);
				pItem[10]->setText(amp_str);
				pItem[11]->setText(data_offset_str);

				ui.tblView->resizeColumnsToContents();
				ui.tblView->resizeRowsToContents();

			}
		}
	}

}
void RxDataFormat::DelFormat()
{
	int row;
	QString qt_str;

	row = ui.tblView->currentRow();
	qt_str.sprintf("%d", (row+1));
	qt_str = "Do you really delete RowItem = " + qt_str + " ?";
	int qt_ret = QMessageBox::warning(this, tr("RxDataFormatDelate"),
										qt_str,
										QMessageBox::Yes,
										QMessageBox::No | QMessageBox::Default);
	if( qt_ret == QMessageBox::Yes ){
		ui.tblView->removeRow(row);
		DelFormatAll();
		ViewFormatWrite();
	}

}
void RxDataFormat::DelFormatAll()
{
	int node;
	int node_id;
	int lp_node;
	int func;
	int func_code;
	int lp_func;
	int item;
	int lp_item;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;

	node = pCanFrame->nodeNum( );
	for( lp_node = node-1; lp_node >= 0; lp_node=lp_node-1){
		node_id = pCanFrame->nodeID( lp_node );
		pNode = pCanFrame->nodeSearch( node_id );
		func = pNode->functionNum( );
		for( lp_func = func-1; lp_func >= 0; lp_func=lp_func-1){
			func_code = pNode->functionCode( lp_func );
			pFunction = pNode->functionSearch( func_code );
			item = pFunction->formatNum( );
			for( lp_item = item-1; lp_item >= 0; lp_item=lp_item-1){
				pFunction->formatDeleteIndex( lp_item );
			}
			pNode->functionDelete( lp_func );
		}
		pCanFrame->nodeDelete( lp_node );
	}

}
void RxDataFormat::ViewFormatWrite()
{
	int row;
	int lp_row;
	int node;
	int node_chg;
	int func;
	int func_chg;
	int item;
	int offset;
	int data_type;
	int len;
	int ret;
	int error_flag;
	float amp;
	float data_offset;
	QTableWidgetItem * pItem;
	QString qt_str;
	QString qt_str_node;
	QString qt_str_node_old;
	QString qt_str_node_new;
	QString qt_str_func;
	QString qt_str_func_old;
	QString qt_str_func_new;
	QString qt_str_name;
	QString qt_str_denomi;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;

	error_flag = 0;
	row = ui.tblView->rowCount();
	node_chg = 0xffff;
	func_chg = 0xffff;

	for( lp_row = 0; lp_row < row; lp_row=lp_row+1 ){
		// Node
		pItem = ui.tblView->item(lp_row, 2);
		qt_str = pItem->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			node = qt_str.toUInt(0,16);
			pItem = ui.tblView->item(lp_row, 3);
			qt_str_node = pItem->text();
			pNode = pCanFrame->nodeSearch( node );
			if( pNode == NULL ){
				pCanFrame->nodeAdd( node, qt_str_node );
			} else {
				qt_str = pNode->name;
				if( qt_str != qt_str_node && node_chg != node){
					qt_str = "Do you change Node Name? old name(" + qt_str + ") -> new name(" + qt_str_node + ")";
					ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
												qt_str,
												QMessageBox::Yes,
												QMessageBox::No | QMessageBox::Default);
					if( ret == QMessageBox::Yes ){
						pNode->name = qt_str_node;
						node_chg = node;
					}
				}
			}
			pNode = pCanFrame->nodeSearch( node );
		}
		// CobID
		pItem = ui.tblView->item(lp_row, 0);
		qt_str = pItem->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			func = qt_str.toUInt(0,16);
			pItem = ui.tblView->item(lp_row, 1);
			qt_str_func = pItem->text();
			pFunction = pNode->functionSearch( func );
			if( pFunction == NULL ){
				pNode->functionAdd( func, qt_str_func );
			} else {
				qt_str = pFunction->m_name;
				if( qt_str != qt_str_func && func_chg != func ){
					qt_str = "Do you change CobID Name? old name(" + qt_str + ") -> new name(" + qt_str_func + ")";
					ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
												qt_str,
												QMessageBox::Yes,
												QMessageBox::No | QMessageBox::Default);
					if( ret == QMessageBox::Yes ){
						pFunction->m_name = qt_str_func;
						func_chg = func;
					}
				}
			}
			pFunction = pNode->functionSearch( func );
		}
		// Item
		pItem = ui.tblView->item(lp_row, 4);
		qt_str = pItem->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			item = qt_str.toUInt(0,10);
		}
		pItem = ui.tblView->item(lp_row, 5);
		qt_str_name = pItem->text();

		// BitOffset
		pItem = ui.tblView->item(lp_row, 6);
		qt_str = pItem->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			offset = qt_str.toUInt(0,10);
		}

		// BitLength
		pItem = ui.tblView->item(lp_row, 7);
		qt_str = pItem->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			len = qt_str.toUInt(0,10);
		}

		// Type
		pItem = ui.tblView->item(lp_row, 8);
		qt_str = pItem->text();
		if( qt_str == "FLOAT" ){
			data_type = 0;
		} else if( qt_str == "UINT" ){
			data_type = 1;
		} else {
			data_type = 2;
		}

		// Denomination
		pItem = ui.tblView->item(lp_row, 9);
		qt_str_denomi = pItem->text();

		// Amplitication
		pItem = ui.tblView->item(lp_row, 10);
		qt_str = pItem->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			amp = qt_str.toFloat();
		}

		// DataOffset
		pItem = ui.tblView->item(lp_row, 11);
		qt_str = pItem->text();
		ret = ValueCheck(qt_str);
		if( ret == 1 ){
			error_flag = 1;
		} else {
			data_offset = qt_str.toFloat();
		}

		// FormatSet
		if( error_flag == 0 ){
			pFormat = pFunction->formatGet( item );
			if( pFormat == NULL ){
				if( data_type == 0 ){
					pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (float)amp, (float)data_offset );
				} else if( data_type == 1 ){
//					pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (unsigned long long)amp, (unsigned long long)data_offset );
					pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (float)amp, (unsigned long long)data_offset );
				} else {
//					pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (long long)amp, (long long)data_offset );
					pFormat = new CanFrameFormat( item, qt_str_name, offset, len, qt_str_denomi, (float)amp, (long long)data_offset );
				}
				ret = pFunction->formatAdd( pFormat );
			} else {
				qt_str = "Do you change Item( " + qt_str_name + ") ?";
				ret = QMessageBox::warning(this, tr("RxDataFormatSet"),
											qt_str,
											QMessageBox::Yes,
											QMessageBox::No | QMessageBox::Default);
				if( ret == QMessageBox::Yes ){
					pFormat->no = item;
					pFormat->name = qt_str_name;
					pFormat->bitOffset = offset;
					pFormat->bitLen = len;
					pFormat->denomination = qt_str_denomi;
					if( data_type == 0 ){
						pFormat->format.f.offset = (float)data_offset;
						pFormat->format.f.amplification = (float)amp;
						pFormat->type = CAN_FORMAT_TYPE_FLOAT;
					} else if( data_type == 1 ){
						pFormat->format.u.offset = (unsigned long long)data_offset;
//						pFormat->format.u.amplification = (unsigned long long)amp;
						pFormat->format.u.amplification = (float)amp;
						pFormat->type = CAN_FORMAT_TYPE_UINT;
					} else {
						pFormat->format.i.offset = (long long)data_offset;
//						pFormat->format.i.amplification = (long long)amp;
						pFormat->format.i.amplification = (float)amp;
						pFormat->type = CAN_FORMAT_TYPE_INT;
					}
				}
			}
		} else {
			qt_str = "Error: Format Initialize Illegal Value!";
			ret = QMessageBox::warning(this, tr("FormatInit"),
										qt_str,
										QMessageBox::Yes | QMessageBox::Default);
			break;
		}
	}

}
// tblView_CellClickd
void RxDataFormat::tblView_CellClicked(int row_gen, int column_gen)
{

	ui.tblView->selectRow(ui.tblView->currentRow());

}

// tblView_CellDoubleClickd
void RxDataFormat::tblView_CellDoubleClicked(int row_gen, int column_gen)
{
	DWORD row;
	DWORD col_loop;
	QTableWidgetItem * pItem;
	QString qt_str;

	ui.tblView->selectRow(ui.tblView->currentRow());

	row = ui.tblView->currentRow();
	for( col_loop = 0; col_loop < 12; col_loop=col_loop+1){
		pItem = ui.tblView->item(row, col_loop);
		qt_str = pItem->text();
		if( col_loop == 0 ){	     ui.txtCobId->setText(qt_str);
		} else if( col_loop == 1  ){ ui.txtCobIdName->setText(qt_str);
		} else if( col_loop == 2  ){ ui.txtNodeId->setText(qt_str);
		} else if( col_loop == 3  ){ ui.txtNodeName->setText(qt_str);
		} else if( col_loop == 4  ){ ui.txtItemNo->setText(qt_str);
		} else if( col_loop == 5  ){ ui.txtName->setText(qt_str);
		} else if( col_loop == 6  ){ ui.txtOffset->setText(qt_str);
		} else if( col_loop == 7  ){ ui.txtLength->setText(qt_str);
		} else if( col_loop == 9  ){ ui.txtDenomination->setText(qt_str);
		} else if( col_loop == 10 ){ ui.txtAmplification->setText(qt_str);
		} else if( col_loop == 11  ){ ui.txtDataOffset->setText(qt_str);
		}
		if( col_loop == 8 ){
			if( qt_str == "FLOAT"){
				ui.cbbDataType->setCurrentIndex(0);
			} else if( qt_str == "UINT"){
				ui.cbbDataType->setCurrentIndex(1);
			} else {
				ui.cbbDataType->setCurrentIndex(2);
			}
		}
	}

}

int RxDataFormat::ValueCheck(QString ValueString)
{
	int error_flag;
	int loop;
	int ValueLength;
	QString GetValue;

	error_flag = 1;
	ValueLength = ValueString.length();
	for( loop=0; loop<ValueLength; loop=loop+1 ){
		GetValue = ValueString[loop];
		if( "0" == GetValue ){        error_flag = 0;
		} else if( "1" == GetValue ){ error_flag = 0;
		} else if( "2" == GetValue ){ error_flag = 0;
		} else if( "3" == GetValue ){ error_flag = 0;
		} else if( "4" == GetValue ){ error_flag = 0;
		} else if( "5" == GetValue ){ error_flag = 0;
		} else if( "6" == GetValue ){ error_flag = 0;
		} else if( "7" == GetValue ){ error_flag = 0;
		} else if( "8" == GetValue ){ error_flag = 0;
		} else if( "9" == GetValue ){ error_flag = 0;
		} else if( "a" == GetValue ){ error_flag = 0;
		} else if( "b" == GetValue ){ error_flag = 0;
		} else if( "c" == GetValue ){ error_flag = 0;
		} else if( "d" == GetValue ){ error_flag = 0;
		} else if( "e" == GetValue ){ error_flag = 0;
		} else if( "f" == GetValue ){ error_flag = 0;
		} else if( "A" == GetValue ){ error_flag = 0;
		} else if( "B" == GetValue ){ error_flag = 0;
		} else if( "C" == GetValue ){ error_flag = 0;
		} else if( "D" == GetValue ){ error_flag = 0;
		} else if( "E" == GetValue ){ error_flag = 0;
		} else if( "F" == GetValue ){ error_flag = 0;
		} else if( "." == GetValue ){ error_flag = 0;
		} else {
			error_flag = 1;
			break;
		}
	}
	return error_flag;

}

////////////////////////////////////////
// Setting Menu
////////////////////////////////////////
void RxDataFormat::createMenus()
{
	QMenu   * pMenu;

	//File Menu
	pMenu = ui.menuBar->addMenu( tr("File") );
	SettingMenu.pMenu = pMenu;
    connect(pMenu, SIGNAL(aboutToShow()), this, SLOT(menu_triggered()));

	createMenuActions();

}
void RxDataFormat::createMenuActions()
{
	QAction * pAction;
	QString qt_str;

	/* Clear */
	SettingMenu.pMenu->clear( );
	
	/* Load File */
	pAction = new QAction( tr("Open RxDataFormat"), this );
	pAction->setShortcut(tr("Ctrl+O"));
	SettingMenu.pLoadFile = pAction;
	SettingMenu.pMenu->addAction( pAction );
    connect(pAction, SIGNAL(triggered()), this, SLOT(menu_loadfile()));

	/* Save File */
	pAction = new QAction( tr("Save RxDataFormat"), this );
	pAction->setShortcut(tr("Ctrl+S"));
	SettingMenu.pSaveFile = pAction;
	SettingMenu.pMenu->addAction( pAction );
    connect(pAction, SIGNAL(triggered()), this, SLOT(menu_savefile()));

}

////////////////////////////////////////
// Menu Action
////////////////////////////////////////
void RxDataFormat::menu_triggered()
{
	createMenuActions();
}
void RxDataFormat::menu_loadfile()
{
	DWORD loop;
	QString line;
	QString qt_ret;
	QString qt_str;
	QString qt_str_node;
	QString qt_str_func;
	QString qt_str_name;
	QString qt_str_denomi;
	int node;
	int func;
	int item;
	int offset;
	int data_type;
	int len;
	float amp;
	float data_offset;
	int ret;
	int count;
	int error_flag;
	CanFrameNode * pNode;
	CanFrameFunction * pFunction;
	CanFrameFormat * pFormat;
	QString str;
	QString str_name;
	QMessageBox msgBox;

	error_flag = 0;

	// FormatAllDelete
	DelFormatAll();

	// File Select
	QString fileName = QFileDialog::getOpenFileName(
														this,
					   									tr("Load File"),		// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter

	// File Open
	QFile LoadFile(fileName);

	// File Read
	if (LoadFile.open(QIODevice::ReadOnly)) {
		// File Name
		FormatLoadSettingMode = "1";
		FormatLoadSettingName = fileName;

		QTextStream in(&LoadFile);
		while (!in.atEnd()) {
			QString line = in.readLine();
			QStringList coords = line.split(",");
			count = coords.size();
			qt_str = coords[0];
			if( qt_str[0] != '#' && count < 12 ){
				error_flag = 1;
			}
			if( qt_str[0] != '#' && error_flag == 0 ){
				// Node Add
				ret = ValueCheck(coords[2]);
				if( ret == 1 ){
					error_flag = 1;
				} else if( error_flag == 0 ){
					node = coords[2].toUInt(0,16);
					str = coords[3];
					pNode = pCanFrame->nodeSearch( node );
					if( pNode == NULL ){
						pCanFrame->nodeAdd( node, str );
					}
					pNode = pCanFrame->nodeSearch( node );
				}
				// CobID Add
				ret = ValueCheck(coords[0]);
				if( ret == 1 ){
					error_flag = 1;
				} else if( error_flag == 0 ){
					func = coords[0].toUInt(0,16);
					str = coords[1];
					pFunction = pNode->functionSearch( func );
					if( pFunction == NULL ){
						pNode->functionAdd( func, str );
					}
				}
				// Data Type Select
				ret = ValueCheck(coords[8]);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					data_type = coords[8].toUInt(0,16);
				}
				// Item Add
				ret = ValueCheck(coords[4]);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					item = coords[4].toUInt(0,10);
				}
				str_name = coords[5];
				ret = ValueCheck(coords[6]);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					offset = coords[6].toUInt(0,10);
				}
				ret = ValueCheck(coords[7]);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					len = coords[7].toUInt(0,10);
				}
				str = coords[9];
				ret = ValueCheck(coords[10]);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					amp = coords[10].toFloat();
				}
				ret = ValueCheck(coords[11]);
				if( ret == 1 ){
					error_flag = 1;
				} else {
					data_offset = coords[11].toFloat();
				}
				if( error_flag == 0 ){
					pFunction = pNode->functionSearch( func );
					pFormat = pFunction->formatGet( item );
					if( pFormat == NULL ){
						if( data_type == 0 ){
							pFormat = new CanFrameFormat( item, str_name, offset, len, str, (float)amp, (float)data_offset );
						} else if( data_type == 1 ){
//							pFormat = new CanFrameFormat( item, str_name, offset, len, str, (unsigned long long)amp, (unsigned long long)data_offset );
							pFormat = new CanFrameFormat( item, str_name, offset, len, str, (float)amp, (unsigned long long)data_offset );
						} else {
//							pFormat = new CanFrameFormat( item, str_name, offset, len, str, (long long)amp, (long long)data_offset );
							pFormat = new CanFrameFormat( item, str_name, offset, len, str, (float)amp, (long long)data_offset );
						}
						ret = pFunction->formatAdd( pFormat );
					} else {
						pFormat->no = item;
						pFormat->name = str_name;
						pFormat->bitOffset = offset;
						pFormat->bitLen = len;
						pFormat->denomination = str;
						if( data_type == 0 ){
							pFormat->format.f.offset = (float)data_offset;
							pFormat->format.f.amplification = (float)amp;
							pFormat->type = CAN_FORMAT_TYPE_FLOAT;
						} else if( data_type == 1 ){
							pFormat->format.u.offset = (unsigned long long)data_offset;
//							pFormat->format.u.amplification = (unsigned long long)amp;
							pFormat->format.u.amplification = (float)amp;
							pFormat->type = CAN_FORMAT_TYPE_UINT;
						} else {
							pFormat->format.i.offset = (long long)data_offset;
//							pFormat->format.i.amplification = (long long)amp;
							pFormat->format.i.amplification = (float)amp;
							pFormat->type = CAN_FORMAT_TYPE_INT;
						}
					}
				}
			}
			if( error_flag == 1 ){
				qt_str = "Error: Format Initialize Illegal Value!";
				qt_ret = QMessageBox::warning(this, tr("FormatInit"),
												qt_str,
												QMessageBox::Yes | QMessageBox::Default);
				break;
			}
		}
		LoadFile.close();
		ViewFormat();
		pInformation->Information_set("");
		pInformation->Information_append("Load File :" + FormatLoadSettingName + " successfully Load");
	} else {
		pInformation->Information_set("");
		pInformation->Information_append("Load File :" + FormatLoadSettingName + " Not Open File!!");
	}

}
void RxDataFormat::menu_savefile()
{
	DWORD row_max;
	DWORD row_loop;
	DWORD col_loop;
	QTableWidgetItem * pItem;
	QString qt_str;
	QString line;

	// File Select
	QString fileName = QFileDialog::getSaveFileName(
														this,
					   									tr("Save File"),		// title
//														QDir::homePath(),		// \Ƃ̃Jgpath
														QDir::currentPath(),	// \Ƃ̃Jgpath
														tr("All Files (*)"));	// filter

	// File Open
	QFile SaveFile(fileName);

	// File Write
	if(SaveFile.open(QIODevice::WriteOnly)) {
		QTextStream outputfile(&SaveFile);

		row_max = ui.tblView->rowCount();
		for( row_loop = 0; row_loop < row_max; row_loop=row_loop+1 ){
			line = "";
			for( col_loop = 0; col_loop < 12; col_loop=col_loop+1){
				pItem = ui.tblView->item(row_loop, col_loop);
				qt_str = pItem->text();
				if( col_loop == 8 ){
					if( qt_str == "FLOAT" ){
						line = line + "0" + ",";
						qt_str = "0";
					} else if( qt_str == "UINT" ){
						line = line + "1" + ",";
					} else {
						line = line + "2" + ",";
					}
				} else if( col_loop == 11 ){
					line = line + qt_str + "\n";
				} else {
					line = line + qt_str + ",";
				}
			}
			outputfile << line;
		}
		// File Close
		SaveFile.close();
		// File Close
		pInformation->Information_append("Save File successfully");
	} else {
		pInformation->Information_append("Can not open save file");
	}

}

