#ifndef RXDATAFORMAT_H
#define RXDATAFORMAT_H

#include <QtGui>
#include <QWidget>
#include "ui_rxdataformat.h"
#include "information.h"
#include "CanFrame.h"

class FCAN_View;

class RxDataFormat : public QWidget
{
	Q_OBJECT

public:
	RxDataFormat(QWidget *parent = 0);
	~RxDataFormat();

	void CanFrameSet( CanFrame * canframe );
	void InformationSet( Information * information );
	void FcanViewSet( FCAN_View * fcanview );
	void ViewFormat();
	QString RxDataFormatInit(int mode, QString line);

private slots:
	// btnSetFormat
	void btnSetFormat_Click();
	// btnOverWriteFormat
	void btnOverWriteFormat_Click();
	// btnDeleteFormat
	void btnDeleteFormat_Click();
	// btnDeleteAllFormat
	void btnDeleteAllFormat_Click();
	// File Menu
	void menu_triggered( );
	// Load File
	void menu_loadfile( );
	// Save File
	void menu_savefile( );
	// tblView_CellClickd
	void tblView_CellClicked(int row, int column);
	// tblView_CellDoubleClickd
	void tblView_CellDoubleClicked(int row, int column);
	// Close
	void closeEvent( QCloseEvent * event );
	// resizeEvent
    void resizeEvent(QResizeEvent *event);
	// keyPressEvent
    void keyPressEvent(QKeyEvent *event);


private:
	Ui::RxDataFormat ui;

	CanFrame * pCanFrame;
	Information * pInformation;
	FCAN_View * pFcanView;

	void DelFormat();
	void DelFormatAll();
	void ViewFormatWrite();
	void createMenus();
	void createMenuActions();
	int ValueCheck(QString ValueString);


	QString FormatLoadSettingMode;
	QString FormatLoadSettingName;

	struct {
		QMenu * pMenu;
		QAction * pLoadFile;
		QAction * pSaveFile;
	} SettingMenu;

};

#endif // RXDATAFORMAT_H
