fcf.module({
  name: "fcfManagement:templates/pages/translations/settings-tab.receive.js",
  dependencies: [],
  module: function(){
    return class Handler {
      receive(a_fields, a_files){
        let lastLanguage = fcf.application.getSystemVariable("fcf", "defaultLanguage");

        return fcf.actions()
        .then(()=>{
          fcf.application.setSystemVariable("fcf:languages", a_fields.languages);
        })
        .then(()=>{
          let li = fcf.application.getSystemVariable("fcf:languageIdentification");
          li.byPrefix = a_fields.byPrefix;
          li.byCookie = a_fields.byCookie;
          li.byParameter = a_fields.byParameter;
          li.parameter = a_fields.parameter;
          li.byHTTP = a_fields.byHTTP;
          return fcf.application.setSystemVariable("fcf:languageIdentification", li);
        })
        .then(()=>{
          return fcf.application.setSystemVariable("fcf:defaultLanguage", a_fields.defaultLanguage);
        })
        .then(()=>{
          return fcf.application.getEventChannel().send("fcfManagement_translations");
        })
        .then(function(){
          return fcf.application.getEventChannel().send("fcfserver_restart_processes", {}, {inner: true})
            .then(()=>{});
        })
        .catch((a_error)=>{
          fcf.log.err("FCF:MANAGER", "Failed to set default language: ", a_error);
        });
      }
    }
  }
});
