fcf.module({
  name: "fcfDBControls:templates/list.hooks.js",
  dependencies: [],
  module: function(){
    return {
      //
      // void hookBeforeBuild(a_taskInfo)
      // The hook is executed before assembling the template arguments
      //
      // hookBeforeBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after assembling the template arguments
      //
      // hookAfterBuild: function(a_taskInfo) {
      // },

      //
      // void hookAfterBuild(a_taskInfo)
      // The hook is executed after building the template's system arguments
      //
      // hookAfterSystemBuild: function(a_taskInfo) {
      // },

      //
      // Object of hooks for programmatically populated arguments
      //
      hooksProgrammableArgument: {
        //
        // @result Returns the value of an argument or a Promise object
        //
        value: async (a_taskInfo) => {
          let offset = fcf.max(a_taskInfo.args.page-1, 0) * a_taskInfo.args.capacity;
          let records = await fcf.application.getStorage().query(
                          {
                            type:            "select",
                            fields:          [{field: "*"}],
                            from:            a_taskInfo.args.projection,
                            language:        fcf.getContext().language,
                            defaultLanguage: true,
                            offset:          offset,
                            limit:           a_taskInfo.args.capacity,
                          });
          let result = [];
          for (let i = 0; i < a_taskInfo.args.capacity; ++i)
            result[i + offset] = records[0][i];
          return result;
        },
        pageCount: async (a_taskInfo)=>{
          let records = await fcf.application.getStorage().query(
                          {
                            type:            "select",
                            fields:          [{function: "count", as: "count"}],
                            from:            a_taskInfo.args.projection,
                          });
          return records[0][0].count ? fcf.max(Math.floor((records[0][0].count-1) / a_taskInfo.args.capacity)+1, 1)
                                     : 0;
        },
        fields: async (a_taskInfo)=>{
          let projection = fcf.application.getProjections().get(a_taskInfo.args.projection);
          return projection ? projection.fields : [];
        }
      },

      //
      // Object of the hooks preprocessing of the template arguments
      //
      // hooksBeforeArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   ARG_NAME: (a_taskInfo)=>{
      //   }
      // },

      //
      // Object of the hooks postprocessing of the template arguments
      // hooksAfterArgument: {
      //   //
      //   // @result Can return the value of an argument or Promise or undefined
      //   //
      //   ARG_NAME: (a_taskInfo)=>{
      //   }
      // },
    };
  }
});
