fcf.module({
  name: "fcfManagement:templates/pages/access/tabs/users.wrapper.js",
  dependencies: ["fcf:NClient/Wrapper.js"],
  module: function(Wrapper){
    return class UsersWrapper extends Wrapper{
      
      constructor(a_initializeOptions){
        super(a_initializeOptions);
      }

      onView(a_recordId){
        fcf.application.render({
          template: "@controls:dialog",
          owner:    this,
          args: {
            fcfStyle:     "width: 100%; min-width: 300px; max-width: 800px",
            title:        fcf.t("Viewing an entry"),
            content:      fcf.argTmpl("@dbcontrols:form", {
              mode:         "read",
              projection:   this.getArg("userProjection"),
              key:          a_recordId,
              fields:       this.getArg("userFieldsReadMode"),
            }),
          }
        })
      }

      onEdit(a_recordId){
        fcf.application.render({
          template: "@controls:dialog",
          owner:    this,
          args: {
            fcfStyle:     "width: 100%; min-width: 300px; max-width: 800px",
            title:        fcf.t("Viewing an entry"),
            content:      fcf.argTmpl("@dbcontrols:form", {
              fcfAlias:     "form",
              mode:         "edit",
              projection:   this.getArg("userProjection"),
              key:          a_recordId,
              fields:       this.getArg("userFieldsEditMode"),
            }),
            buttons:      fcf.argVal([
              fcf.argTmpl("@controls:button", { title: fcf.t("Edit"), fcfEventClick: "parent.getParent().onEditComplate(parent)"} ),
              fcf.argTmpl("@controls:button", { title: fcf.t("Cancel"), fcfEventClick: "parent.close('close')"} ),
            ]),
          }
        })
      }

      onEditComplate(a_dialog){
        let self = this;
        let form = a_dialog.getChild("form");
        let errors = form.check();
        if (!fcf.empty(errors)){
          form.setArg("errors", errors);
          return;
        }
        return form.write()
        .then(()=>{
          a_dialog.close();
          self.update();
        })
      }

      onRemove(a_recordId){
        let records = this.getChild("table").getArg("value");
        let record  = records[fcf.find(records, (a_key, a_record)=>{ return a_record["@key"] == a_recordId})];

        fcf.application.render({
          template: "@controls:dialog",
          owner:    this,
          args: {
            title:        fcf.t("Record deletion"),
            content:      fcf.tokenize(fcf.t("To remove user @{{user}}@?"), {user: record["@title"]}),
            buttons:      fcf.argVal([
              fcf.argTmpl("@controls:button", { title: fcf.t("Remove"),    fcfEventClick: "parent.getParent().onRemoveComplate(parent, '" + a_recordId + "')"} ),
              fcf.argTmpl("@controls:button", { title: fcf.t("Cancel"),    fcfEventClick: "parent.close('cancel')"} ),
            ]),
          }
        })
      }

      onRemoveComplate(a_dialog, a_recordId){
        let self = this;
        this.send({action: "remove", id: a_recordId})
        .then(()=>{
          a_dialog.close("ok");
          this.getChild("table").update();
        })
      }

      onNew(){
        fcf.application.render({
          template: "@controls:dialog",
          owner:    this,
          args: {
            fcfStyle:     "width: 100%; min-width: 300px; max-width: 800px",
            title:        fcf.t("Adding an entry"),
            content:      fcf.argTmpl("@dbcontrols:form", {
              fcfAlias:     "form",
              mode:         "add",
              projection:   this.getArg("userProjection"),
              fields:       this.getArg("userFieldsEditMode"),
            }),
            buttons:      fcf.argVal([
              fcf.argTmpl("@controls:button", { title: fcf.t("Create"), fcfEventClick: "parent.getParent().onNewComplete(parent)"} ),
              fcf.argTmpl("@controls:button", { title: fcf.t("Cancel"), fcfEventClick: "parent.close('close')"} ),
            ]),
          }
        })
      }

      onNewComplete(a_dialog){
        let self = this;
        let form = a_dialog.getChild("form");
        let errors = form.check();
        if (!fcf.empty(errors)){
          form.setArg("errors", errors);
          return;
        }
        return form.write()
        .then(()=>{
          a_dialog.close();
          self.update();
        })
      }

    };
  }
});
