fcf.module({
  name:         "NBase/functions.js",
  dependencies: ["fcf:NTest/uniTest.js"],
  lazy:         [],
  module: function(uniTest){
    uniTest.add("NBase", "fcf.each() (async)", async ()=>{
      let result = [];
      await fcf.each([1,2,3,4,5,6,7,8,9], async (a_key, a_value) => {
        await fcf.actions()
        .then((a_res, a_act) => {
          setTimeout(() => {
            result.push(a_value);
            a_act.complete();
          }, 100);
        });
      });
      uniTest.equal(result, [1,2,3,4,5,6,7,8,9]);

      result = [];
      await fcf.each([1,2,3,4,5,6,7,8,9], async (a_key, a_value) => {
        if (a_value > 5)
          return false;
        await fcf.actions()
        .then((a_res, a_act) => {
          setTimeout(() => {
            result.push(a_value);
            a_act.complete();
          }, 100);
        });
      });
      uniTest.equal(result, [1,2,3,4,5]);

      result = [];
      await fcf.each(fcf.sortObject({4:0, 2:0, 1:0, 5:0, 3:0, 9:0, 8:0, 6:0, 7:0}), async (a_key, a_value) => {
        let actions = fcf.actions();
        if (a_key > 5)
          return false;
        await actions.then((a_res, a_act) => {
          setTimeout(() => {
            result.push(a_key);
            a_act.complete();
          }, 10);
        });
      });
      uniTest.equal(result, [1,2,3,4,5]);

      result = [];
      await fcf.each(fcf.sortObject({4:0, 2:0, 1:0, 5:0, 3:0, 9:0, 8:0, 6:0, 7:0}), async (a_key, a_value) => {
        let actions = fcf.actions();
        await actions.then((a_res, a_act) => {
          setTimeout(() => {
            result.push(a_key);
            a_act.complete();
          }, 10);
        });
      });
      uniTest.equal(result, [1,2,3,4,5,6,7,8,9]);


      result = [];
      await fcf.each({1:0, 2:0, 3:0, 4:0, 5:0, 6:0, 7:0, 8:0, 9:0}, async (a_key, a_value) => {
        let actions = fcf.actions();
        await actions.then((a_res, a_act) => {
          setTimeout(() => {
            result.push(a_key);
            a_act.complete();
          }, 10);
        });
      });
      uniTest.equal(result, [1,2,3,4,5,6,7,8,9]);

      result = [];
      await fcf.each({1:0, 2:0, 3:0, 4:0, 5:0, 6:0, 7:0, 8:0, 9:0}, async (a_key, a_value) => {
        if (a_key > 5)
          return false;
        let actions = fcf.actions();
        await actions.then((a_res, a_act) => {
          setTimeout(() => {
            result.push(a_key);
            a_act.complete();
          }, 10);
        });
      });
      uniTest.equal(result, [1,2,3,4,5]);


    })
  }
});

