fcf.module({
  name: "fcf:tests/NRender/block.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NRender/Render.js"],
  module: function(uniTest, Render, NDB) {

    uniTest.add("003 NRender" , "Block", function(a_tester) {
      var render = new Render({
        storage: undefined,
      });

      a_tester.actions.then(function(a_res, a_act) { render.render(
        {
          template: "fcf:tests/NRender/templates/001block.tmpl*block1",
          onResult: function(a_error, a_template) {

            uniTest.equal("<div>1</div>", a_template.content);
            a_act.complete();
          },
        }
      )});

      a_tester.actions.then(function(a_res, a_act) { render.render(
        {
          template: "fcf:tests/NRender/templates/001block.tmpl*block2",
          onResult: function(a_error, a_template) {
            uniTest.equal("<div>1</div><div>2</div><div>3</div>", a_template.content);
            a_act.complete();
          },
        }
      )});

      a_tester.actions.then(function(a_res, a_act) { render.render(
        {
          template: "fcf:tests/NRender/templates/001block.tmpl*block3",
          onResult: function(a_error, a_template) {
            uniTest.equal("<div>1</div><div>token</div><div>3</div>", a_template.content);
            a_act.complete();
          },
        }
      )});

      a_tester.actions.then(function(a_res, a_act) { render.render(
        {
          template: "fcf:tests/NRender/templates/001block.tmpl*block1",
          args: {
          },
          onResult: function(a_error, a_template) {
            uniTest.equal("<span class='fcfwrapper' id='" + fcf.getLastId() + "'><div>1</div></span>", a_template.content);
            a_act.complete();
          },
        }
      )});

      a_tester.actions.then(function(a_res, a_act) { render.render(
        {
          template: "fcf:tests/NRender/templates/001block.tmpl*block5",
          args: {
          },
          onResult: function(a_error, a_template) {
            uniTest.equal("|<div>test</div>|", a_template.content);
            a_act.complete();
          },
        }
      )});

    });

  }
});
