/*
 * $Id: PageConfig.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import java.util.ArrayList;

import feat2.FeatErrors;
import feat2.Response;
import feat2.impl.PageResponse;

/**
 * ページレスポンスの設定。
 * @author SUGIMOTO Ken-ichi
 */
public class PageConfig extends ResponseConfigBase {

    private String template;
    private ArrayList views;
    private Integer maxAge;

    // validateメソッドで有効になる変数 ---------------------------------------

    private FileLocator templateFile;


    // コンストラクタ ---------------------------------------------------------

    public PageConfig() {
        views = new ArrayList();
    }


    // プロパティ -------------------------------------------------------------

    public FileLocator getTemplateFile() {
        return templateFile;
    }

    public void addView(ViewConfig view) {
        views.add(view);
        view.setParent(this);
    }
    public ViewConfig[] getViews() {
        return (ViewConfig[])views.toArray(new ViewConfig[0]);
    }

    public Response getResponseInstance() {
        return new PageResponse(this);
    }

    public String getTemplate() {
        return template;
    }
    public void setTemplate(String template) {
        this.template = template;
    }

    public Integer getMaxAge() {
        return maxAge;
    }
    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }


    // Configのメソッド -------------------------------------------------------

    public String getElementName() {
        return "page";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = super.validate(errs);

        if ( ConfigUtil.validateRequired(template, "template", this, errs) ) {
            FileLocator templateDir = getFeatConfig().getAppRootLocator().newLocation(getFeatureConfig().getTemplatePath());
            templateFile = templateDir.newLocation(template);
        }
        else
            ret = false;

        // 子要素の検証

        ret = ret && ConfigUtil.validate(views.iterator(), errs);

        return ret;
    }


}
