/*
 * $Id: ResponseConfigBase.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2006/02/20
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.Response;
import feat2.config.type.Identifier;

/**
 * レスポンスの設定の基本クラス。
 * @author SUGIMOTO Ken-ichi
 */
abstract public class ResponseConfigBase extends Config {

    private Identifier name;

    public Identifier getName() {
        return name;
    }
    public void setName(Identifier name) {
        this.name = name;
    }

    abstract public Response getResponseInstance();

    public boolean validate(FeatErrors errs) {
        boolean ret = ConfigUtil.validateRequired(name, "name", this, errs);

        return ret;
    }


}
