/*
 * $Id: HTMLText.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/07/24
 */
package feat2.template;

/**
 * HTMLのテキスト。
 * @author SUGIMOTO Ken-ichi
 */
public interface HTMLText extends HTMLNode {
    /**
     * ノードに文字列をセットする。文字列はエスケープされる。
     * @param text
     */
    public void setText(String text);

    /**
     * 文字列をエスケープしないでセットする。
     * @param str String
     */
    public void setRawText(String str);

    /**
     * ノード内のテキストに文字列を追加する。文字列はエスケープされる。
     * @param text
     */
    public void addText(String text);

    /**
     * 文字列をエスケープしないで追加する。
     * @param str String
     */
    public void addRawText(String str);

    /**
     * テキストノード内の文字列を返す。エスケープされた文字は復元される。
     * @return
     */
    public String getText();

}