/*
 * $Id: OptionGroup.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/12/08
 */
package feat2.template.form;

import java.util.ArrayList;
import java.util.List;

import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.NodeFactory;
import feat2.template.NodeIterator;
import feat2.template.NodeTreeIterator;

/**
 * リストの選択肢のグループ。
 * @author SUGIMOTO Ken-ichi
 */
public class OptionGroup implements ListItem {

    private HTMLElement element;

    public OptionGroup(String label) {
        element = NodeFactory.createHTMLElement("optgroup", false);
        element.setAttribute("label", label);
    }

    public OptionGroup(HTMLElement element) {
        this.element = element;
    }

    public String getLabel() {
        return element.getAttribute("label");
    }

    public void setLabel(String label) {
        element.setAttribute("label", label);
    }

    public HTMLElement getElement() {
        return element;
    }

    public void addOption(Option option) {
        element.addChild(option.getElement());
    }

    public Option[] getOptions() {
        List itemList = new ArrayList();
        for(NodeIterator it = new NodeTreeIterator(element); it.hasNext(); ) {
            HTMLNode node = it.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement e = (HTMLElement)node;
                if ( e.getTagName().equalsIgnoreCase("option") ) {
                    itemList.add(new Option(e));
                }
            }
        }
        return (Option[])itemList.toArray(new Option[itemList.size()]);
    }
}
