/*
 * $Id: TextArea.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/12/18
 */
package feat2.template.form;

import feat2.template.HTMLElement;

/**
 * フォームのテキストエリア。
 * @author SUGIMOTO Ken-ichi
 */
public class TextArea implements FormControl {

    private HTMLElement element;

    TextArea(HTMLElement element) {
        this.element = element;
    }

    public void setValue(String value) {
        if ( value != null && value.length() > 0 )
            element.setText(value);
        else
            element.clear();
    }

    public void setValues(String[] values) {
        if ( values != null && values.length > 0 )
            setValue(values[0]);
    }

    public String getValue() {
        return element.getString();
    }

    public String[] getValues() {
        return new String[] {element.getString()};
    }

    public HTMLElement getElement() {
        return element;
    }

    public int getType() {
        return TYPE_TEXTAREA;
    }

}
