/*
 * $Id: HTMLNodeFactoryImpl.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/07/30
 */
package feat2.template.impl;

import feat2.template.HTMLDocument;
import feat2.template.HTMLElement;
import feat2.template.HTMLRemark;
import feat2.template.HTMLText;
import feat2.template.RemarkTextException;

/**
 * ノードのファクトリクラス。
 * @author SUGIMOTO Ken-ichi
 */
public class HTMLNodeFactoryImpl {

    //private static final Log log = LogFactory.getLog(HTMLNodeFactoryImpl.class);

    public static HTMLDocument createHTMLDocument() {
        return new HTMLElementImpl(true);
    }

    /**
     * どのツリーにも属さない要素ノードを作る。
     * @param tagName タグの名前
     * @param endTag 終了タグが必要ならtrue
     * @return
     */
    public static HTMLElement createHTMLElement(String tagName, boolean endTag) {
        return new HTMLElementImpl(tagName, true, endTag, false);
    }

    /**
     * どのツリーにも属さないテキストノードを作る。
     * @param text テキストノードに格納する文字列。この文字列はエスケープされる。nullを渡してもよい
     * @return
     */
    public static HTMLText createHTMLText(String text) {
        HTMLText ret = new HTMLTextImpl();
        ret.setRawText(text);
        return ret;
    }

    /**
     * どのツリーにも属さない注釈ノードを作る。
     * @param text 注釈ノードに格納する文字列。nullを渡してもよい
     * @return
     * @throws RemarkTextException
     */
    public static HTMLRemark createHTMLRemark(String text) throws RemarkTextException {
        HTMLRemark ret = new HTMLRemarkImpl(text);
        return ret;
    }

}
