/*
 * $Revision: 220 $ $Date: 2007-07-16 19:32:15 +0900 $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/7/29
 */

package feat2.template.impl;

import feat2.FeatRuntimeException;
import feat2.StringUtil;
import feat2.template.HTMLNode;
import feat2.template.HTMLRemark;
import feat2.template.NodeNotFoundException;
import feat2.template.RemarkTextException;

/**
 * コメントを表すクラス。
 */
public class HTMLRemarkImpl extends HTMLNodeImpl implements HTMLRemark {

    private String text;

    /**
     * 空のコメントノードを作成する。
     */
    HTMLRemarkImpl() {
        setDomNode(new DOMCommentImpl(this));
    }

    /**
     * 内容を指定してコメントノードを作成する。
     * @param str "&lt;!--", "--&gt;"を含まないコメントの内容のテキスト。
     * @throws RemarkTextException テキストの中に"--"が含まれている
     */
    HTMLRemarkImpl(String str) throws RemarkTextException {
        this();
        if ( str != null ) {
            if ( str.indexOf("--") > -1 ) {
                throw new RemarkTextException();
            }
            this.text = str;
        }
    }

    public void setText(String str) throws RemarkTextException {

        if ( str != null ) {

            if ( str.indexOf("--") > -1 ) {
                throw new RemarkTextException();
            }

            this.text = str;

        }

        else
            this.text = null;
    }

    public String getText() {
        return text;
    }

    public void addText(String str) throws RemarkTextException {
        if ( str != null ) {
            if ( str.indexOf("--") > -1 ) {
                throw new RemarkTextException();
            }
            this.text += str;
        }
    }

    public String toString() {
        if ( text != null )
            return StringUtil.unescapeHTMLText(text);
        else
            return "";
    }

    // HTMLNodeの実装 -----------------------------------------------------------

    public String getValue() {
        return getText();
    }

    public HTMLNode copy(boolean deep) {
        try {
            return new HTMLRemarkImpl(text);
        }
        catch (RemarkTextException ex) {
            throw new FeatRuntimeException(ex);
        }
    }

    public StringBuffer toHTML(StringBuffer buf) {
        if ( text != null ) {
            String t;
            try {
                t = StringUtil.correctJapaneseChars(text, getDocument().getEncoding());
            }
            catch (NodeNotFoundException ex) {
                t = text;
            }
            buf.append("<!--").append(t).append("-->");
        }
        return buf;
    }

    public int getNodeType() {
        return NODETYPE_REMARK;
    }

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public void setFirstChild(HTMLNode child) {
    }

}

