/*
 * $Revision: 220 $ $Date: 2007-07-16 19:32:15 +0900 $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日： 2005/7/29
 */

package feat2.template.impl;

import feat2.template.HTMLAttribute;
import feat2.template.HTMLNode;
import feat2.template.NodeNotFoundException;

/**
 * 属性の間にある空白文字列。
 */
public class HTMLWhitespaceAttribute extends HTMLNodeImpl implements HTMLAttribute {

    private String str;

    HTMLWhitespaceAttribute(String str) {
        this.str = str;
    }

    public void setText(String str) {
        this.str = str;
    }

    /**
     * 文字列を追加する。
     * @param str String
     */
    public void addText(String str) {
        this.str += str;
    }

    public String getText() {
        return str;
    }

    public String toString() {
        return str;
    }

    public void setFirstChild(HTMLNode child) {
    }

    // HTMLNodeの実装 -----------------------------------------------------------

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public String getValue() {
        return getText();
    }

    public HTMLNode copy(boolean deep) {
        return new HTMLWhitespaceAttribute(str);
    }

    public StringBuffer toHTML(StringBuffer buf) {
        return buf.append(str);
    }

    public int getNodeType() {
        return NODETYPE_ATTRIBUTE;
    }

}
