/*
 * $Id: IntValidator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 作成日: 2006/03/08
 */
package feat2.validation;

import java.util.Map;

import org.apache.commons.validator.GenericValidator;

/**
 * int型であることを検証する。
 * @author SUGIMOTO Ken-ichi
 */
public class IntValidator implements SingleValueValidator {

    public boolean validate(String value) {

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        return GenericValidator.isInt(value);

    }

    public String getDefaultMessageId() {
        return "error.validation.int";
    }

    public Map getKeyrowds() {
        return null;
    }

}
